/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import java.io.IOException;

class HuffmanTable {
    byte[] bits = new byte[17];
    int destination;
    int[] huffcode = new int[257];
    byte[] huffsize = new byte[257];
    byte[] huffval = new byte[256];
    int length;
    int[] maxcode = new int[18];
    int[] mincode = new int[17];
    int[] numbits = new int[256];
    int[] valptr = new int[17];
    int[] value = new int[256];
    static int[] bitMask = new int[]{-1, Integer.MAX_VALUE, 0x3FFFFFFF, 0x1FFFFFFF, 0xFFFFFFF, 0x7FFFFFF, 0x3FFFFFF, 0x1FFFFFF, 0xFFFFFF, 0x7FFFFF, 0x3FFFFF, 0x1FFFFF, 1048575, 524287, 262143, 131071, 65535, Short.MAX_VALUE, 16383, 8191, 4095, 2047, 1023, 511, 255, 127, 63, 31, 15, 7, 3, 1};

    HuffmanTable() {
    }

    public int read(byte[] inbuffer, int offset) throws IOException {
        int i;
        int index = 0;
        int count = 0;
        int beginOffset = offset;
        index = inbuffer[offset++];
        this.bits[0] = 0;
        count = 0;
        for (i = 1; i <= 16; ++i) {
            this.bits[i] = inbuffer[offset++];
            count += this.bits[i];
        }
        if (count > 256) {
            throw new RuntimeException("Bogus DHT counts");
        }
        for (i = 0; i < count; ++i) {
            this.huffval[i] = inbuffer[offset++];
        }
        this.length -= 17 + count;
        if ((index & 0x10) == 16) {
            throw new RuntimeException("Huffman table for lossless JPEG is not defined");
        }
        this.destination = index;
        if (index < 0 || index >= 4) {
            throw new RuntimeException("Bogus DHT index " + index);
        }
        int k = 0;
        int i2 = 1;
        int j = 1;
        for (i2 = 1; i2 <= 16; ++i2) {
            for (j = 1; j <= this.bits[i2]; ++j) {
                this.huffsize[k++] = (byte)i2;
            }
        }
        this.huffsize[k] = 0;
        int lastk = k;
        int code = 0;
        int si = this.huffsize[0];
        k = 0;
        while (this.huffsize[k] != 0) {
            while (this.huffsize[k] == si) {
                this.huffcode[k++] = code++;
            }
            code <<= 1;
            ++si;
        }
        j = 0;
        for (i2 = 1; i2 <= 16; ++i2) {
            if (this.bits[i2] != 0) {
                this.valptr[i2] = j;
                this.mincode[i2] = this.huffcode[j];
                this.maxcode[i2] = this.huffcode[(j += this.bits[i2]) - 1];
                continue;
            }
            this.maxcode[i2] = -1;
        }
        for (k = 0; k < lastk; ++k) {
            int size = this.huffsize[k];
            if (size > 8) continue;
            int val = this.huffval[k];
            code = this.huffcode[k];
            int ll = code << 8 - size;
            int ul = size < 8 ? ll | bitMask[24 + size] : ll;
            for (i2 = ll; i2 <= ul; ++i2) {
                this.numbits[i2] = size;
                this.value[i2] = val;
            }
        }
        return offset - beginOffset;
    }
}

