/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Jpeg14Encoder {
    private int huffPutBits = 0;
    private int huffPutBuffer = 0;
    private ByteArrayOutputStream out;
    private static final byte[] BITS = new byte[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final int DHT = 196;
    private static int[] ehufco = new int[257];
    private static byte[] ehufsi = new byte[257];
    private static final int EOI = 217;
    private static int[] huffcode = new int[257];
    private static byte[] huffsize = new byte[257];
    private static final byte[] HUFFVAL = new byte[]{0, 2, 3, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static int[] numBitsTable = new int[256];
    private static final int SOF3 = 195;
    private static final int SOI = 216;
    private static final int SOS = 218;

    private void emitBits(short code, int size) throws IOException {
        int putBits = size;
        int putBuffer = code & bmask[putBits];
        putBuffer <<= 24 - (putBits += this.huffPutBits);
        putBuffer |= this.huffPutBuffer;
        while (putBits >= 8) {
            int c = putBuffer >> 16 & 0xFF;
            this.emitByte(c);
            if (c == 255) {
                this.emitByte(0);
            }
            putBuffer <<= 8;
            putBits -= 8;
        }
        this.huffPutBuffer = putBuffer;
        this.huffPutBits = putBits;
    }

    private void emitByte(int c) throws IOException {
        this.out.write(c);
    }

    public byte[] encode16bitGrayscale(byte[] pixels, int width, int height) throws IOException {
        short s2;
        short s1;
        this.writeHeader(width, height, 16, 1);
        short s = (short)((pixels[1] << 8) + (pixels[0] & 0xFF));
        short diff = (short)(s - 32768);
        this.encodeOneDiff(diff);
        for (int i = 1; i < width; ++i) {
            s1 = (short)((pixels[2 * i + 1] << 8) + (pixels[2 * i] & 0xFF));
            s2 = (short)((pixels[2 * i - 1] << 8) + (pixels[2 * i - 2] & 0xFF));
            diff = (short)(s1 - s2);
            this.encodeOneDiff(diff);
        }
        for (int j = 1; j < height; ++j) {
            s1 = (short)((pixels[2 * width * j + 1] << 8) + (pixels[2 * width * j] & 0xFF));
            s2 = (short)((pixels[2 * width * (j - 1) + 1] << 8) + (pixels[2 * width * (j - 1)] & 0xFF));
            diff = (short)(s1 - s2);
            this.encodeOneDiff(diff);
            for (int i = 1; i < width; ++i) {
                s1 = (short)((pixels[2 * (width * j + i) + 1] << 8) + (pixels[2 * (width * j + i)] & 0xFF));
                s2 = (short)((pixels[2 * (width * j + i) - 1] << 8) + (pixels[2 * (width * j + i) - 2] & 0xFF));
                diff = (short)(s1 - s2);
                this.encodeOneDiff(diff);
            }
        }
        this.emitBits((short)127, 7);
        this.writeMarker(217, this.out);
        if (this.out.size() % 2 != 0) {
            this.out.write(0);
        }
        return this.out.toByteArray();
    }

    public byte[] encode16bitGrayscale(short[] pixels, int width, int height) throws IOException {
        this.writeHeader(width, height, 16, 1);
        short sh = pixels[0];
        short diff = (short)(pixels[0] - 32768);
        this.encodeOneDiff(diff);
        for (int i = 1; i < width; ++i) {
            diff = (short)(pixels[i] - pixels[i - 1]);
            this.encodeOneDiff(diff);
        }
        for (int j = 1; j < height; ++j) {
            diff = (short)(pixels[width * j] - pixels[width * (j - 1)]);
            this.encodeOneDiff(diff);
            for (int i = 1; i < width; ++i) {
                diff = (short)(pixels[width * j + i] - pixels[width * j + i - 1]);
                this.encodeOneDiff(diff);
            }
        }
        this.emitBits((short)127, 7);
        this.writeMarker(217, this.out);
        if (this.out.size() % 2 != 0) {
            this.out.write(0);
        }
        return this.out.toByteArray();
    }

    public byte[] encode24bitColor(byte[] red, byte[] green, byte[] blue, int width, int height) throws IOException {
        this.writeHeader(width, height, 8, 3);
        byte diff = (byte)(red[0] - 128);
        this.encodeOneDiff(diff);
        diff = (byte)(green[0] - 128);
        this.encodeOneDiff(diff);
        diff = (byte)(blue[0] - 128);
        this.encodeOneDiff(diff);
        for (int i = 1; i < width; ++i) {
            diff = (byte)(red[i] - red[i - 1]);
            this.encodeOneDiff(diff);
            diff = (byte)(green[i] - green[i - 1]);
            this.encodeOneDiff(diff);
            diff = (byte)(blue[i] - blue[i - 1]);
            this.encodeOneDiff(diff);
        }
        for (int j = 1; j < height; ++j) {
            diff = (byte)(red[width * j] - red[width * (j - 1)]);
            this.encodeOneDiff(diff);
            diff = (byte)(green[width * j] - green[width * (j - 1)]);
            this.encodeOneDiff(diff);
            diff = (byte)(blue[width * j] - blue[width * (j - 1)]);
            this.encodeOneDiff(diff);
            for (int i = 1; i < width; ++i) {
                diff = (byte)(red[width * j + i] - red[width * j + i - 1]);
                this.encodeOneDiff(diff);
                diff = (byte)(green[width * j + i] - green[width * j + i - 1]);
                this.encodeOneDiff(diff);
                diff = (byte)(blue[width * j + i] - blue[width * j + i - 1]);
                this.encodeOneDiff(diff);
            }
        }
        this.emitBits((short)127, 7);
        this.writeMarker(217, this.out);
        if (this.out.size() % 2 != 0) {
            this.out.write(0);
        }
        return this.out.toByteArray();
    }

    public byte[] encode8bitGrayscale(byte[] pixels, int width, int height) throws IOException {
        this.writeHeader(width, height, 8, 1);
        byte diff = (byte)(pixels[0] - 128);
        this.encodeOneDiff(diff);
        for (int i = 1; i < width; ++i) {
            diff = (byte)(pixels[i] - pixels[i - 1]);
            this.encodeOneDiff(diff);
        }
        for (int j = 1; j < height; ++j) {
            diff = (byte)(pixels[width * j] - pixels[width * (j - 1)]);
            this.encodeOneDiff(diff);
            for (int i = 1; i < width; ++i) {
                diff = (byte)(pixels[width * j + i] - pixels[width * j + i - 1]);
                this.encodeOneDiff(diff);
            }
        }
        this.emitBits((short)127, 7);
        this.writeMarker(217, this.out);
        if (this.out.size() % 2 != 0) {
            this.out.write(0);
        }
        return this.out.toByteArray();
    }

    private void encodeOneDiff(int diff) throws IOException {
        if (Math.abs(diff) == 32768) {
            this.emitBits((short)-2, ehufsi[16]);
            return;
        }
        int temp2 = diff;
        int temp = temp2;
        if (temp < 0) {
            temp = -temp;
            --temp2;
        }
        int nbits = 0;
        if (temp != 0) {
            while (temp >= 256) {
                nbits += 8;
                temp >>= 8;
            }
            nbits += numBitsTable[temp & 0xFF];
        }
        this.emitBits((short)ehufco[nbits], ehufsi[nbits]);
        if (nbits != 0) {
            this.emitBits((short)temp2, nbits);
        }
    }

    private void writeHeader(int width, int height, int depth, int components) throws IOException {
        int i;
        this.out = new ByteArrayOutputStream();
        int frameheaderlength = 8 + 3 * components;
        int scanheaderlength = 6 + 2 * components;
        int huffmantablelength = 19;
        for (int i2 = 0; i2 < BITS.length; ++i2) {
            huffmantablelength += BITS[i2];
        }
        DataOutputStream dout = new DataOutputStream(this.out);
        this.writeMarker(216, this.out);
        this.writeMarker(195, this.out);
        dout.writeShort(frameheaderlength);
        this.out.write(depth);
        dout.writeShort(height);
        dout.writeShort(width);
        this.out.write(components);
        for (i = 0; i < components; ++i) {
            this.out.write(i);
            this.out.write(17);
            this.out.write(0);
        }
        this.writeMarker(196, this.out);
        dout.writeShort(huffmantablelength);
        this.out.write(0);
        for (i = 0; i < BITS.length; ++i) {
            this.out.write(BITS[i]);
        }
        for (i = 0; i < HUFFVAL.length; ++i) {
            this.out.write(HUFFVAL[i]);
        }
        this.writeMarker(218, this.out);
        dout.writeShort(scanheaderlength);
        this.out.write(components);
        for (i = 0; i < components; ++i) {
            this.out.write(i);
            this.out.write(0);
        }
        this.out.write(1);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeMarker(int marker, OutputStream out) throws IOException {
        out.write(255);
        out.write(marker);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int temp = i;
            int nbits = 1;
            while ((temp >>= 1) != 0) {
                ++nbits;
            }
            Jpeg14Encoder.numBitsTable[i] = nbits;
        }
        int k = 0;
        int i = 1;
        int j = 1;
        for (i = 0; i < 16; ++i) {
            for (j = 1; j <= BITS[i]; ++j) {
                Jpeg14Encoder.huffsize[k] = (byte)(i + 1);
                ++k;
            }
        }
        Jpeg14Encoder.huffsize[k] = 0;
        int lastk = k;
        int code = 0;
        int si = huffsize[0];
        k = 0;
        while (huffsize[k] != 0) {
            while (huffsize[k] == si) {
                Jpeg14Encoder.huffcode[k] = code++;
                ++k;
            }
            code <<= 1;
            ++si;
        }
        k = 0;
        do {
            i = HUFFVAL[k];
            Jpeg14Encoder.ehufco[i] = huffcode[k];
            Jpeg14Encoder.ehufsi[i] = huffsize[k];
        } while (++k < lastk);
    }
}

