/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DataElementValue;
import com.archimed.dicom.DumpUtils;
import java.io.Serializable;

public class ByteArray
implements Serializable,
DataElementValue {
    public static final int MAXLENGTH_BYTEARRAY = 0x7FFFFFF6;
    private byte[][] arrays;

    public ByteArray(byte[] ... arrays) {
        for (int i = 0; i < arrays.length; ++i) {
            if (arrays[i] != null) continue;
            throw new IllegalArgumentException("specified byte arrays must be non-null");
        }
        this.arrays = arrays;
    }

    public ByteArray(long capacity) {
        int numBackingArrays = (int)(capacity / 0x7FFFFFF6L + 1L);
        int lastArrayLength = (int)(capacity % 0x7FFFFFF6L);
        this.arrays = new byte[numBackingArrays][];
        for (int i = 0; i < numBackingArrays - 1; ++i) {
            this.arrays[i] = new byte[0x7FFFFFF6];
        }
        this.arrays[numBackingArrays - 1] = new byte[lastArrayLength];
    }

    public long length() {
        long length = 0L;
        for (int i = 0; i < this.arrays.length; ++i) {
            length += (long)this.arrays[i].length;
        }
        return length;
    }

    public int arrays() {
        return this.arrays.length;
    }

    public byte[] getArray(int index) {
        return this.arrays[index];
    }

    @Override
    public long getLength() {
        return this.length();
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        int len = this.getArray(0).length;
        if (len > 12) {
            len = 12;
        }
        for (int i = 0; i < len; ++i) {
            sb.append(DumpUtils.toHexString(this.arrays[0][i]));
        }
        if (len == 12) {
            sb.append("...");
        }
        return sb.toString();
    }

    public byte[] getBytes(long offset, int length) {
        if (offset > this.length()) {
            throw new IllegalArgumentException(String.format("offset %s exceeds total length of ByteArray %s", offset, this.length()));
        }
        if (offset + (long)length > this.length()) {
            throw new IllegalArgumentException(String.format("offset %s + length %s exceeds total length of ByteArray %s", offset, length, this.length()));
        }
        byte[] returnArray = new byte[length];
        int copied = 0;
        long pos = offset;
        int arrayIndex = 0;
        while (pos > (long)this.arrays[arrayIndex].length) {
            pos -= (long)this.arrays[arrayIndex].length;
            ++arrayIndex;
        }
        int currentPos = (int)pos;
        int destpos = 0;
        int lengthToCopy = 0;
        while (copied < length) {
            lengthToCopy = Math.min(this.arrays[arrayIndex].length - currentPos, length - copied);
            System.arraycopy(this.arrays[arrayIndex], currentPos, returnArray, destpos, lengthToCopy);
            copied += lengthToCopy;
            ++arrayIndex;
            currentPos = 0;
            destpos += lengthToCopy;
        }
        return returnArray;
    }

    ByteArray copy() {
        byte[][] copy = new byte[this.arrays()][];
        for (int i = 0; i < this.arrays(); ++i) {
            copy[i] = new byte[this.getArray(i).length];
            System.arraycopy(this.getArray(i), 0, copy[i], 0, this.getArray(i).length);
        }
        return new ByteArray(copy);
    }
}

