/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.BulkDataReference;
import com.archimed.dicom.ByteArray;
import com.archimed.dicom.ConvertUtils;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DicomWriter;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.GroupList;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.MultiVRInputStream;
import com.archimed.dicom.Offsets;
import com.archimed.dicom.Person;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.Sleutel;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.VR;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class DicomObject
extends GroupList {
    private static final long serialVersionUID = 1L;
    static final int SEQITEM_NEW = 1;
    static final int SEQITEM_UNDEFLEN = 2;
    static final int SEQITEM_DEFLEN = 3;
    DicomObject filemetainfo = null;
    long offset = 0L;
    long length = 0L;
    private DicomObject parent;
    private int seqItemLenState = 1;
    private byte[] preamble;
    protected transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
    private static final DicomCharset[] defaultCharsets = new DicomCharset[]{DicomCharset.DEFAULT};

    public DicomObject() {
        this(null);
    }

    DicomObject(DicomObject parent) {
        this.parent = parent;
    }

    private Object readResolve() throws ObjectStreamException {
        this.log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
        return this;
    }

    public DicomObject getParent() {
        return this.parent;
    }

    void setParent(DicomObject parent) {
        this.parent = parent;
    }

    public DicomCharset[] dicomCharsets() {
        int n;
        DicomObject dcm = this;
        while ((n = dcm.getSize(524293)) <= 0 && (dcm = dcm.getParent()) != null) {
        }
        if (n <= 0) {
            return defaultCharsets;
        }
        try {
            DicomCharset[] dicomCharsets = new DicomCharset[n];
            for (int i = 0; i < n; ++i) {
                String charsetString = dcm.getString(524293, i, true);
                dicomCharsets[i] = DicomCharset.lookup(charsetString);
                if (dicomCharsets[i] == null) {
                    this.log.warn("specified character set '" + charsetString + "' unknown,using default.");
                    return defaultCharsets;
                }
                if (i != 0 || dicomCharsets[0] != DicomCharset.DEFAULT) continue;
                dicomCharsets[0] = DicomCharset.ISO_2022_IR_6;
            }
            return dicomCharsets;
        }
        catch (DicomException ex) {
            this.log.error("Error while initializing character sets,reverting to default charset ", ex);
            return defaultCharsets;
        }
    }

    public void setSeqItemLenState(int state) {
        this.seqItemLenState = state;
    }

    public int getSeqItemLenState() {
        return this.seqItemLenState;
    }

    public void setPreamble(byte[] preamble) {
        if (preamble != null && preamble.length != 128) {
            throw new IllegalArgumentException("preamble must be exactly 128 bytes");
        }
        this.preamble = preamble;
    }

    public byte[] getPreamble() {
        return this.preamble;
    }

    public DataElement newDataElement(int dname) {
        DDictEntry de = DDict.getEntry(dname);
        VR vr2 = new VR(this, de.getGroup(), this.adjustElementForPrivateTag(dname, true), de.getType());
        this.push(vr2);
        return vr2;
    }

    public DataElement newDataElement_ge(int group, int element) {
        int t = DDict.getTypeCode(group, element);
        VR vr2 = new VR(this, group, element, t);
        this.push(vr2);
        return vr2;
    }

    public DataElement newDataElement_ge(int group, int element, String creator) throws DicomException {
        return this.newDataElement(this.lookupPrivateTag(group, element, creator));
    }

    private DataElement getDataElement(int dname, boolean create) {
        int element;
        int group = DDict.getGroup(dname);
        DataElement dataElement = this.getVR(group, element = this.adjustElementForPrivateTag(dname, create));
        if (dataElement == null && create) {
            dataElement = this.newDataElement(dname);
        }
        return dataElement;
    }

    private DataElement getDataElement(int group, int element, boolean create) {
        DataElement dataElement = this.getVR(group, element);
        if (dataElement == null && create) {
            dataElement = this.newDataElement_ge(group, element);
        }
        return dataElement;
    }

    private int adjustElementForPrivateTag(int dname, boolean create) {
        DDictEntry entry = DDict.getEntry(dname);
        if (entry == null) {
            throw new IllegalArgumentException("unknown DDict constant: " + dname);
        }
        int group = entry.getGroup();
        int element = entry.getElement();
        String creator = entry.getPrivateCreatorID();
        if (!DDictBase.isPrivateTag(group, 4096 + (0xFF & element))) {
            return element;
        }
        if (creator == null) {
            this.log.warn("Private Creator ID not set in DicomObject.Element number of private tag " + DumpUtils.tagString(group, element) + " will be unadjusted.");
            return element;
        }
        int free = -1;
        for (int i = 16; i <= 255; ++i) {
            String cr;
            if (this.getSize_ge(group, i) > 0) {
                try {
                    cr = this.getString_ge(group, i, 0);
                }
                catch (DicomException ex) {
                    this.log.warn("DicomException while getting private creator: " + ex);
                    return element;
                }
            } else {
                cr = null;
            }
            if (cr != null && creator.equals(cr)) {
                return i << 8 | element;
            }
            if (cr != null || free != -1) continue;
            free = i;
        }
        if (!create) {
            this.log.warn("Private Creator ID " + creator + " not found in DicomObject.Element number of private tag " + DumpUtils.tagString(group, element) + " will be unadjusted.");
            return element;
        }
        this.log.debug("adding new Private Creator ID " + creator + " at " + DumpUtils.tagString(group, free));
        try {
            this.setString_ge(group, free, creator, 0);
        }
        catch (DicomException ex) {
            this.log.warn("DicomException when setting private creator '" + creator + "', element unadjusted");
            return element;
        }
        return free << 8 | element;
    }

    private int checkPrivateCreatorExists(String creator, int group) throws DicomException {
        for (int i = 16; i <= 255; ++i) {
            String cr = this.getString_ge(group, i, 0);
            if (cr == null || !creator.equals(cr)) continue;
            return i << 8;
        }
        return -1;
    }

    private int lookupPrivateTag(int group, int element, String creator) throws DicomException {
        if (creator == null || creator.trim().equalsIgnoreCase("")) {
            throw new DicomException("creator cannot be null or empty");
        }
        if (!DDictBase.isPrivateTag(group, 4096 + (0xFF & element))) {
            throw new DicomException(String.format("group,element %s not in allowed range for private tag", DumpUtils.tagString(group, element)));
        }
        int dct = DDictBase.lookupDDict(group, element, creator);
        if (dct == -1) {
            throw new DicomException(String.format("referenced group,element %s not present in dictionary for private creator '%s'", DumpUtils.tagString(group, element), creator));
        }
        return dct;
    }

    private void addValue(int g, int e, int t, Object o, int i) throws DicomException {
        block67: {
            VR vr2 = (VR)this.getDataElement(g, e, true);
            vr2.dcm_type = t;
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("DicomObject.addValue <old>, index: %d, type: %s %s", i, o == null ? "null" : o.getClass().getName(), DumpUtils.tagDescriptionString(g, e)));
            }
            if (i > vr2.val.size()) {
                throw new DicomException(String.format("Index (%d) exceeds bounds of Data Element", i));
            }
            try {
                if (o == null) break block67;
                if (o instanceof String) {
                    switch (t) {
                        case 1: 
                        case 3: 
                        case 8: 
                        case 19: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 34: {
                            if (!o.equals("") || i != 0) break;
                            return;
                        }
                    }
                    if (i == vr2.size()) {
                        vr2.addString((String)o);
                    } else {
                        vr2.setString((String)o, i);
                    }
                    break block67;
                }
                if (o instanceof byte[]) {
                    if (i == vr2.size()) {
                        vr2.addBytes((byte[])o);
                    } else {
                        vr2.setBytes((byte[])o, i);
                    }
                    break block67;
                }
                if (o instanceof ByteArray) {
                    if (i == vr2.size()) {
                        vr2.addByteArray((ByteArray)o);
                    } else {
                        vr2.setByteArray((ByteArray)o, i);
                    }
                    break block67;
                }
                if (o instanceof BulkDataReference) {
                    if (i == vr2.size()) {
                        vr2.addBulkDataReference((BulkDataReference)o);
                    } else {
                        vr2.setBulkDataReference((BulkDataReference)o, i);
                    }
                    break block67;
                }
                if (o instanceof Integer) {
                    if (vr2.dcm_type == 21) {
                        vr2.dcm_type = 3;
                    }
                    if (i == vr2.size()) {
                        vr2.addInteger((Integer)o);
                    } else {
                        vr2.setInteger((Integer)o, i);
                    }
                    break block67;
                }
                if (o instanceof Float) {
                    if (i == vr2.size()) {
                        vr2.addFloat((Float)o);
                    } else {
                        vr2.setFloat((Float)o, i);
                    }
                    break block67;
                }
                if (o instanceof Double) {
                    if (i == vr2.size()) {
                        vr2.addDouble((Double)o);
                    } else {
                        vr2.setDouble((Double)o, i);
                    }
                    break block67;
                }
                if (o instanceof Person) {
                    if (i == vr2.size()) {
                        vr2.addPersonName((Person)o);
                    } else {
                        vr2.setPersonName((Person)o, i);
                    }
                    break block67;
                }
                if (o instanceof DDate) {
                    if (i == vr2.size()) {
                        vr2.addString(((DDate)o).toDICOMString());
                    } else {
                        vr2.setString(((DDate)o).toDICOMString(), i);
                    }
                    break block67;
                }
                if (o instanceof DDateRange) {
                    if (i == vr2.size()) {
                        vr2.addString(((DDateRange)o).toDICOMString());
                    } else {
                        vr2.setString(((DDateRange)o).toDICOMString(), i);
                    }
                    break block67;
                }
                if (o instanceof Short) {
                    if (vr2.dcm_type == 21) {
                        vr2.dcm_type = 23;
                    }
                    if (i == vr2.size()) {
                        vr2.addShort((Short)o);
                    } else {
                        vr2.setShort((Short)o, i);
                    }
                    break block67;
                }
                if (o instanceof Long) {
                    if (i == vr2.size()) {
                        vr2.addLong((Long)o);
                    } else {
                        vr2.setLong((Long)o, i);
                    }
                    break block67;
                }
                if (o instanceof int[]) {
                    int[] ar = (int[])o;
                    if (ar.length != 2) {
                        throw new DicomException("Only int[] of length 2 can be converted to ATValue");
                    }
                    if (i == vr2.size()) {
                        vr2.addATValue(new ATValue(ar[0], ar[1]));
                    } else {
                        vr2.setATValue(new ATValue(ar[0], ar[1]), i);
                    }
                    break block67;
                }
                if (o instanceof ATValue) {
                    if (i == vr2.size()) {
                        vr2.addATValue((ATValue)o);
                    } else {
                        vr2.setATValue((ATValue)o, i);
                    }
                    break block67;
                }
                if (o instanceof float[]) {
                    if (i == vr2.size()) {
                        vr2.addFloats((float[])o);
                    } else {
                        vr2.setFloats((float[])o, i);
                    }
                    break block67;
                }
                if (o instanceof double[]) {
                    if (i == vr2.size()) {
                        vr2.addDoubles((double[])o);
                    } else {
                        vr2.setDoubles((double[])o, i);
                    }
                    break block67;
                }
                if (o instanceof DicomObject) {
                    if (i == vr2.size()) {
                        vr2.addSequenceItem((DicomObject)o);
                    } else {
                        vr2.setSequenceItem((DicomObject)o, i);
                    }
                    break block67;
                }
                if (o instanceof SOPClassUID) {
                    SOPClassUID sopClassUID = (SOPClassUID)o;
                    if (i == vr2.size()) {
                        vr2.addString(sopClassUID.getValue());
                    } else {
                        vr2.setString(sopClassUID.getValue(), i);
                    }
                    break block67;
                }
                if (o instanceof TransferSyntaxUID) {
                    TransferSyntaxUID transferSyntaxUID = (TransferSyntaxUID)o;
                    if (i == vr2.size()) {
                        vr2.addString(transferSyntaxUID.getValue());
                    } else {
                        vr2.setString(transferSyntaxUID.getValue(), i);
                    }
                    break block67;
                }
                throw new DicomException(String.format("Unsupported type in argument: %s", o.getClass().getName()));
            }
            catch (DicomException ex) {
                throw new DicomException(g, e, ex.getMessage());
            }
        }
    }

    public void set(int dname, Object o) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, true);
        this.set_ge(g, e, o);
    }

    public void set_ge(int g, int e, Object o) throws DicomException {
        this.deleteItem_ge(g, e);
        this.set_ge(g, e, o, 0);
    }

    public void set_ge(int group, int element, String creator, Object o) throws DicomException {
        this.set(this.lookupPrivateTag(group, element, creator), o);
    }

    public void append(int dname, Object o) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, true);
        int t = DDict.getTypeCode(dname);
        if (o != null) {
            int i = this.getSize_ge(g, e);
            if (i == -1) {
                i = 0;
            }
            this.addValue(g, e, t, o, i);
        }
    }

    public void append_ge(int g, int e, Object o) throws DicomException {
        if (o != null) {
            int i = this.getSize_ge(g, e);
            if (i == -1) {
                i = 0;
            }
            this.set_ge(g, e, o, i);
        }
    }

    public void append_ge(int group, int element, String creator, Object o) throws DicomException {
        this.append(this.lookupPrivateTag(group, element, creator), o);
    }

    public void set(int dname, Object o, int i) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, true);
        int t = DDict.getTypeCode(dname);
        this.addValue(g, e, t, o, i);
    }

    public void set_ge(int g, int e, Object o, int i) throws DicomException {
        int t = DDict.getTypeCode(g, e);
        this.addValue(g, e, t, o, i);
    }

    public void set_ge(int group, int element, String creator, Object o, int index) throws DicomException {
        this.set(this.lookupPrivateTag(group, element, creator), o, index);
    }

    public int getType(int dname) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.getType_ge(g, e);
    }

    public int getType_ge(int group, int element) throws DicomException {
        VR vr2 = (VR)this.getDataElement(group, element, false);
        if (vr2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        return vr2.dcm_type;
    }

    public int getType_ge(int group, int element, String creator) throws DicomException {
        return this.getType(this.lookupPrivateTag(group, element, creator));
    }

    public void setType(int dname, int vrtype) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        this.setType_ge(g, e, vrtype);
    }

    public void setType_ge(int group, int element, int vrtype) throws DicomException {
        DDict.getTypeName(vrtype);
        VR vr2 = (VR)this.getDataElement(group, element, false);
        if (vr2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        if (vr2.val.size() > 0 && vr2.val.get(0) instanceof BulkDataReference) {
            vr2.dcm_type = vrtype;
            return;
        }
        if (DDictBase.isOverlayGroup(group) && element == 12288) {
            switch (vrtype) {
                case 8: 
                case 24: {
                    vr2.dcm_type = vrtype;
                    return;
                }
            }
            throw new DicomException("Illegal new type: new VR type must be tOB or tOW");
        }
        int currentVRType = this.getType_ge(group, element);
        switch (currentVRType) {
            case 21: {
                if (vrtype == 3 || vrtype == 23) break;
                throw new DicomException("Illegal new type: new VR type must be tUS or tSS");
            }
            case 22: {
                if (vrtype == 24 || vrtype == 8) break;
                throw new DicomException("Illegal new type: new VR type must be tOW or tOB");
            }
            case 3: 
            case 23: {
                return;
            }
            default: {
                throw new DicomException("current type must be tUS_US or tOW_OB");
            }
        }
        vr2.dcm_type = vrtype;
    }

    public void setType_ge(int group, int element, String creator, int vrtype) throws DicomException {
        this.setType(this.lookupPrivateTag(group, element, creator), vrtype);
    }

    public void setSeqLenState_ge(int group, int element, int seqLenState) throws DicomException {
        VR vr2 = (VR)this.getDataElement(group, element, false);
        if (vr2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        vr2.seqLenState = seqLenState;
    }

    public void setSeqLenState_ge(int group, int element, String creator, int seqLenState) throws DicomException {
        this.setSeqLenState(this.lookupPrivateTag(group, element, creator), seqLenState);
    }

    public void setSeqLenState(int dname, int seqLenState) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, true);
        this.setSeqLenState_ge(g, e, seqLenState);
    }

    public int getSeqLenState_ge(int group, int element) throws DicomException {
        VR vr2 = (VR)this.getDataElement(group, element, false);
        if (vr2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        return vr2.seqLenState;
    }

    public int getSeqLenState_ge(int group, int element, String creator) throws DicomException {
        return this.getSeqLenState(this.lookupPrivateTag(group, element, creator));
    }

    public int getSeqLenState(int dname) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.getSeqLenState_ge(g, e);
    }

    public int getSize(int dname) {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.getSize_ge(g, e);
    }

    public int getSize_ge(int g, int e) {
        VR vr2 = (VR)this.getDataElement(g, e, false);
        if (vr2 == null) {
            return -1;
        }
        return vr2.val.size();
    }

    public int getSize_ge(int group, int element, String creator) throws DicomException {
        return this.getSize(this.lookupPrivateTag(group, element, creator));
    }

    public long calculateOffset(int seq, int i, int transferSyntax, boolean sequenceUndefined, boolean grouplens) {
        return new Offsets(this).calculateOffset(seq, i, transferSyntax, sequenceUndefined, grouplens, true);
    }

    public long getOffset(int seq, int i) {
        VR vr1 = (VR)this.getDataElement(DDict.getGroup(seq), this.adjustElementForPrivateTag(seq, false), false);
        if (vr1 == null) {
            return 0L;
        }
        if (i >= vr1.val.size()) {
            return 0L;
        }
        if (vr1.dcm_type != 10) {
            return 0L;
        }
        return ((DicomObject)vr1.val.get((int)i)).offset;
    }

    public String getString(int dname, int index) throws DicomException {
        return this.getString(dname, index, true);
    }

    public String getString(int dname, int index, boolean trim) throws DicomException {
        return this.getString_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index, trim);
    }

    public String getString_ge(int group, int element, int index) throws DicomException {
        return this.getString_ge(group, element, index, true);
    }

    public String getString_ge(int group, int element, int index, boolean trim) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getString(index, trim);
    }

    public String getString_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getString_ge(group, element, creator, index, true);
    }

    public String getString_ge(int group, int element, String creator, int index, boolean trim) throws DicomException {
        return this.getString(this.lookupPrivateTag(group, element, creator), index, trim);
    }

    public void setString(int dname, String s, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setString(s, index);
    }

    public void setString_ge(int group, int element, String s, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setString(s, index);
    }

    public void setString_ge(int group, int element, String creator, String s, int index) throws DicomException {
        this.setString(this.lookupPrivateTag(group, element, creator), s, index);
    }

    public void addString(int dname, String s) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addString(s);
    }

    public void addString_ge(int group, int element, String s) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addString(s);
    }

    public void addString_ge(int group, int element, String creator, String s) throws DicomException {
        this.addString(this.lookupPrivateTag(group, element, creator), s);
    }

    public BigDecimal getBigDecimal(int dname, int index) throws DicomException {
        return this.getBigDecimal_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public BigDecimal getBigDecimal_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        if (dataElement == null) {
            return null;
        }
        return dataElement.getBigDecimal(index);
    }

    public BigDecimal getBigDecimal_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getBigDecimal(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setBigDecimal(int dname, BigDecimal bd, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setBigDecimal(bd, index);
    }

    public void setBigDecimal_ge(int group, int element, BigDecimal bd, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setBigDecimal(bd, index);
    }

    public void setBigDecimal_ge(int group, int element, String creator, BigDecimal bd, int index) throws DicomException {
        this.setBigDecimal(this.lookupPrivateTag(group, element, creator), bd, index);
    }

    public void addBigDecimal(int dname, BigDecimal bd) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addBigDecimal(bd);
    }

    public void addBigDecimal_ge(int group, int element, BigDecimal bd) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addBigDecimal(bd);
    }

    public void addBigDecimal_ge(int group, int element, String creator, BigDecimal bd) throws DicomException {
        this.addBigDecimal(this.lookupPrivateTag(group, element, creator), bd);
    }

    public BigInteger getBigInteger(int dname, int index) throws DicomException {
        return this.getBigInteger_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public BigInteger getBigInteger_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        if (dataElement == null) {
            return null;
        }
        return dataElement.getBigInteger(index);
    }

    public BigInteger getBigInteger_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getBigInteger(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setBigInteger(int dname, BigInteger bi, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setBigInteger(bi, index);
    }

    public void setBigInteger_ge(int group, int element, BigInteger bi, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setBigInteger(bi, index);
    }

    public void setBigInteger_ge(int group, int element, String creator, BigInteger bi, int index) throws DicomException {
        this.setBigInteger(this.lookupPrivateTag(group, element, creator), bi, index);
    }

    public void addBigInteger(int dname, BigInteger bi) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addBigInteger(bi);
    }

    public void addBigInteger_ge(int group, int element, BigInteger bi) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addBigInteger(bi);
    }

    public void addBigInteger_ge(int group, int element, String creator, BigInteger bi) throws DicomException {
        this.addBigInteger(this.lookupPrivateTag(group, element, creator), bi);
    }

    public Short getShort(int dname, int index) throws DicomException {
        return this.getShort_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Short getShort_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getShort(index);
    }

    public Short getShort_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getShort(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setShort(int dname, Short sh, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setShort(sh, index);
    }

    public void setShort_ge(int group, int element, Short sh, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setShort(sh, index);
    }

    public void setShort_ge(int group, int element, String creator, Short sh, int index) throws DicomException {
        this.setShort(this.lookupPrivateTag(group, element, creator), sh, index);
    }

    public void addShort(int dname, Short sh) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addShort(sh);
    }

    public void addShort_ge(int group, int element, Short sh) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addShort(sh);
    }

    public void addShort_ge(int group, int element, String creator, Short sh) throws DicomException {
        this.addShort(this.lookupPrivateTag(group, element, creator), sh);
    }

    public Integer getInteger(int dname, int index) throws DicomException {
        return this.getInteger_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Integer getInteger_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getInteger(index);
    }

    public Integer getInteger_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getInteger(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setInteger(int dname, Integer i, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setInteger(i, index);
    }

    public void setInteger_ge(int group, int element, Integer i, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setInteger(i, index);
    }

    public void setInteger_ge(int group, int element, String creator, Integer i, int index) throws DicomException {
        this.setInteger(this.lookupPrivateTag(group, element, creator), i, index);
    }

    public void addInteger(int dname, Integer i) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addInteger(i);
    }

    public void addInteger_ge(int group, int element, Integer i) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addInteger(i);
    }

    public void addInteger_ge(int group, int element, String creator, Integer i) throws DicomException {
        this.addInteger(this.lookupPrivateTag(group, element, creator), i);
    }

    public Long getLong(int dname, int index) throws DicomException {
        return this.getLong_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Long getLong_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getLong(index);
    }

    public Long getLong_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getLong(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setLong(int dname, Long l, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setLong(l, index);
    }

    public void setLong_ge(int group, int element, Long l, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setLong(l, index);
    }

    public void setLong_ge(int group, int element, String creator, Long l, int index) throws DicomException {
        this.setLong(this.lookupPrivateTag(group, element, creator), l, index);
    }

    public void addLong(int dname, Long l) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addLong(l);
    }

    public void addLong_ge(int group, int element, Long l) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addLong(l);
    }

    public void addLong_ge(int group, int element, String creator, Long l) throws DicomException {
        this.addLong(this.lookupPrivateTag(group, element, creator), l);
    }

    public Float getFloat(int dname, int index) throws DicomException {
        return this.getFloat_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Float getFloat_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getFloat(index);
    }

    public Float getFloat_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getFloat(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setFloat(int dname, Float f, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setFloat(f, index);
    }

    public void setFloat_ge(int group, int element, Float f, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setFloat(f, index);
    }

    public void setFloat_ge(int group, int element, String creator, Float f, int index) throws DicomException {
        this.setFloat(this.lookupPrivateTag(group, element, creator), f, index);
    }

    public void addFloat(int dname, Float f) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addFloat(f);
    }

    public void addFloat_ge(int group, int element, Float f) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addFloat(f);
    }

    public void addFloat_ge(int group, int element, String creator, Float f) throws DicomException {
        this.addFloat(this.lookupPrivateTag(group, element, creator), f);
    }

    public Double getDouble(int dname, int index) throws DicomException {
        return this.getDouble_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Double getDouble_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getDouble(index);
    }

    public Double getDouble_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getDouble(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setDouble(int dname, Double d, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setDouble(d, index);
    }

    public void setDouble_ge(int group, int element, Double d, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setDouble(d, index);
    }

    public void setDouble_ge(int group, int element, String creator, Double d, int index) throws DicomException {
        this.setDouble(this.lookupPrivateTag(group, element, creator), d, index);
    }

    public void addDouble(int dname, Double d) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addDouble(d);
    }

    public void addDouble_ge(int group, int element, Double d) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addDouble(d);
    }

    public void addDouble_ge(int group, int element, String creator, Double d) throws DicomException {
        this.addDouble(this.lookupPrivateTag(group, element, creator), d);
    }

    public float[] getFloats(int dname, int index) throws DicomException {
        return this.getFloats_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public float[] getFloats_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getFloats(index);
    }

    public float[] getFloats_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getFloats(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setFloats(int dname, float[] floats, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setFloats(floats, index);
    }

    public void setFloats_ge(int group, int element, float[] floats, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setFloats(floats, index);
    }

    public void setFloats_ge(int group, int element, String creator, float[] floats, int index) throws DicomException {
        this.setFloats(this.lookupPrivateTag(group, element, creator), floats, index);
    }

    public void addFloats(int dname, float[] floats) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addFloats(floats);
    }

    public void addFloats_ge(int group, int element, float[] floats) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addFloats(floats);
    }

    public void addFloats_ge(int group, int element, String creator, float[] floats) throws DicomException {
        this.addFloats(this.lookupPrivateTag(group, element, creator), floats);
    }

    public double[] getDoubles(int dname, int index) throws DicomException {
        return this.getDoubles_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public double[] getDoubles_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getDoubles(index);
    }

    public double[] getDoubles_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getDoubles(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setDoubles(int dname, double[] doubles, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setDoubles(doubles, index);
    }

    public void setDoubles_ge(int group, int element, double[] doubles, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setDoubles(doubles, index);
    }

    public void setDoubles_ge(int group, int element, String creator, double[] doubles, int index) throws DicomException {
        this.setDoubles(this.lookupPrivateTag(group, element, creator), doubles, index);
    }

    public void addDoubles(int dname, double[] doubles) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addDoubles(doubles);
    }

    public void addDoubles_ge(int group, int element, double[] doubles) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addDoubles(doubles);
    }

    public void addDoubles_ge(int group, int element, String creator, double[] doubles) throws DicomException {
        this.addDoubles(this.lookupPrivateTag(group, element, creator), doubles);
    }

    public ATValue getATValue(int dname, int index) throws DicomException {
        return this.getATValue_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public ATValue getATValue_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getATValue(index);
    }

    public void setATValue(int dname, ATValue atValue, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setATValue(atValue, index);
    }

    public void setATValue_ge(int group, int element, ATValue atValue, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setATValue(atValue, index);
    }

    public void addATValue(int dname, ATValue atValue) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addATValue(atValue);
    }

    public void addATValue_ge(int group, int element, ATValue atValue) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addATValue(atValue);
    }

    public DicomObject getSequenceItem(int dname, int index) throws DicomException {
        return this.getSequenceItem_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public DicomObject getSequenceItem_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getSequenceItem(index);
    }

    public DicomObject getSequenceItem_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getSequenceItem(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setSequenceItem(int dname, DicomObject item, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setSequenceItem(item, index);
    }

    public void setSequenceItem_ge(int group, int element, DicomObject item, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setSequenceItem(item, index);
    }

    public void setSequenceItem_ge(int group, int element, String creator, DicomObject item, int index) throws DicomException {
        this.setSequenceItem(this.lookupPrivateTag(group, element, creator), item, index);
    }

    public void addSequenceItem(int dname, DicomObject item) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addSequenceItem(item);
    }

    public void addSequenceItem_ge(int group, int element, DicomObject dicomObject) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addSequenceItem(dicomObject);
    }

    public void addSequenceItem_ge(int group, int element, String creator, DicomObject dicomObject) throws DicomException {
        this.addSequenceItem(this.lookupPrivateTag(group, element, creator), dicomObject);
    }

    public Person getPersonName(int dname, int index) throws DicomException {
        return this.getPersonName_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public Person getPersonName_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getPersonName(index);
    }

    public Person getPersonName_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getPersonName(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setPersonName(int dname, Person person, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setPersonName(person, index);
    }

    public void setPersonName(int dname, Person person, int index, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setPersonName(person, index, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public void setPersonName_ge(int group, int element, Person person, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setPersonName(person, index);
    }

    public void setPersonName_ge(int group, int element, String creator, Person person, int index) throws DicomException {
        this.setPersonName(this.lookupPrivateTag(group, element, creator), person, index);
    }

    public void setPersonName_ge(int group, int element, Person person, int index, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setPersonName(person, index, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public void setPersonName_ge(int group, int element, String creator, Person person, int index, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        this.setPersonName(this.lookupPrivateTag(group, element, creator), person, index, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public void addPersonName(int dname, Person person) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addPersonName(person);
    }

    public void addPersonName(int dname, Person person, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addPersonName(person, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public void addPersonName_ge(int group, int element, Person person) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addPersonName(person);
    }

    public void addPersonName_ge(int group, int element, String creator, Person person) throws DicomException {
        this.addPersonName(this.lookupPrivateTag(group, element, creator), person);
    }

    public void addPersonName_ge(int group, int element, Person person, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addPersonName(person, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public void addPersonName_ge(int group, int element, String creator, Person person, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        this.addPersonName(this.lookupPrivateTag(group, element, creator), person, singleByteCharset, ideographicCharset, phoneticCharset);
    }

    public byte[] getBytes(int dname, int index) throws DicomException {
        return this.getBytes_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public byte[] getBytes_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getBytes(index);
    }

    public byte[] getBytes_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getBytes(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setBytes(int dname, byte[] bytes, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setBytes(bytes, index);
    }

    public void setBytes_ge(int group, int element, byte[] bytes, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setBytes(bytes, index);
    }

    public void setBytes_ge(int group, int element, String creator, byte[] bytes, int index) throws DicomException {
        this.setBytes(this.lookupPrivateTag(group, element, creator), bytes, index);
    }

    public void addBytes(int dname, byte[] bytes) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addBytes(bytes);
    }

    public void addBytes_ge(int group, int element, byte[] bytes) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addBytes(bytes);
    }

    public void addBytes_ge(int group, int element, String creator, byte[] bytes) throws DicomException {
        this.addBytes(this.lookupPrivateTag(group, element, creator), bytes);
    }

    public ByteArray getByteArray(int dname, int index) throws DicomException {
        return this.getByteArray_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public ByteArray getByteArray_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getByteArray(index);
    }

    public ByteArray getByteArray_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getByteArray(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setByteArray(int dname, ByteArray byteArray, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setByteArray(byteArray, index);
    }

    public void setByteArray_ge(int group, int element, ByteArray byteArray, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setByteArray(byteArray, index);
    }

    public void setByteArray_ge(int group, int element, String creator, ByteArray byteArray, int index) throws DicomException {
        this.setByteArray(this.lookupPrivateTag(group, element, creator), byteArray, index);
    }

    public void addByteArray(int dname, ByteArray byteArray) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addByteArray(byteArray);
    }

    public void addByteArray_ge(int group, int element, ByteArray byteArray) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addByteArray(byteArray);
    }

    public void addByteArray_ge(int group, int element, String creator, ByteArray byteArray) throws DicomException {
        this.addByteArray(this.lookupPrivateTag(group, element, creator), byteArray);
    }

    public BulkDataReference getBulkDataReference(int dname, int index) throws DicomException {
        return this.getBulkDataReference_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false), index);
    }

    public BulkDataReference getBulkDataReference_ge(int group, int element, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, false);
        return dataElement == null ? null : dataElement.getBulkDataReference(index);
    }

    public BulkDataReference getBulkDataReference_ge(int group, int element, String creator, int index) throws DicomException {
        return this.getBulkDataReference(this.lookupPrivateTag(group, element, creator), index);
    }

    public void setBulkDataReference(int dname, BulkDataReference bulkDataReference, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.setBulkDataReference(bulkDataReference, index);
    }

    public void setBulkDataReference_ge(int group, int element, BulkDataReference bulkDataReference, int index) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.setBulkDataReference(bulkDataReference, index);
    }

    public void setBulkDataReference_ge(int group, int element, String creator, BulkDataReference bulkDataReference, int index) throws DicomException {
        this.setBulkDataReference(this.lookupPrivateTag(group, element, creator), bulkDataReference, index);
    }

    public void addBulkDataReference(int dname, BulkDataReference bulkDataReference) throws DicomException {
        DataElement dataElement = this.getDataElement(dname, true);
        dataElement.addBulkDataReference(bulkDataReference);
    }

    public void addBulkDataReference_ge(int group, int element, BulkDataReference bulkDataReference) throws DicomException {
        DataElement dataElement = this.getDataElement(group, element, true);
        dataElement.addBulkDataReference(bulkDataReference);
    }

    public void addBulkDataReference_ge(int group, int element, String creator, BulkDataReference bulkDataReference) throws DicomException {
        this.addBulkDataReference(this.lookupPrivateTag(group, element, creator), bulkDataReference);
    }

    public DataElement getDataElement(int dname) {
        int group = DDict.getGroup(dname);
        int element = this.adjustElementForPrivateTag(dname, false);
        return this.getDataElement(group, element);
    }

    public DataElement getDataElement(int group, int element) {
        return this.getDataElement(group, element, false);
    }

    public DataElement getDataElement(int group, int element, String creator) throws DicomException {
        return this.getDataElement(this.lookupPrivateTag(group, element, creator));
    }

    public Object get(int dname) {
        return this.get(dname, 0);
    }

    public Object get_ge(int g, int e) {
        return this.get_ge(g, e, 0);
    }

    public Object get_ge(int group, int element, String creator) throws DicomException {
        return this.get(this.lookupPrivateTag(group, element, creator));
    }

    public Object get(int dname, int i) {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.get_ge(g, e, i);
    }

    public Object get_ge(int g, int e, int i) {
        VR vr2 = (VR)this.getDataElement(g, e, false);
        if (vr2 == null || vr2.size() == 0) {
            return null;
        }
        if (i >= vr2.val.size()) {
            return null;
        }
        return ConvertUtils.objectToExternalObject(vr2.val.get(i), vr2.dcm_type, this.dicomCharsets(), Jdt.isAutoTrim());
    }

    public Object get_ge(int group, int element, String creator, int index) throws DicomException {
        return this.get(this.lookupPrivateTag(group, element, creator), index);
    }

    @Deprecated
    public String getS(int dname) throws DicomException {
        return this.getS(dname, 0);
    }

    @Deprecated
    public String getS_ge(int g, int e) throws DicomException {
        return this.getS_ge(g, e, 0);
    }

    @Deprecated
    public String getS(int dname, int i) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.getS_ge(g, e, i);
    }

    @Deprecated
    public String getS_ge(int g, int e, int i) throws DicomException {
        VR vr2 = (VR)this.getDataElement(g, e, false);
        if (vr2 == null || vr2.size() == 0) {
            return null;
        }
        if (i >= vr2.val.size()) {
            return null;
        }
        return ConvertUtils.objectToString(vr2.val.get(i), vr2.dcm_type, this.dicomCharsets(), true);
    }

    @Deprecated
    public int getI(int dname) throws DicomException {
        return this.getI(dname, 0);
    }

    @Deprecated
    public int getI_ge(int g, int e) throws DicomException {
        return this.getI_ge(g, e, 0);
    }

    @Deprecated
    public int getI(int dname, int i) throws DicomException {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.getI_ge(g, e, i);
    }

    @Deprecated
    public int getI_ge(int g, int e, int i) throws DicomException {
        Object o = this.get_ge(g, e, i);
        if (o != null) {
            int dcm_type = this.getDataElement((int)g, (int)e, (boolean)false).dcm_type;
            return ConvertUtils.objectToInt(o, dcm_type);
        }
        return Integer.MAX_VALUE;
    }

    public void remove(int dname) {
        this.remove_ge(DDict.getGroup(dname), this.adjustElementForPrivateTag(dname, false));
    }

    public void remove_ge(int group, int element) {
        this.removeVR(group, element);
    }

    public void remove_ge(int group, int element, String creator) throws DicomException {
        this.remove(this.lookupPrivateTag(group, element, creator));
    }

    public List deleteItem(int dname) {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.deleteItem_ge(g, e);
    }

    public List deleteItem_ge(int g, int e) {
        VR vr2 = this.removeVR(g, e);
        if (vr2 == null) {
            return null;
        }
        return vr2.val;
    }

    public List deleteItem_ge(int group, int element, String creator) throws DicomException {
        return this.deleteItem(this.lookupPrivateTag(group, element, creator));
    }

    public Object deleteItem(int dname, int i) {
        int g = DDict.getGroup(dname);
        int e = this.adjustElementForPrivateTag(dname, false);
        return this.deleteItem_ge(g, e, i);
    }

    public Object deleteItem_ge(int g, int e, int i) {
        VR vr2 = (VR)this.getDataElement(g, e, false);
        if (i >= vr2.val.size()) {
            return null;
        }
        Object o = vr2.val.get(i);
        vr2.val.remove(i);
        return o;
    }

    public Object deleteItem_ge(int group, int element, String creator, int index) throws DicomException {
        return this.deleteItem(this.lookupPrivateTag(group, element, creator), index);
    }

    public void read(InputStream in) throws IOException, DicomException {
        this.read(in, true);
    }

    public void read(InputStream in, boolean readpixels) throws IOException, DicomException {
        DicomReader dicomReader = new DicomReader();
        if (!readpixels) {
            dicomReader.addTagReadListener(new TagReadListener(){

                @Override
                public void afterHeader(TagReadEvent e) {
                    if (e.getDataReadStatus() == 3) {
                        return;
                    }
                    e.setDataReadStatus(e.getDicomObject().getParent() == null ? 2 : 0);
                }
            }, 2145386512);
        }
        dicomReader.read(this, in);
    }

    public void read(InputStream in, int transfersyntax, boolean readpixels) throws IOException, DicomException {
        DicomReader dicomReader = new DicomReader();
        if (!readpixels) {
            dicomReader.addTagReadListener(new TagReadListener(){

                @Override
                public void afterHeader(TagReadEvent e) {
                    e.setDataReadStatus(e.getDicomObject().getParent() == null ? 2 : 0);
                }
            });
        }
        new DicomReader().readDICOMStream(this, new MultiVRInputStream(in), transfersyntax);
    }

    public void write(OutputStream out, boolean dicomfile) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, out, dicomfile);
    }

    public void write(OutputStream out, boolean dicomfile, int transfersyntax, boolean seq_undef) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, out, dicomfile, transfersyntax, seq_undef);
    }

    public void write(OutputStream out, boolean dicomfile, int transfersyntax, boolean seq_undef, boolean grouplens) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, out, dicomfile, transfersyntax, seq_undef, grouplens);
    }

    void changeDICOMFileMetaInformation(int ts) throws DicomException {
        this.filemetainfo = this.getFileMetaInformation();
        if (this.filemetainfo == null) {
            this.makeDICOMFileMetaInformation(ts);
        } else {
            try {
                this.filemetainfo.set(131088, UID.getUIDEntry(ts).getValue(), 0);
            }
            catch (IllegalValueException e) {
                this.log.error("IllegalValueException when setting transfer syntax in file meta information", e);
            }
        }
    }

    private void makeDICOMFileMetaInformation(int ts) throws DicomException {
        this.filemetainfo = this.getFileMetaInformation();
        this.log.debug("DicomObject.makeDICOMFileMetaInformation. transfer syntax: " + ts);
        if (this.filemetainfo == null) {
            this.filemetainfo = new DicomObject();
        }
        if (this.getSize(524310) != 1 || this.getSize(524312) != 1) {
            throw new DicomException("This DicomObject can't be written to a Dicom File: Unable to find SOP Common Info");
        }
        byte[] metainfo = new byte[]{0, 1};
        this.filemetainfo.set(131073, metainfo, 0);
        this.filemetainfo.set(131074, this.get(524310), 0);
        this.filemetainfo.set(131075, this.get(524312), 0);
        String transyn = this.filemetainfo.getString(131088, 0);
        if (transyn != null) {
            int orig_ts;
            try {
                orig_ts = UID.getUIDEntry(transyn).getConstant();
            }
            catch (UnknownUIDException e) {
                throw new DicomException("Cannot change unknown transfersyntax into new one");
            }
            if (orig_ts != 8193 && orig_ts != 8194 && orig_ts != 8195) {
                throw new DicomException("Cannot change encapsulated transfersyntax, use Compression.decompress().");
            }
        }
        try {
            this.filemetainfo.set(131088, UID.getUIDEntry(ts).getValue(), 0);
        }
        catch (IllegalValueException e) {
            this.log.error("IllegalValueException while setting transfer syntax in file meta information: + e", e);
        }
        if (this.filemetainfo.getSize(131090) <= 0) {
            this.filemetainfo.set(131090, Jdt.getImplementationClassUID());
        }
        if (this.filemetainfo.getSize(131091) <= 0) {
            this.filemetainfo.set(131091, Jdt.getImplementationVersionName());
        }
    }

    public DicomObject getFileMetaInformation() {
        return this.filemetainfo;
    }

    public DicomObject setFileMetaInformation(DicomObject fmi) {
        DicomObject temp = this.filemetainfo;
        this.filemetainfo = fmi;
        return temp;
    }

    public void dumpVRs(OutputStream os) throws IOException {
        this.dumpVRs(os, false);
    }

    public void dumpVRs(OutputStream os, boolean metainfo) throws IOException {
        DumpUtils du = new DumpUtils(metainfo, false);
        du.dump(this, os);
    }

    public void dumpVRs(OutputStream os, int maxdescription, int maxvalue, int indentsize, boolean metainfo, boolean grouplengths) throws IOException {
        DumpUtils dumpUtils = new DumpUtils(maxdescription, maxvalue, indentsize, metainfo, grouplengths);
        dumpUtils.dump(this, os);
    }

    static {
        new Sleutel().checkKey();
    }
}

