/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;

public class DicomUtils {
    public static void swapWords(ByteArray byteArray) {
        for (int i = 0; i < byteArray.arrays(); ++i) {
            DicomUtils.swapWords(byteArray.getArray(i));
        }
    }

    public static void swapLongWords(ByteArray byteArray) {
        for (int i = 0; i < byteArray.arrays(); ++i) {
            DicomUtils.swapLongWords(byteArray.getArray(i));
        }
    }

    public static void swapWords(byte[] b) {
        for (int i = 0; i < b.length; i += 2) {
            byte t = b[i];
            b[i] = b[i + 1];
            b[i + 1] = t;
        }
    }

    public static void swapLongWords(byte[] b) {
        if (b.length % 4 > 0) {
            throw new IllegalArgumentException("byte array to be swapped is not multiple of 4 bytes");
        }
        for (int i = 0; i < b.length; i += 4) {
            byte t3;
            byte t0 = b[i];
            byte t1 = b[i + 1];
            byte t2 = b[i + 2];
            b[i] = t3 = b[i + 3];
            b[i + 1] = t2;
            b[i + 2] = t1;
            b[i + 3] = t0;
        }
    }

    public static void swapVeryLongWords(ByteArray byteArray) {
        for (int i = 0; i < byteArray.arrays(); ++i) {
            DicomUtils.swapVeryLongWords(byteArray.getArray(i));
        }
    }

    public static void swapVeryLongWords(byte[] b) {
        if (b.length % 8 > 0) {
            throw new IllegalArgumentException("byte array to be swapped is not multiple of 8 bytes");
        }
        for (int i = 0; i < b.length; i += 8) {
            byte t7;
            byte t0 = b[i];
            byte t1 = b[i + 1];
            byte t2 = b[i + 2];
            byte t3 = b[i + 3];
            byte t4 = b[i + 4];
            byte t5 = b[i + 5];
            byte t6 = b[i + 6];
            b[i] = t7 = b[i + 7];
            b[i + 1] = t6;
            b[i + 2] = t5;
            b[i + 3] = t4;
            b[i + 4] = t3;
            b[i + 5] = t2;
            b[i + 6] = t1;
            b[i + 7] = t0;
        }
    }

    public static int[] ushortToInt(byte[] bytes, boolean bigEndian) {
        if ((bytes.length & 1) == 1) {
            throw new IllegalArgumentException("byte array must be even");
        }
        int[] ints = new int[bytes.length >> 1];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = bigEndian ? ((bytes[i << 1] & 0xFF) << 8) + (bytes[(i << 1) + 1] & 0xFF) : ((bytes[(i << 1) + 1] & 0xFF) << 8) + (bytes[i << 1] & 0xFF);
        }
        return ints;
    }
}

