/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SequenceItemReadEvent;
import com.archimed.dicom.SequenceItemReadListener;
import com.archimed.dicom.TagRead2Listener;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.VR;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.log.JdtLogger;
import com.archimed.tool.StringTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;

public class DumpUtils {
    private static char[] LHEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] UHEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int maxdescription;
    private int maxvalue;
    private int indentsize;
    private boolean metainfo;
    private boolean grouplengths;
    private static String lineSeparator = System.lineSeparator() == null ? "\n" : System.lineSeparator();
    protected static transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DumpUtils.class);

    public static void dump(InputStream in, OutputStream out, int maxdescription, int maxvalue, int indentsize, boolean metainfo, boolean grouplengths) throws IOException, DicomException {
        DumpTagListener dumpTagListener = new DumpTagListener(out, metainfo, grouplengths, maxdescription, maxvalue, indentsize);
        DicomReader dicomReader = new DicomReader();
        dicomReader.addTagReadListener(dumpTagListener);
        dicomReader.addSequenceItemReadListener(dumpTagListener);
        dicomReader.read(in, true);
    }

    public DumpUtils(boolean metainfo, boolean grouplengths) {
        this(35, 60, 6, metainfo, grouplengths);
    }

    public DumpUtils(int maxdescription, int maxvalue, int indentsize, boolean metainfo, boolean grouplengths) {
        this.maxdescription = maxdescription;
        this.maxvalue = maxvalue;
        this.metainfo = metainfo;
        this.indentsize = indentsize;
        this.grouplengths = grouplengths;
    }

    public DumpUtils(int maxdescription, int maxvalue, int indentsize, boolean metainfo) {
        this(maxdescription, maxvalue, indentsize, metainfo, false);
    }

    static String pad(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return s.concat(new String(DumpUtils.fill(' ', len - s.length())));
    }

    private static String fix(String s, int len) {
        if (s.length() > len) {
            return StringTool.cut(s, len);
        }
        StringBuilder sb = new StringBuilder(s);
        int r = len - s.length();
        for (int i = 0; i < r; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static char[] fill(char c, int n) {
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return chars;
    }

    public static String toUHexString(byte b) {
        char[] chars = new char[]{UHEXCHARS[b >>> 4 & 0xF], UHEXCHARS[b & 0xF]};
        return new String(chars);
    }

    public static String toUHexString(int tag2) {
        char[] chars = new char[]{UHEXCHARS[tag2 >>> 28 & 0xF], UHEXCHARS[tag2 >>> 24 & 0xF], UHEXCHARS[tag2 >>> 20 & 0xF], UHEXCHARS[tag2 >>> 16 & 0xF], UHEXCHARS[tag2 >>> 12 & 0xF], UHEXCHARS[tag2 >>> 8 & 0xF], UHEXCHARS[tag2 >>> 4 & 0xF], UHEXCHARS[tag2 & 0xF]};
        return new String(chars);
    }

    public static String toHexString(byte b) {
        char[] chars = new char[]{LHEXCHARS[b >>> 4 & 0xF], LHEXCHARS[b & 0xF]};
        return new String(chars);
    }

    public static String toShortHexString(int i) {
        char[] chars = new char[]{LHEXCHARS[i >>> 12 & 0xF], LHEXCHARS[i >>> 8 & 0xF], LHEXCHARS[i >>> 4 & 0xF], LHEXCHARS[i & 0xF]};
        return new String(chars);
    }

    public static String toHexString(int i, int n) {
        String s = Integer.toHexString(i);
        if (n < s.length()) {
            return s.substring(0, n);
        }
        return new String(DumpUtils.fill('0', n - s.length())).concat(s);
    }

    public static String tagString(int group, int element) {
        return "(" + DumpUtils.toShortHexString(group) + "," + DumpUtils.toShortHexString(element) + ")";
    }

    public static String tagDescriptionString(int g, int e) {
        return DumpUtils.tagString(g, e) + " " + DDict.getDescription(DDict.lookupDDict(g, e));
    }

    public void dump(DicomObject dcm, StringBuffer stringBuffer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.dump(dcm, stringBuilder);
        stringBuffer.append(stringBuilder.toString());
    }

    public void dump(DicomObject dcm, StringBuilder stringBuilder) throws IOException {
        DicomObject metainfodcm;
        if (this.metainfo && (metainfodcm = dcm.getFileMetaInformation()) != null) {
            this.dump(metainfodcm, 0, stringBuilder, true);
        }
        this.dump(dcm, 0, stringBuilder, this.grouplengths);
    }

    public void dump(DicomObject dcm, OutputStream out) throws IOException {
        DicomObject metainfodcm;
        StringBuilder sb = new StringBuilder();
        if (this.metainfo && (metainfodcm = dcm.getFileMetaInformation()) != null) {
            this.dump(metainfodcm, 0, sb, this.grouplengths);
        }
        this.dump(dcm, 0, sb, this.grouplengths);
        out.write(sb.toString().getBytes());
        out.flush();
    }

    private void dump(DicomObject dcm, int level, StringBuilder sb, boolean grouplengths) throws IOException {
        Enumeration e = dcm.enumerateVRs(grouplengths, 8193, true);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            boolean seq = vr2.dcm_type == 10;
            String privateCreatorId = DumpUtils.getPrivateCreatorId(dcm, vr2.group, vr2.element);
            if (seq) {
                DumpUtils.dumpSeqStart(privateCreatorId, vr2, level, sb, this.maxdescription, this.indentsize);
                for (int i = 0; i < vr2.val.size(); ++i) {
                    DicomObject item = (DicomObject)vr2.val.get(i);
                    if (item != null) {
                        this.dump(item, level + 1, sb, grouplengths);
                    }
                    if (i == vr2.val.size() - 1) continue;
                    DumpUtils.dumpItemSepLine(level + 1, sb, this.indentsize);
                }
                DumpUtils.dumpSeqEnd(level, sb, this.indentsize);
                continue;
            }
            DumpUtils.dumpNormalTag(privateCreatorId, vr2, level, sb, this.maxdescription, this.indentsize, this.maxvalue, 0L);
        }
    }

    private static String getPrivateCreatorId(DicomObject dcm, int group, int element) {
        try {
            return dcm.getString_ge(group, element >> 8, 0);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static void dumpItemSepLine(int level, StringBuilder sb, int indentsize) {
        DumpUtils.indent(sb, level, indentsize);
        sb.append("\\");
        sb.append(lineSeparator);
    }

    private static void dumpSeqStart(String cr, VR vr2, int level, StringBuilder sb, int maxdescription, int indentsize) {
        DumpUtils.indent(sb, level, indentsize);
        DumpUtils.appendVRinfo(cr, sb, vr2, level, maxdescription, indentsize);
        sb.append(lineSeparator);
        sb = new StringBuilder();
        DumpUtils.indent(sb, level, indentsize);
        sb.append("[");
        sb.append(lineSeparator);
    }

    private static void dumpSeqEnd(int level, StringBuilder sb, int indentsize) {
        DumpUtils.indent(sb, level, indentsize);
        sb.append("]");
        sb.append(lineSeparator);
    }

    private static void dumpNormalTag(String cr, VR vr2, int level, StringBuilder sb, int maxdescription, int indentsize, int maxvalue, long bytesSkipped) {
        boolean partialData;
        DumpUtils.indent(sb, level, indentsize);
        DumpUtils.appendVRinfo(cr, sb, vr2, level, maxdescription, indentsize);
        sb.append("[");
        StringBuffer val = new StringBuffer("");
        String el = null;
        for (int k = 0; k < vr2.val.size(); ++k) {
            try {
                el = vr2.getString(k, false);
            }
            catch (DicomCharsetException ex) {
                el = DumpUtils.failoverValueDecoder(vr2, k, ex);
            }
            if (el != null) {
                val.append(el);
            }
            if (k == vr2.val.size() - 1) continue;
            val.append("\\");
        }
        boolean bl = partialData = (bytesSkipped > 0L || val.length() > maxvalue) && maxvalue > 0;
        if (partialData) {
            if (Math.min(maxvalue, val.length()) >= 4) {
                String text = val.substring(0, Math.min(maxvalue, val.length()) - 3);
                sb.append(text);
            }
            sb.append("...");
        } else {
            sb.append(val);
        }
        sb.append("]");
        sb.append(lineSeparator);
    }

    private static void indent(StringBuilder sb, int level, int indentsize) {
        int indentSize = level * indentsize;
        for (int i = 0; i < indentSize; ++i) {
            sb.append(" ");
        }
    }

    private static void appendVRinfo(String cr, StringBuilder sb, VR vr2, int level, int maxdescription, int indentsize) {
        String desc;
        sb.append("(");
        sb.append(DumpUtils.toShortHexString(vr2.group));
        sb.append(",");
        sb.append(DumpUtils.toShortHexString(vr2.element));
        sb.append(")");
        sb.append(" ");
        DDictEntry entry = DDict.getEntry(DDict.lookupDDict(vr2.group, vr2.element));
        if (DDictBase.isPrivateCreatorTag(vr2.group, vr2.element)) {
            desc = "Private Creator";
        } else if (entry == null) {
            desc = "Undefined";
        } else if (vr2.group % 2 == 1) {
            try {
                entry = DDict.getEntry(DDict.lookupDDict(vr2.group, vr2.element, cr));
            }
            catch (Throwable ex) {
                cr = null;
            }
            desc = entry != null && entry.getPrivateCreatorID() != null && cr != null && cr.equals(entry.getPrivateCreatorID()) ? entry.getDescription() : "Private Tag";
        } else {
            desc = entry.getDescription();
        }
        int subtract = maxdescription - indentsize * level;
        subtract = Math.max(subtract, 3);
        sb.append(DumpUtils.fix(desc, subtract));
        sb.append(" ");
        sb.append(DumpUtils.pad(DDict.getTypeName(vr2.dcm_type), 5));
        sb.append(" ");
        sb.append("# ");
        sb.append(DumpUtils.pad(Long.toString(vr2.dataLen), 10));
        sb.append(" ");
        sb.append(DumpUtils.pad(Integer.toString(vr2.val.size()), 8));
        sb.append(" ");
    }

    public static String failoverValueDecoder(DataElement dataElement, int index, Exception ex) {
        log.warn(String.format("Unable to get String representation for data element %s", DumpUtils.tagString(dataElement.getGroup(), dataElement.getElement())));
        switch (dataElement.getVR()) {
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 27: 
            case 32: {
                try {
                    byte[] bytes = dataElement.getBytes(index);
                    for (int backtrack = 1; backtrack < Math.min(4, bytes.length); ++backtrack) {
                        log.warn(String.format("retrying value of data element (ST,LT,UT,SH,LO,UC,PN) with %s byte(s) less", backtrack));
                        byte[] shortenedBuffer = new byte[bytes.length - backtrack];
                        System.arraycopy(bytes, 0, shortenedBuffer, 0, bytes.length - backtrack);
                        try {
                            dataElement.setBytes(shortenedBuffer, index);
                            return dataElement.getString(index);
                        }
                        catch (DicomCharsetException dicomCharsetException) {
                            log.warn(String.format("Unable to get String representation for data element %s with %s byte(s) less", DumpUtils.tagString(dataElement.getGroup(), dataElement.getElement()), backtrack));
                            continue;
                        }
                    }
                    break;
                }
                catch (DicomException dicomException) {
                    return "<ERROR! DicomException (warning logged) " + dicomException + ">";
                }
            }
        }
        return "<ERROR! DicomCharsetException (warning logged)>";
    }

    static class DumpTagListener
    implements TagRead2Listener,
    SequenceItemReadListener {
        private final int maxdescription;
        private final int maxvalue;
        private final int indentsize;
        private final OutputStream outputStream;
        private final boolean metainfo;
        private final boolean grouplengths;
        private boolean suppressed = false;
        private int level = 0;

        DumpTagListener(OutputStream outputStream, boolean metainfo, boolean grouplengths, int maxdescription, int maxvalue, int indentsize) {
            this.outputStream = outputStream;
            this.maxdescription = maxdescription;
            this.maxvalue = maxvalue;
            this.indentsize = indentsize;
            this.metainfo = metainfo;
            this.grouplengths = grouplengths;
        }

        @Override
        public void afterData(TagReadEvent e) {
            if (this.suppressed) {
                return;
            }
            if (e.getElement() == 0 && !this.grouplengths) {
                return;
            }
            if (e.getGroup() == 2 && !this.metainfo) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (e.getDataElement().getVR() == 10) {
                --this.level;
                DumpUtils.dumpSeqEnd(this.level, sb, this.indentsize);
            } else {
                DumpUtils.dumpNormalTag(DumpUtils.getPrivateCreatorId(e.getDicomObject(), e.getGroup(), e.getElement()), (VR)e.getDataElement(), this.level, sb, this.maxdescription, this.indentsize, this.maxvalue, e.getBytesSkipped());
            }
            this.writeString(sb);
            if (DDictBase.isPrivateCreatorTag(e.getGroup(), e.getElement()) || e.getGroup() == 8 && e.getElement() == 5 || DDict.lookupDDict(e.getGroup(), e.getElement()) == 131088) {
                e.setDataReadStatus(0);
            } else {
                e.setDataReadStatus(2);
            }
        }

        @Override
        public void afterHeader(TagReadEvent e) {
            if (e.getTag() == 131088 || e.getTag() == 524293 || DDictBase.isPrivateCreatorTag(e.getGroup(), e.getElement())) {
                e.setMaxReadLength(0L);
            } else {
                e.setMaxReadLength(this.maxvalue);
            }
            if (e.getDataElement().getVR() == 10) {
                StringBuilder sb = new StringBuilder();
                DumpUtils.dumpSeqStart(DumpUtils.getPrivateCreatorId(e.getDicomObject(), e.getGroup(), e.getElement()), (VR)e.getDataElement(), this.level, sb, this.maxdescription, this.indentsize);
                this.writeString(sb);
                ++this.level;
            }
        }

        @Override
        public void beforeSequenceItem(SequenceItemReadEvent e) {
            if (e.getItemIndex() > 0) {
                StringBuilder sb = new StringBuilder();
                DumpUtils.dumpItemSepLine(this.level, sb, this.indentsize);
                this.writeString(sb);
            }
        }

        @Override
        public void afterSequenceItem(SequenceItemReadEvent e) {
        }

        private void writeString(StringBuilder sb) {
            try {
                this.outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                this.suppressed = true;
                throw new RuntimeException("IOException when writing to specified outputstream, suppressing further output");
            }
        }
    }
}

