/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.BulkDataReference;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElementValue;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.VR;
import java.util.Enumeration;
import java.util.List;

class LengthUtils {
    LengthUtils() {
    }

    private static long addOneIfOdd(long n) {
        if ((n & 1L) == 1L) {
            return n + 1L;
        }
        return n;
    }

    private static int delimLength(List val) {
        if (val.size() > 0) {
            return val.size() - 1;
        }
        return 0;
    }

    private static int byteLength(List val) {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            len += ((byte[])val.get(i)).length;
        }
        return len;
    }

    static long sequenceItemLength(DicomObject si, int ts, int seqLengthOpt, int groupLengthOpt) {
        long len = 0L;
        if (seqLengthOpt == 8200) {
            len = 16L;
        } else if (seqLengthOpt == 8201) {
            len = 8L;
        } else if (seqLengthOpt == 8209) {
            len = si.getSeqItemLenState() == 1 || si.getSeqItemLenState() == 3 ? 8L : 16L;
        } else if (seqLengthOpt == 8208) {
            len = si.getSeqItemLenState() == 1 || si.getSeqItemLenState() == 2 ? 16L : 8L;
        }
        Enumeration e = si.enumerateVRs(ts, seqLengthOpt, groupLengthOpt);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            len += (long)LengthUtils.calculateHeaderLength(vr2.dcm_type, ts);
            len += LengthUtils.calculateDataLength(vr2, vr2.dcm_type, ts, seqLengthOpt, groupLengthOpt);
        }
        return len;
    }

    private static long sequenceLength(List val, int ts, int seqLengthOpt, int groupLengthOpt) {
        long len = 0L;
        for (int i = 0; i < val.size(); ++i) {
            DicomObject item = (DicomObject)val.get(i);
            item.length = LengthUtils.sequenceItemLength(item, ts, seqLengthOpt, groupLengthOpt);
            len += item.length;
        }
        return len;
    }

    private static int sequenceHeaderLength(int seqLenState, int seqLengthOpt) {
        int DEFINEDLENGTH = 0;
        int UNDEFINEDLENGTH = 8;
        if (seqLengthOpt == 8201) {
            return DEFINEDLENGTH;
        }
        if (seqLengthOpt == 8200) {
            return UNDEFINEDLENGTH;
        }
        if (seqLengthOpt == 8209) {
            if (seqLenState == 1 || seqLenState == 3) {
                return DEFINEDLENGTH;
            }
            if (seqLenState == 2) {
                return UNDEFINEDLENGTH;
            }
            throw new IllegalArgumentException("illegal constant for seqLenState");
        }
        if (seqLengthOpt == 8208) {
            if (seqLenState == 1 || seqLenState == 2) {
                return UNDEFINEDLENGTH;
            }
            if (seqLenState == 3) {
                return DEFINEDLENGTH;
            }
            throw new IllegalArgumentException("illegal constant for seqLenState");
        }
        throw new IllegalArgumentException("illegal constant for seqLenState");
    }

    private static int encapsulatedPixelHeaderLength(List val) {
        return 8 + val.size() * 8;
    }

    private static int ofLength(List val) {
        if (val.size() == 0) {
            return 0;
        }
        if (val.get(0) instanceof float[]) {
            return ((float[])val.get(0)).length * 4;
        }
        if (val.get(0) instanceof BulkDataReference) {
            return (int)((BulkDataReference)val.get(0)).getLength();
        }
        throw new IllegalArgumentException("values of OF VR must be of type float[] or BulkDataReference");
    }

    private static int odLength(List val) {
        if (val.size() == 0) {
            return 0;
        }
        if (val.get(0) instanceof double[]) {
            return ((double[])val.get(0)).length * 8;
        }
        if (val.get(0) instanceof BulkDataReference) {
            return (int)((BulkDataReference)val.get(0)).getLength();
        }
        throw new IllegalArgumentException("values of OD VR must be of type double[] or BulkDataReference");
    }

    static long calculateDataLength(VR vr2, int dcm_type, int ts, int seqLengthOpt, int groupLengthOpt) {
        int fix = DDict.getTypeFixed(dcm_type);
        int len = 0;
        if (fix != 0) {
            return vr2.val.size() == 1 && vr2.val.get(0) instanceof BulkDataReference ? ((BulkDataReference)vr2.val.get(0)).getLength() : (long)(fix * vr2.val.size());
        }
        switch (dcm_type) {
            case 10: {
                return LengthUtils.addOneIfOdd(LengthUtils.sequenceLength(vr2.val, ts, seqLengthOpt, groupLengthOpt) + (long)LengthUtils.sequenceHeaderLength(vr2.seqLenState, seqLengthOpt));
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                long valueLength = 0L;
                for (Object obj : vr2.val) {
                    long l = ((DataElementValue)obj).getLength();
                    if (l == -1L) {
                        return -1L;
                    }
                    valueLength += l;
                }
                return vr2.isTopLevelPixelData() && TransferSyntax.isEncapsulated(ts) ? LengthUtils.addOneIfOdd(valueLength + (long)LengthUtils.encapsulatedPixelHeaderLength(vr2.val)) : LengthUtils.addOneIfOdd(valueLength);
            }
            case 29: {
                len = LengthUtils.ofLength(vr2.val);
                break;
            }
            case 31: {
                len = LengthUtils.odLength(vr2.val);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                len = LengthUtils.byteLength(vr2.val);
                break;
            }
            default: {
                len = LengthUtils.byteLength(vr2.val);
            }
        }
        return LengthUtils.addOneIfOdd(len += LengthUtils.delimLength(vr2.val));
    }

    static int calculateHeaderLength(int dcm_type, int ts) {
        if (ts == 8193 || ts == 8227) {
            return 8;
        }
        switch (dcm_type) {
            case 0: 
            case 8: 
            case 10: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return 12;
            }
        }
        return 8;
    }
}

