/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.VR;
import com.archimed.log.JdtLogger;
import java.util.Enumeration;

public class Offsets {
    DicomObject dcm;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Offsets.class);

    public Offsets(DicomObject dcm) {
        this.dcm = dcm;
    }

    public void updateSequenceItemOffsets(int ts, boolean seq_undef, boolean grouplens, boolean file) {
        long total = 0L;
        if (file) {
            try {
                this.dcm.changeDICOMFileMetaInformation(ts);
            }
            catch (DicomException ex) {
                this.log.error("DicomException when changing file meta information", ex);
            }
            DicomObject fmi = this.dcm.getFileMetaInformation();
            if (fmi != null) {
                total = 132 + this.getSize(fmi, true, 8194, seq_undef);
            }
        }
        Enumeration en = this.dcm.enumerateVRs(grouplens, ts, seq_undef);
        while (en.hasMoreElements()) {
            VR vr2 = (VR)en.nextElement();
            total += (long)vr2.headerLen;
            if (vr2.dcm_type == 10) {
                long itemslen = 0L;
                for (int i = 0; i < vr2.val.size(); ++i) {
                    DicomObject item = (DicomObject)vr2.val.get(i);
                    item.offset = total + itemslen;
                    itemslen += item.length;
                }
            }
            total += vr2.dataLen;
        }
    }

    public long calculateSize(boolean groupLengths, int transferSyntax, boolean seqUndefined) {
        return this.getSize(this.dcm, groupLengths, transferSyntax, seqUndefined);
    }

    private int getSize(DicomObject dcm, boolean grouplens, int ts, boolean seq_undef) {
        int size = 0;
        Enumeration e = dcm.enumerateVRs(grouplens, ts, seq_undef);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            size = (int)((long)size + ((long)vr2.headerLen + vr2.dataLen));
        }
        return size;
    }

    public long calculateOffset_ge(DicomObject d, int g, int e, int ts, boolean seq_undef, boolean grouplens, boolean file) {
        VR vr2 = d.getVR(g, e);
        long total = 0L;
        if (vr2 == null) {
            return 0L;
        }
        if (file) {
            try {
                d.changeDICOMFileMetaInformation(ts);
            }
            catch (DicomException ex) {
                this.log.error("DicomException while changing file meta information", ex);
            }
            DicomObject fmi = d.getFileMetaInformation();
            if (fmi != null) {
                total = 132 + this.getSize(fmi, true, 8194, seq_undef);
            }
        }
        Enumeration en = d.enumerateVRs(grouplens, ts, seq_undef);
        while (en.hasMoreElements()) {
            vr2 = (VR)en.nextElement();
            if (vr2.group == g && vr2.element == e) break;
            total += vr2.dataLen + (long)vr2.headerLen;
        }
        return total;
    }

    public long calculateOffset_ge(int g, int e, int ts, boolean seq_undef, boolean grouplens, boolean file) {
        return this.calculateOffset_ge(this.dcm, g, e, ts, seq_undef, grouplens, file);
    }

    public long calculateOffset(int dct, int ts, boolean seq_undef, boolean grouplens, boolean file) {
        int g = DDict.getGroup(dct);
        int e = DDict.getElement(dct);
        return this.calculateOffset_ge(g, e, ts, seq_undef, grouplens, file);
    }

    public long calculateOffset(int seq, int i, int ts, boolean seq_undef, boolean grouplens, boolean file) {
        long off = this.calculateOffset(seq, ts, seq_undef, grouplens, file);
        VR vr2 = this.dcm.getVR(DDict.getGroup(seq), DDict.getElement(seq));
        if (i >= vr2.val.size()) {
            return 0L;
        }
        if (vr2.dcm_type != 10) {
            return 0L;
        }
        off += (long)vr2.headerLen;
        for (int j = 0; j < i; ++j) {
            off += ((DicomObject)vr2.val.get((int)j)).length;
        }
        return off;
    }

    public long calculateOffset(int seq, int i, int dct, int ts, boolean seq_undef, boolean grouplens, boolean file) {
        long off = this.calculateOffset(seq, i, ts, seq_undef, grouplens, file);
        VR vr2 = this.dcm.getVR(DDict.getGroup(seq), DDict.getElement(seq));
        DicomObject sequence = (DicomObject)vr2.val.get(i);
        return off += 8L + this.calculateOffset_ge(sequence, DDict.getGroup(dct), DDict.getElement(dct), ts, seq_undef, false, false);
    }
}

