/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.OffsetOutputStream;
import com.archimed.dicom.TransferSyntax;
import java.io.IOException;
import java.io.OutputStream;

class PrimitiveOutputStream
extends OffsetOutputStream {
    private int ts = 8193;
    private byte[] temp16 = new byte[2];
    private byte[] temp32 = new byte[4];
    private byte[] temp64 = new byte[8];
    protected boolean _bigEndian;

    PrimitiveOutputStream(OutputStream out) {
        super(out);
    }

    PrimitiveOutputStream(OutputStream out, long beginoff) {
        super(out, beginoff);
    }

    public void setTransferSyntax(int transyn) {
        this.ts = transyn;
        this._bigEndian = TransferSyntax.isBigEndian(transyn);
    }

    int getTransferSyntax() {
        return this.ts;
    }

    public int writeInt16(int val) throws IOException {
        if (this._bigEndian) {
            this.temp16[1] = (byte)val;
            this.temp16[0] = (byte)(val >>> 8);
        } else {
            this.temp16[0] = (byte)val;
            this.temp16[1] = (byte)(val >>> 8);
        }
        this.write(this.temp16);
        return 2;
    }

    public int writeInt32(int val) throws IOException {
        if (this._bigEndian) {
            this.temp32[3] = (byte)val;
            this.temp32[2] = (byte)(val >>> 8);
            this.temp32[1] = (byte)(val >>> 16);
            this.temp32[0] = (byte)(val >>> 24);
        } else {
            this.temp32[0] = (byte)val;
            this.temp32[1] = (byte)(val >>> 8);
            this.temp32[2] = (byte)(val >>> 16);
            this.temp32[3] = (byte)(val >>> 24);
        }
        this.write(this.temp32);
        return 4;
    }

    int writeInt64(long val) throws IOException {
        if (this._bigEndian) {
            this.temp64[7] = (byte)val;
            this.temp64[6] = (byte)(val >>> 8);
            this.temp64[5] = (byte)(val >>> 16);
            this.temp64[4] = (byte)(val >>> 24);
            this.temp64[3] = (byte)(val >>> 32);
            this.temp64[2] = (byte)(val >>> 40);
            this.temp64[1] = (byte)(val >>> 48);
            this.temp64[0] = (byte)(val >>> 56);
        } else {
            this.temp64[0] = (byte)val;
            this.temp64[1] = (byte)(val >>> 8);
            this.temp64[2] = (byte)(val >>> 16);
            this.temp64[3] = (byte)(val >>> 24);
            this.temp64[4] = (byte)(val >>> 32);
            this.temp64[5] = (byte)(val >>> 40);
            this.temp64[6] = (byte)(val >>> 48);
            this.temp64[7] = (byte)(val >>> 56);
        }
        this.write(this.temp64);
        return 8;
    }

    public int writeString(String s) throws IOException {
        this.write(s.getBytes());
        return s.length();
    }
}

