/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.PrimitiveInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class SingleVRInputStream
extends PrimitiveInputStream {
    private byte[] temp64 = new byte[8];

    SingleVRInputStream(InputStream in) {
        super(in);
    }

    SingleVRInputStream(InputStream in, int beginoff) {
        super(in, beginoff);
    }

    private String readAS() throws IOException {
        return this.readString(4);
    }

    private ATValue readAT() throws IOException {
        return new ATValue(this.readUInt16(), this.readUInt16());
    }

    private Float readFL() throws IOException {
        return new Float(Float.intBitsToFloat(this.readUInt32()));
    }

    private Double readFD() throws IOException {
        return new Double(Double.longBitsToDouble(this.readSInt64()));
    }

    private Long readSL() throws IOException {
        return new Long(this.readSInt32());
    }

    private Short readSS() throws IOException {
        return new Short((short)this.readSInt16());
    }

    private Long readUL() throws IOException {
        return new Long(this.unsignToLong(this.readUInt32()));
    }

    private Integer readUS() throws IOException {
        return new Integer(this.readUInt16());
    }

    private Integer readUS_SS() throws IOException {
        return new Integer(this.readUInt16());
    }

    private BigInteger readSV() throws IOException {
        return BigInteger.valueOf(this.readSInt64());
    }

    private BigInteger readUV() throws IOException {
        this.readFully(this.temp64);
        if (!this._bigEndian) {
            DicomUtils.swapVeryLongWords(this.temp64);
        }
        return new BigInteger(1, this.temp64);
    }

    Object readFixed(int dcm_type) throws IOException {
        switch (dcm_type) {
            case 17: {
                return this.readAS();
            }
            case 5: {
                return this.readAT();
            }
            case 26: {
                return this.readFL();
            }
            case 20: {
                return this.readFD();
            }
            case 19: {
                return this.readSL();
            }
            case 23: {
                return this.readSS();
            }
            case 1: {
                return this.readUL();
            }
            case 3: {
                return this.readUS();
            }
            case 21: {
                return this.readUS_SS();
            }
            case 35: {
                return this.readSV();
            }
            case 36: {
                return this.readUV();
            }
        }
        return null;
    }
}

