/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomObject;
import java.io.OutputStream;
import java.util.EventObject;

public class TagWriteEvent
extends EventObject {
    public static final int WRITE_TAG = 0;
    public static final int NEXT_TAG = 3;
    private OutputStream out;
    private DataElement dataElement;
    private long offset;
    private int dataWriteStatus = 0;
    private boolean stopWriting = false;

    TagWriteEvent(DataElement dataElement, OutputStream out, long offset) {
        super(dataElement.dcm);
        this.dataElement = dataElement;
        this.out = out;
        this.offset = offset;
    }

    public DicomObject getDicomObject() {
        return (DicomObject)this.getSource();
    }

    public int getGroup() {
        return this.dataElement.getGroup();
    }

    public int getElement() {
        return this.dataElement.getElement();
    }

    public int getTag() {
        return DDict.lookupDDict(this.getGroup(), this.getElement());
    }

    public int getVRType() {
        return this.dataElement.getVR();
    }

    public int getLength() {
        return (int)this.dataElement.dataLen;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public DataElement getDataElement() {
        return this.dataElement;
    }

    public int getDataWriteStatus() {
        return this.dataWriteStatus;
    }

    public void setDataWriteStatus(int dataWriteStatus) {
        if (dataWriteStatus < 0 || dataWriteStatus > 3) {
            throw new IllegalArgumentException("unknown dataReadStatus: " + dataWriteStatus);
        }
        this.dataWriteStatus = dataWriteStatus;
    }

    public boolean isStopWriting() {
        return this.stopWriting;
    }

    public void setStopWriting(boolean stopWriting) {
        this.stopWriting = stopWriting;
    }

    public long getOffset() {
        return this.offset;
    }
}

