/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransferSyntax
extends UID {
    public static final int PrivateTransferSyntax = 8192;
    public static final TransferSyntaxUID PrivateTransferSyntaxUID = TransferSyntax.create(8192, "private", "Private Transfer Syntax", "Private", false, false, false, true, false);
    public static final int ImplicitVRLittleEndian = 8193;
    public static final TransferSyntaxUID ImplicitVRLittleEndianUID = TransferSyntax.create(8193, "1.2.840.10008.1.2", "Implicit VR Little Endian Transfer Syntax", "ILE", false, false, false, false, false);
    public static final int ExplicitVRLittleEndian = 8194;
    public static final TransferSyntaxUID ExplicitVRLittleEndianUID = TransferSyntax.create(8194, "1.2.840.10008.1.2.1", "Explicit VR Little Endian Transfer Syntax", "ELE", false, false, false, true, false);
    public static final int ExplicitVRBigEndian = 8195;
    public static final TransferSyntaxUID ExplicitVRBigEndianUID = TransferSyntax.create(8195, "1.2.840.10008.1.2.2", "Explicit VR Big Endian Transfer Syntax", "EBE", true, false, false, true, true);
    public static final int RLELossless = 8198;
    public static final TransferSyntaxUID RLELosslessUID = TransferSyntax.create(8198, "1.2.840.10008.1.2.5", "RLE Lossless Transfer Syntax", "RLE", false, true, false, true, false);
    public static final int JPEG_1 = 8196;
    public static final TransferSyntaxUID JPEG_1UID;
    public static final int JPEGBaseline = 8196;
    public static final TransferSyntaxUID JPEGBaselineUID;
    public static final int JPEG_14_SelectionValue1 = 8197;
    public static final TransferSyntaxUID JPEG_14_SelectionValue1UID;
    public static final int JPEGLossless = 8197;
    public static final TransferSyntaxUID JPEGLosslessUID;
    public static final int JPEG_2_4 = 8199;
    public static final TransferSyntaxUID JPEG_2_4UID;
    public static final int JPEG_3_5 = 8200;
    public static final TransferSyntaxUID JPEG_3_5UID;
    public static final int JPEG_6_8 = 8201;
    public static final TransferSyntaxUID JPEG_6_8UID;
    public static final int JPEG_7_9 = 8202;
    public static final TransferSyntaxUID JPEG_7_9UID;
    public static final int JPEG_10_12 = 8203;
    public static final TransferSyntaxUID JPEG_10_12UID;
    public static final int JPEG_11_13 = 8204;
    public static final TransferSyntaxUID JPEG_11_13UID;
    public static final int JPEG_14 = 8205;
    public static final TransferSyntaxUID JPEG_14UID;
    public static final int JPEG_15 = 8206;
    public static final TransferSyntaxUID JPEG_15UID;
    public static final int JPEG_16_18 = 8207;
    public static final TransferSyntaxUID JPEG_16_18UID;
    public static final int JPEG_17_19 = 8208;
    public static final TransferSyntaxUID JPEG_17_19UID;
    public static final int JPEG_20_22 = 8209;
    public static final TransferSyntaxUID JPEG_20_22UID;
    public static final int JPEG_21_23 = 8210;
    public static final TransferSyntaxUID JPEG_21_23UID;
    public static final int JPEG_24_26 = 8211;
    public static final TransferSyntaxUID JPEG_24_26UID;
    public static final int JPEG_25_27 = 8212;
    public static final TransferSyntaxUID JPEG_25_27UID;
    public static final int JPEG_28 = 8213;
    public static final TransferSyntaxUID JPEG_28UID;
    public static final int JPEG_29 = 8214;
    public static final TransferSyntaxUID JPEG_29UID;
    public static final int DeflatedExplicitVRLittleEndian = 8215;
    public static final TransferSyntaxUID DeflatedExplicitVRLittleEndianUID;
    public static final int JPEGLSLossless = 8216;
    public static final TransferSyntaxUID JPEGLSLosslessUID;
    public static final int JPEGLSLossy = 8217;
    public static final TransferSyntaxUID JPEGLSLossyUID;
    public static final int JPEG2000LosslessOnly = 8224;
    public static final TransferSyntaxUID JPEG2000LosslessOnlyUID;
    public static final int JPEG2000 = 8225;
    public static final TransferSyntaxUID JPEG2000UID;
    public static final int MPEG2MainProfileMainLevel = 8226;
    public static final TransferSyntaxUID MPEG2MainProfileMainLevelUID;
    public static final int GEPrivate = 8227;
    public static final TransferSyntaxUID GEPrivateUID;
    public static final int JPEG2000Part2MultiComponentLosslessOnly = 8228;
    public static final TransferSyntaxUID JPEG2000Part2MultiComponentLosslessOnlyUID;
    public static final int JPEG2000Part2MultiComponent = 8229;
    public static final TransferSyntaxUID JPEG2000Part2MultiComponentUID;
    public static final int JPIPReferenced = 8230;
    public static final TransferSyntaxUID JPIPReferencedUID;
    public static final int JPIPReferencedDeflate = 8231;
    public static final TransferSyntaxUID JPIPReferencedDeflateUID;
    public static final int RFC2557MIMEencapsulation = 8232;
    public static final TransferSyntaxUID RFC2557MIMEencapsulationUID;
    public static final int MPEG2MainProfileHighLevel = 8233;
    public static final TransferSyntaxUID MPEG2MainProfileHighLevelUID;
    public static final int MPEG4AVCH264HighProfile = 8234;
    public static final TransferSyntaxUID MPEG4AVCH264HighProfileUID;
    public static final int MPEG4AVCH264BDCompHighProfile = 8235;
    public static final TransferSyntaxUID MPEG4AVCH264BDCompHighProfileUID;
    public static final int MPEG4AVCH264HighProfileLevel42For2DVideo = 8236;
    public static final TransferSyntaxUID MPEG4AVCH264HighProfileLevel42For2DVideoUID;
    public static final int MPEG4AVCH264HighProfileLevel42For3DVideo = 8237;
    public static final TransferSyntaxUID MPEG4AVCH264HighProfileLevel42For3DVideoUID;
    public static final int MPEG4AVCH264StereoHighProfileLevel42 = 8238;
    public static final TransferSyntaxUID MPEG4AVCH264StereoHighProfileLevel42UID;
    public static final int HEVCH265MainProfileLevel51 = 8239;
    public static final TransferSyntaxUID HEVCH265MainProfileLevel51UID;
    public static final int HEVCH265Main10ProfileLevel51 = 8240;
    public static final TransferSyntaxUID HEVCH265Main10ProfileLevel51UID;
    public static final int Papyrus3ImplicitVRLittleEndian = 8241;
    public static final TransferSyntaxUID Papyrus3ImplicitVRLittleEndianUID;
    public static final int XMLEncoding = 8242;
    public static final TransferSyntaxUID XMLEncodingUID;
    public static final int EncapsulatedUncompressedExplicitVRLittleEndian = 8243;
    public static final TransferSyntaxUID EncapsulatedUncompressedExplicitVRLittleEndianUID;
    public static final int SMPTEST211030PCMDigitalAudio = 8244;
    public static final TransferSyntaxUID SMPTEST211030PCMDigitalAudioUID;
    public static final int SMPTEST211020UncompressedInterlacedActiveVideo = 8245;
    public static final TransferSyntaxUID SMPTEST211020UncompressedInterlacedActiveVideoUID;
    public static final int SMPTEST211020UncompressedProgressiveActiveVideo = 8246;
    public static final TransferSyntaxUID SMPTEST211020UncompressedProgressiveActiveVideoUID;

    private static TransferSyntaxUID create(int constant, String value, String name, String shortname, boolean retired, boolean encapsulated, boolean fragmentedFrames, boolean explicit, boolean bigEndian) {
        TransferSyntaxUID transferSyntaxUID = new TransferSyntaxUID(constant, value, name, shortname, retired, encapsulated, fragmentedFrames, explicit, bigEndian);
        entries.put(constant, transferSyntaxUID);
        return transferSyntaxUID;
    }

    public static List<TransferSyntaxUID> list() {
        Iterator iterator = entries.values().iterator();
        ArrayList<TransferSyntaxUID> l = new ArrayList<TransferSyntaxUID>();
        while (iterator.hasNext()) {
            UIDEntry entry = (UIDEntry)iterator.next();
            if (entry.getType() != 3) continue;
            l.add((TransferSyntaxUID)entry);
        }
        return l;
    }

    public static TransferSyntaxUID get(String uid) {
        try {
            UIDEntry uidEntry = TransferSyntax.getUIDEntry(uid);
            return uidEntry instanceof TransferSyntaxUID ? (TransferSyntaxUID)uidEntry : null;
        }
        catch (UnknownUIDException ex) {
            return null;
        }
    }

    public static TransferSyntaxUID get(int key) {
        try {
            UIDEntry uidEntry = TransferSyntax.getUIDEntry(key);
            return uidEntry instanceof TransferSyntaxUID ? (TransferSyntaxUID)uidEntry : null;
        }
        catch (IllegalValueException ex) {
            return null;
        }
    }

    public static boolean isEncapsulated(int key) {
        TransferSyntaxUID transferSyntaxUID = TransferSyntax.get(key);
        if (transferSyntaxUID == null) {
            throw new IllegalArgumentException(String.format("Unknown transfer syntax for key %s", key));
        }
        return transferSyntaxUID.isEncapsulated();
    }

    public static boolean isBigEndian(int key) {
        TransferSyntaxUID transferSyntaxUID = TransferSyntax.get(key);
        if (transferSyntaxUID == null) {
            throw new IllegalArgumentException(String.format("Unknown transfer syntax for key %s", key));
        }
        return transferSyntaxUID.isBigEndian();
    }

    public static synchronized int addTransferSyntax(String uid, String name, String shortName, boolean retired, boolean encapsulated, boolean fragmentedFrames, boolean explicit, boolean bigEndian) throws DicomException {
        try {
            TransferSyntax.getUIDEntry(uid);
            throw new DicomException(String.format("Transfer syntax %s already exists in dictionary", uid));
        }
        catch (UnknownUIDException unknownUIDException) {
            int max = Integer.MIN_VALUE;
            for (Integer i : entries.keySet()) {
                if (i <= max) continue;
                max = i;
            }
            entries.put(max + 1, new TransferSyntaxUID(max + 1, uid, name, shortName, retired, encapsulated, fragmentedFrames, explicit, bigEndian));
            return max + 1;
        }
    }

    static {
        JPEGBaselineUID = JPEG_1UID = TransferSyntax.create(8196, "1.2.840.10008.1.2.4.50", "JPEG Baseline Transfer Syntax (Process 1)", "JPEGBaseline", false, true, true, true, false);
        JPEGLosslessUID = JPEG_14_SelectionValue1UID = TransferSyntax.create(8197, "1.2.840.10008.1.2.4.70", "JPEG Lossless Transfer Syntax (Process 14, Selection Value 1)", "JPEGLosslessSV1", false, true, true, true, false);
        JPEG_2_4UID = TransferSyntax.create(8199, "1.2.840.10008.1.2.4.51", "JPEG Extended (Process 2 & 4)", "JPEGExtendedP24", false, true, true, true, false);
        JPEG_3_5UID = TransferSyntax.create(8200, "1.2.840.10008.1.2.4.52", "JPEG Extended (Process 3 & 5)", "JPEGExtendedP35", true, true, true, true, false);
        JPEG_6_8UID = TransferSyntax.create(8201, "1.2.840.10008.1.2.4.53", "JPEG Spectral Selection, Non-Hierarchical (Process 6 & 8)", "JPEGSpectralP68", true, true, true, true, false);
        JPEG_7_9UID = TransferSyntax.create(8202, "1.2.840.10008.1.2.4.54", "JPEG Spectral Selection, Non-Hierarchical (Process 7 & 9)", "JPEGSpectralP79", true, true, true, true, false);
        JPEG_10_12UID = TransferSyntax.create(8203, "1.2.840.10008.1.2.4.55", "JPEG Full Progression, Non-Hierarchical (Process 10 & 12)", "JPEGFullPP1012", true, true, true, true, false);
        JPEG_11_13UID = TransferSyntax.create(8204, "1.2.840.10008.1.2.4.56", "JPEG Full Progression, Non-Hierarchical (Process 11 & 13)", "JPEGFullPP1113", true, true, true, true, false);
        JPEG_14UID = TransferSyntax.create(8205, "1.2.840.10008.1.2.4.57", "JPEG Lossless, Non-Hierarchical (Process 14)", "JPEGLosslessP14", false, true, true, true, false);
        JPEG_15UID = TransferSyntax.create(8206, "1.2.840.10008.1.2.4.58", "JPEG Lossless, Non-Hierarchical (Process 15)", "JPEGLosslessP15", true, true, true, true, false);
        JPEG_16_18UID = TransferSyntax.create(8207, "1.2.840.10008.1.2.4.59", "JPEG Extended, Hierarchical (Process 16 & 18)", "JPEGExtendedP1618", true, true, true, true, false);
        JPEG_17_19UID = TransferSyntax.create(8208, "1.2.840.10008.1.2.4.60", "JPEG Extended, Hierarchical (Process 17 & 19)", "JPEGExtendedP1719", true, true, true, true, false);
        JPEG_20_22UID = TransferSyntax.create(8209, "1.2.840.10008.1.2.4.61", "JPEG Spectral Selection, Hierarchical (Process 20 & 22)", "JPEGSpectralP2022", true, true, true, true, false);
        JPEG_21_23UID = TransferSyntax.create(8210, "1.2.840.10008.1.2.4.62", "JPEG Spectral Selection, Hierarchical (Process 21 & 23)", "JPEGSpectralP2123", true, true, true, true, false);
        JPEG_24_26UID = TransferSyntax.create(8211, "1.2.840.10008.1.2.4.63", "JPEG Full Progression, Hierarchical (Process 24 & 26)", "JPEGFullPP24&6", true, true, true, true, false);
        JPEG_25_27UID = TransferSyntax.create(8212, "1.2.840.10008.1.2.4.64", "JPEG Full Progression, Hierarchical (Process 25 & 27)", "JPEGFullPP2527", true, true, true, true, false);
        JPEG_28UID = TransferSyntax.create(8213, "1.2.840.10008.1.2.4.65", "JPEG Lossless, Hierarchical (Process 28)", "JPEGLosslessP28", true, true, true, true, false);
        JPEG_29UID = TransferSyntax.create(8214, "1.2.840.10008.1.2.4.66", "JPEG Lossless, Hierarchical (Process 29)", "JPEGLosslessP29", true, true, true, true, false);
        DeflatedExplicitVRLittleEndianUID = TransferSyntax.create(8215, "1.2.840.10008.1.2.1.99", "Deflated Explicit VR Little Endian", "DeflatedELE", false, false, false, true, false);
        JPEGLSLosslessUID = TransferSyntax.create(8216, "1.2.840.10008.1.2.4.80", "JPEG-LS Lossless Image Compression", "JPEGLS", false, true, true, true, false);
        JPEGLSLossyUID = TransferSyntax.create(8217, "1.2.840.10008.1.2.4.81", "JPEG-LS Lossy (Near-Lossless) Image Compression", "JPEGLSNear", false, true, true, true, false);
        JPEG2000LosslessOnlyUID = TransferSyntax.create(8224, "1.2.840.10008.1.2.4.90", "JPEG 2000 Image Compression (Lossless Only)", "JP2000Lossless", false, true, true, true, false);
        JPEG2000UID = TransferSyntax.create(8225, "1.2.840.10008.1.2.4.91", "JPEG 2000 Image Compression", "JP2000", false, true, true, true, false);
        MPEG2MainProfileMainLevelUID = TransferSyntax.create(8226, "1.2.840.10008.1.2.4.100", "MPEG2 Main Profile @ Main Level", "MPEG2", false, true, false, true, false);
        GEPrivateUID = TransferSyntax.create(8227, "1.2.840.113619.5.2", "GE Private Transfer Syntax", "GEPrivate", false, false, false, false, false);
        JPEG2000Part2MultiComponentLosslessOnlyUID = TransferSyntax.create(8228, "1.2.840.10008.1.2.4.92", "JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)", "JP2000P2Lossless", false, true, true, true, false);
        JPEG2000Part2MultiComponentUID = TransferSyntax.create(8229, "1.2.840.10008.1.2.4.93", "JPEG 2000 Part 2 Multi-component Image Compression", "JP2000P2", false, true, true, true, false);
        JPIPReferencedUID = TransferSyntax.create(8230, "1.2.840.10008.1.2.4.94", "JPIP Referenced", "JPIPRef", false, false, false, true, false);
        JPIPReferencedDeflateUID = TransferSyntax.create(8231, "1.2.840.10008.1.2.4.95", "JPIP Referenced Deflate", "JPIPRefDeflated", false, false, false, true, false);
        RFC2557MIMEencapsulationUID = TransferSyntax.create(8232, "1.2.840.10008.1.2.6.1", "RFC 2557 MIME encapsulation", "RFC2557MIME", false, false, false, true, false);
        MPEG2MainProfileHighLevelUID = TransferSyntax.create(8233, "1.2.840.10008.1.2.4.101", "MPEG2 Main Profile @ HIGH Level", "MPEG2HL", false, true, false, true, false);
        MPEG4AVCH264HighProfileUID = TransferSyntax.create(8234, "1.2.840.10008.1.2.4.102", "MPEG-4 AVC/H.264 High Profile / Level 4.1", "MPEG4HP", false, true, false, true, false);
        MPEG4AVCH264BDCompHighProfileUID = TransferSyntax.create(8235, "1.2.840.10008.1.2.4.103", "MPEG-4 AVC/H.264 BD Compatible High Profile / Level 4.1", "MPEG4BDCHP", false, true, false, true, false);
        MPEG4AVCH264HighProfileLevel42For2DVideoUID = TransferSyntax.create(8236, "1.2.840.10008.1.2.4.104", "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "MPEG4HP2DV", false, true, false, true, false);
        MPEG4AVCH264HighProfileLevel42For3DVideoUID = TransferSyntax.create(8237, "1.2.840.10008.1.2.4.105", "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "MPEG4HP3DV", false, true, false, true, false);
        MPEG4AVCH264StereoHighProfileLevel42UID = TransferSyntax.create(8238, "1.2.840.10008.1.2.4.106", "MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "MPEG4SHP", false, true, false, true, false);
        HEVCH265MainProfileLevel51UID = TransferSyntax.create(8239, "1.2.840.10008.1.2.4.107", "HEVC/H.265 Main Profile / Level 5.1", "HEVCMP", false, true, false, true, false);
        HEVCH265Main10ProfileLevel51UID = TransferSyntax.create(8240, "1.2.840.10008.1.2.4.108", "HEVC/H.265 Main 10 Profile / Level 5.1", "HEVCM10P", false, true, false, true, false);
        Papyrus3ImplicitVRLittleEndianUID = TransferSyntax.create(8241, "1.2.840.10008.1.20", "Papyrus 3 Implicit VR Little Endian (Retired)", "Papyrus", true, false, true, false, false);
        XMLEncodingUID = TransferSyntax.create(8242, "1.2.840.10008.1.2.6.2", "XML Encoding", "XMLEncoding", false, false, false, true, false);
        EncapsulatedUncompressedExplicitVRLittleEndianUID = TransferSyntax.create(8243, "1.2.840.10008.1.2.1.98", "Encapsulated Uncompressed Explicit VR Little Endian", "EncapsulatedUncompressedExplicitVRLittleEndian", false, true, false, true, false);
        SMPTEST211030PCMDigitalAudioUID = TransferSyntax.create(8244, "1.2.840.10008.1.2.7.3", "SMPTE ST 2110-30 PCM Digital Audio", "SMPTEST2110-30PCMDigitalAudio", false, true, false, true, false);
        SMPTEST211020UncompressedInterlacedActiveVideoUID = TransferSyntax.create(8245, "1.2.840.10008.1.2.7.2", "SMPTE ST 2110-20 Uncompressed Interlaced Active Video", "SMPTEST2110-20UncompressedInterlacedActiveVideo", false, true, false, true, false);
        SMPTEST211020UncompressedProgressiveActiveVideoUID = TransferSyntax.create(8246, "1.2.840.10008.1.2.7.1", "SMPTE ST 2110-20 Uncompressed Progressive Active Video", "SMPTEST2110-20UncompressedProgressiveActiveVideo", false, true, false, true, false);
    }
}

