/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.tool.StringTool;

public class UIDEntry {
    public static final int SOPClass = 1;
    public static final int WellknownSOPInstance = 2;
    public static final int TransferSyntax = 3;
    public static final int MetaSOPClass = 4;
    public static final int ApplicationContextName = 5;
    public static final int CodingScheme = 6;
    private int constant;
    private String value;
    private String name;
    private String shortname;
    private int type;
    private boolean storageSOPClass = false;
    private boolean retired;

    public UIDEntry(int constant, String value, String name, String shortname, int type) {
        this.constant = constant;
        this.value = value;
        this.name = name;
        this.shortname = shortname;
        this.type = type;
        this.storageSOPClass = false;
        this.retired = false;
    }

    UIDEntry(int constant, String value, String name, String shortname, boolean storageSOPClass) {
        this(constant, value, name, shortname, 1, false, storageSOPClass);
    }

    UIDEntry(int constant, String value, String name, String shortname, int type, boolean retired, boolean storageSOPClass) {
        this.constant = constant;
        this.value = value;
        this.name = name;
        this.shortname = shortname;
        this.type = type;
        this.storageSOPClass = storageSOPClass;
        this.retired = retired;
    }

    public int getConstant() {
        return this.constant;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortname;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UIDEntry)) {
            return false;
        }
        return this.constant == ((UIDEntry)obj).constant;
    }

    public String toString() {
        return this.value;
    }

    public String toLongString() {
        return StringTool.fstr(this.value, 30) + StringTool.fstr(this.shortname, 6) + StringTool.fstr(this.name, 40);
    }

    void setStorageSOPClass(boolean b) {
        this.storageSOPClass = b;
    }

    boolean isStorageSOPClass() {
        return this.storageSOPClass;
    }

    void setRetired(boolean retired) {
        this.retired = retired;
    }

    public boolean isRetired() {
        return this.retired;
    }
}

