/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.BulkDataReference;
import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DataElementValue;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.LengthUtils;
import com.archimed.dicom.MultiVRInputStream;
import com.archimed.dicom.MultiVROutputStream;
import com.archimed.dicom.PrimitiveInputStream;
import com.archimed.dicom.PrimitiveOutputStream;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.UID;
import com.archimed.dicom.data.BitTools;
import com.archimed.log.JdtLogger;
import com.archimed.tool.LogUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class VR
extends DataElement {
    private static final long serialVersionUID = 1L;
    static final int SEQ_NEW = 1;
    static final int SEQ_UNDEFLEN = 2;
    static final int SEQ_DEFLEN = 3;
    static final int PUSH_AND_CONTINUE = 1;
    static final int SKIP_AND_CONTINUE = 2;
    static final int PUSH_AND_STOP = 3;
    static final int SKIP_AND_STOP = 4;
    protected int headerLen = 0;
    protected int seqLenState = 1;
    protected transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(VR.class);

    protected VR(DicomObject dcm) {
        this.dcm = dcm;
        this.group = 0;
        this.element = 0;
        this.val = new ArrayList();
        this.dcm_type = 0;
        this.dataLen = 0L;
        this.headerLen = 0;
    }

    protected VR(DicomObject dcm, int g, int e, int dcm_t) {
        this.dcm = dcm;
        this.group = g;
        this.element = e;
        this.dcm_type = dcm_t;
    }

    protected VR(DicomObject dcm, int g, int e, int dcm_t, Object data, int data_l) {
        this.dcm = dcm;
        this.group = g;
        this.element = e;
        this.val = new ArrayList();
        this.dcm_type = dcm_t;
        this.val.add(data);
        this.dataLen = data_l;
        this.headerLen = 8;
    }

    private Object readResolve() throws ObjectStreamException {
        this.log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
        return this;
    }

    void writeVRHeader(PrimitiveOutputStream os, int seqLengthOpt, int groupLengthOpt) throws IOException, DicomException {
        this.printDebugMessage("VR.writeVRHeader", this.group, this.element);
        int transferSyntax = os.getTransferSyntax();
        boolean isEncapsulated = TransferSyntax.isEncapsulated(transferSyntax);
        int dlen = 0;
        byte[] reserved = new byte[]{0, 0};
        os.writeInt16(this.group);
        os.writeInt16(this.element);
        if (this.group == 2) {
            transferSyntax = 8194;
            isEncapsulated = false;
        }
        if (this.dcm_type == 10 && this.mustWriteUndefLenSeq(seqLengthOpt)) {
            dlen = -1;
        } else if (this.isTopLevelPixelData() && isEncapsulated || this.isIconPixelData() && this.size() > 1) {
            dlen = -1;
        } else if (this.isTopLevelPixelData() && !isEncapsulated && this.size() > 0 || this.isIconPixelData() && this.size() <= 1) {
            if (this.val.get(0) instanceof BulkDataReference) {
                BulkDataReference bulkDataReference = (BulkDataReference)this.val.get(0);
                LogUtil.debug(this.log, this.group, this.element, "resolving (early) bulk data reference [index: 0, description: ", bulkDataReference.getDescription(), "]");
                bulkDataReference.resolve();
            }
            this.dataLen = BitTools.makeEven((long)(((DataElementValue)this.val.get(0)).getLength() * (long)this.val.size()));
            dlen = (int)this.dataLen;
        } else if (this.size() == 0) {
            dlen = 0;
        } else {
            boolean hasBulkDataReferences = this.resolveBulkDataReferences();
            if (hasBulkDataReferences) {
                if (seqLengthOpt != 8200 || groupLengthOpt != 1) {
                    throw new DicomException("Usage of BulkDataReferences only supported in combination with undefined sequence length writing and no group lengths");
                }
                this.dataLen = LengthUtils.calculateDataLength(this, this.dcm_type, transferSyntax, seqLengthOpt, groupLengthOpt);
            }
            dlen = (int)this.dataLen;
        }
        if (transferSyntax == 8193 || transferSyntax == 8227) {
            os.writeInt32(dlen);
        } else {
            if (this.dcm_type == 22) {
                this.dcm_type = this.selectOBOW(this.dcm, this.group, this.element, isEncapsulated);
            }
            this.checkOBOW(this.dcm, this.group, this.element, isEncapsulated);
            String typeDesc = DDict.getTypeName(this.dcm_type);
            os.writeString(typeDesc.substring(0, 2));
            switch (this.dcm_type) {
                case 0: 
                case 8: 
                case 10: 
                case 22: 
                case 24: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    os.write(reserved);
                    os.writeInt32(dlen);
                    break;
                }
                default: {
                    os.writeInt16(dlen);
                }
            }
        }
    }

    private void writeSequenceItem(MultiVROutputStream os, DicomObject seq_item, int seqLengthOpt, int groupLengthOpt) throws IOException, DicomException {
        Enumeration e = seq_item.enumerateVRs(os.getTransferSyntax(), seqLengthOpt, groupLengthOpt);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            vr2.writeVRHeader(os, seqLengthOpt, groupLengthOpt);
            vr2.writeVRData(os, seqLengthOpt, groupLengthOpt);
        }
    }

    private boolean mustWriteUndefLenSeq(int seqLengthOpt) {
        if (seqLengthOpt == 8200) {
            return true;
        }
        if (seqLengthOpt == 8201) {
            return false;
        }
        if (seqLengthOpt == 8208) {
            return this.seqLenState != 3;
        }
        if (seqLengthOpt == 8209) {
            return this.seqLenState == 2;
        }
        throw new IllegalArgumentException("unknown seqLengthOpt");
    }

    boolean isTopLevelPixelData() {
        return this.group == 32736 && this.element == 16 && this.dcm.getParent() == null;
    }

    private boolean isIconPixelData() {
        return this.group == 32736 && this.element == 16 && this.dcm.getParent() != null;
    }

    private void writeSequence(MultiVROutputStream os, int seqLengthOpt, int grouplengthOpt) throws DicomException, IOException {
        if (this.mustWriteUndefLenSeq(seqLengthOpt)) {
            for (int i = 0; i < this.val.size(); ++i) {
                DicomObject si = (DicomObject)this.val.get(i);
                os.writeInt16(65534);
                os.writeInt16(57344);
                os.writeInt32(-1);
                this.writeSequenceItem(os, si, seqLengthOpt, grouplengthOpt);
                os.writeInt16(65534);
                os.writeInt16(57357);
                os.writeInt32(0);
            }
            os.writeInt16(65534);
            os.writeInt16(57565);
            os.writeInt32(0);
        } else {
            for (int i = 0; i < this.val.size(); ++i) {
                DicomObject si = (DicomObject)this.val.get(i);
                os.writeInt16(65534);
                os.writeInt16(57344);
                os.writeInt32((int)(LengthUtils.sequenceItemLength(si, os.getTransferSyntax(), seqLengthOpt, grouplengthOpt) - 8L));
                this.writeSequenceItem(os, si, seqLengthOpt, grouplengthOpt);
            }
        }
    }

    private void writeNativePixeldata(MultiVROutputStream os) throws IOException, DicomException {
        long totalLength = 0L;
        for (int i = 0; i < this.val.size(); ++i) {
            long length;
            DataElementValue dataElementValue = (DataElementValue)this.val.get(i);
            if (dataElementValue instanceof ByteArray) {
                ByteArray byteArrayFragment = (ByteArray)dataElementValue;
                if (byteArrayFragment.length() == 0L) continue;
                os.writeByteArray(byteArrayFragment, this.dcm_type);
                totalLength += byteArrayFragment.length();
                continue;
            }
            if (!(dataElementValue instanceof BulkDataReference)) continue;
            BulkDataReference bulkDataReferenceFragment = (BulkDataReference)dataElementValue;
            if (i > 0) {
                LogUtil.debug(this.log, this.group, this.element, "resolving bulk data reference [index: ", i + ", description: ", bulkDataReferenceFragment.getDescription(), "]");
                try {
                    bulkDataReferenceFragment.resolve();
                }
                catch (Throwable th) {
                    this.log.warn(String.format("Exception when resolving bulk data reference (%s", i), th);
                    throw th;
                }
            }
            if ((length = bulkDataReferenceFragment.getLength()) < 0L) {
                throw new DicomException(String.format("Illegal length %s for resolved bulk data reference", length));
            }
            if (length != 0L) {
                os.writeBulkDataReference(bulkDataReferenceFragment, this.dcm_type);
                totalLength += length;
            }
            LogUtil.debug(this.log, this.group, this.element, "releasing bulk data reference [index: ", i + ", description: ", bulkDataReferenceFragment.getDescription() + "]");
            try {
                bulkDataReferenceFragment.release();
                continue;
            }
            catch (Throwable th) {
                this.log.warn(String.format("Exception when releasing bulk data reference (%s)", i), th);
                throw th;
            }
        }
        if (totalLength % 2L > 0L) {
            os.write(0);
        }
    }

    private void writeEncapsulatedPixeldata(MultiVROutputStream os) throws IOException, DicomException {
        for (int i = 0; i < this.val.size(); ++i) {
            long length;
            os.writeInt16(65534);
            os.writeInt16(57344);
            DataElementValue dataElementValue = (DataElementValue)this.val.get(i);
            if (dataElementValue instanceof ByteArray) {
                ByteArray byteArrayFragment = (ByteArray)dataElementValue;
                length = byteArrayFragment.length() % 2L > 0L ? byteArrayFragment.length() + 1L : byteArrayFragment.length();
                os.writeInt32((int)length);
                if (byteArrayFragment.length() == 0L) continue;
                os.write(byteArrayFragment);
                if (byteArrayFragment.length() % 2L <= 0L) continue;
                os.write(0);
                continue;
            }
            if (!(dataElementValue instanceof BulkDataReference)) continue;
            BulkDataReference bulkDataReferenceFragment = (BulkDataReference)dataElementValue;
            LogUtil.debug(this.log, this.group, this.element, "resolving bulk data reference [index: ", i + ", description: ", bulkDataReferenceFragment.getDescription(), "]");
            try {
                bulkDataReferenceFragment.resolve();
            }
            catch (Throwable th) {
                this.log.warn(String.format("Exception when resolving bulk data reference (%s", i), th);
                throw th;
            }
            length = bulkDataReferenceFragment.getLength();
            if (length < 0L) {
                throw new DicomException(String.format("Illegal length %s for resolved bulk data reference", length));
            }
            os.writeInt32((int)(length % 2L > 0L ? length + 1L : length));
            if (length != 0L) {
                os.writeBulkDataReference(bulkDataReferenceFragment, 8);
                if (length % 2L > 0L) {
                    os.write(0);
                }
            }
            LogUtil.debug(this.log, this.group, this.element, "releasing bulk data reference [index: ", i + ", description: ", bulkDataReferenceFragment.getDescription() + "]");
            try {
                bulkDataReferenceFragment.release();
                continue;
            }
            catch (Throwable th) {
                this.log.warn(String.format("Exception when releasing bulk data reference (%s)", i), th);
                throw th;
            }
        }
        os.writeInt16(65534);
        os.writeInt16(57565);
        os.writeInt32(0);
    }

    void writeVRData(MultiVROutputStream os, int seqLengthOpt, int groupLengthOpt) throws IOException, DicomException {
        boolean isEncapsulated = TransferSyntax.isEncapsulated(os.getTransferSyntax());
        switch (this.dcm_type) {
            case 10: {
                this.printDebugMessage("VR.writeVRData <sequence>", this.group, this.element);
                this.writeSequence(os, seqLengthOpt, groupLengthOpt);
                return;
            }
            case 8: 
            case 22: 
            case 24: {
                if (this.isTopLevelPixelData() && isEncapsulated || this.isIconPixelData() && this.size() > 1) {
                    this.printDebugMessage("VR.writeVRData <encapsulated pixel data (top level or icon)>", this.group, this.element);
                    this.writeEncapsulatedPixeldata(os);
                    return;
                }
                if (this.isTopLevelPixelData() && !isEncapsulated || this.isIconPixelData() && this.size() <= 1) {
                    this.printDebugMessage("VR.writeVRData <native pixel data (top level or icon)>", this.group, this.element);
                    if (os.getTransferSyntax() == 8227) {
                        this.printDebugMessage("GEPrivate syntax: setting pixeldata to OW and temporarely switching to ExplicitVRBigEndian to write big endian OW pixel data", this.group, this.element);
                        this.dcm_type = 24;
                        os.setTransferSyntax(8195);
                    }
                    this.writeNativePixeldata(os);
                    if (os.getTransferSyntax() == 8227) {
                        this.printDebugMessage("switching back to GEPrivate", this.group, this.element);
                        os.setTransferSyntax(8227);
                    }
                    return;
                }
                if (this.size() != 1) break;
                this.printDebugMessage("VR.writeVRData <single valued OB,OW or OL>", this.group, this.element);
                os.writeVRValues(this.val, this.dcm_type);
                break;
            }
            default: {
                if (this.dataLen == 0L || this.size() == 0) {
                    this.printDebugMessage("VR.writeVRData <empty>", this.group, this.element);
                    break;
                }
                this.printDebugMessage("VR.writeVRData <normal>", this.group, this.element);
                os.writeVRValues(this.val, this.dcm_type);
            }
        }
        this.releaseBulkDataReferences();
    }

    int readVR(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is) throws IOException, DicomException {
        long offset = is.getOffset();
        this.readVRHeader(is);
        if (this.dataLen > Jdt.getMaxDataElementLength() && this.dataLen != 0xFFFFFFFFL) {
            String s = String.format("value length of tag %s exceeds specified limit of %s, file probably corrupt", DumpUtils.tagDescriptionString(this.group, this.element), Jdt.getMaxDataElementLength());
            this.log.fatal(s);
            throw new DicomException(s);
        }
        if (this.group == 65534 && this.element == 57357) {
            return 2;
        }
        TagReadEvent tre = dicomReader.fireAfterReadHeader(this, is, offset);
        if (tre == null || tre.getDataReadStatus() == 0) {
            ReadState readState = new ReadState();
            this.readVRData(dcm, dicomReader, is, readState, tre == null ? 0L : tre.getMaxReadLength());
            if (tre != null) {
                tre.setBytesSkipped(readState.getBytesSkipped());
                tre = dicomReader.fireAfterReadData(tre);
            }
            if (readState.isStopped()) {
                return 3;
            }
            if (this.element != 0) {
                if (tre == null) {
                    return 1;
                }
                if (tre.getDataReadStatus() == 0) {
                    return tre.isStopReading() ? 3 : 1;
                }
                if (tre.getDataReadStatus() == 2) {
                    return tre.isStopReading() ? 4 : 2;
                }
                if (tre.getDataReadStatus() == 1) {
                    this.val.clear();
                    return tre.isStopReading() ? 4 : 2;
                }
                return tre.isStopReading() ? 3 : 1;
            }
            return tre != null && tre.isStopReading() ? 4 : 2;
        }
        if (tre.getDataReadStatus() == 1) {
            if (this.dataLen == 0xFFFFFFFFL) {
                this.skipUndefinedLengthTag(dcm, dicomReader, is, new ReadState());
            } else {
                is.skipBytes(this.dataLen);
            }
            this.dataLen = 0L;
            if (this.element != 0) {
                return tre.isStopReading() ? 3 : 1;
            }
            return tre.isStopReading() ? 4 : 2;
        }
        if (tre.getDataReadStatus() == 2) {
            if (tre.isStopReading()) {
                return 4;
            }
            if (this.dataLen == 0xFFFFFFFFL) {
                this.skipUndefinedLengthTag(dcm, dicomReader, is, new ReadState());
            } else {
                is.skipBytes(this.dataLen);
            }
            return 2;
        }
        if (tre.getDataReadStatus() == 3) {
            return tre.isStopReading() ? 4 : 2;
        }
        return tre.isStopReading() ? 4 : 2;
    }

    private void skipUndefinedLengthTag(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState) throws DicomException, IOException {
        switch (this.dcm_type) {
            case 10: {
                this.readSequence(dcm, dicomReader, is, new ReadState());
                break;
            }
            case 8: 
            case 22: 
            case 24: {
                this.readCompressedPixelData(is, true, 0L, readState);
                break;
            }
            case 0: {
                this.readUNVRUndefinedLength(dcm, dicomReader, is);
                break;
            }
            default: {
                throw new DicomException("encountered illegal undefined length for VR: " + DDict.getTypeCodeName(this.dcm_type));
            }
        }
    }

    private boolean readVRHeader(PrimitiveInputStream is) throws IOException, DicomException {
        String tc;
        long offset;
        block20: {
            offset = is.getOffset();
            int ts = is.getTransferSyntax();
            this.group = is.readUInt16();
            this.element = is.readUInt16();
            tc = null;
            if (this.group == 2 && this.dcm.getParent() == null) {
                ts = 8194;
            }
            if (this.element == 0) {
                this.dcm_type = 1;
            } else if (DDictBase.isPrivateTag(this.group, this.element)) {
                String creator = null;
                try {
                    creator = this.dcm.getString_ge(this.group, this.element >> 8, 0);
                    this.dcm_type = DDict.getTypeCode(this.group, this.element, creator);
                }
                catch (Throwable ex) {
                    this.log.warn("Exception while getting private creator for private data element: " + ex);
                    creator = null;
                    this.dcm_type = DDict.getTypeCode(this.group, this.element);
                }
            } else {
                this.dcm_type = DDictBase.isPrivateCreatorTag(this.group, this.element) ? 6 : DDict.getTypeCode(this.group, this.element);
            }
            if (ts == 8193 || ts == 8227) {
                this.dataLen = is.readUInt32AsLong();
                this.headerLen = 8;
                this.adjustTypes();
            } else {
                tc = is.readString(2);
                if (this.group != 65534 || this.element != 57357) {
                    try {
                        this.dcm_type = DDict.getTypeCode(tc);
                    }
                    catch (DicomException ex) {
                        if (this.group == 2 && Jdt.isReadFileMetaImplicit()) {
                            is.unread(tc.getBytes());
                            this.dataLen = is.readUInt32AsLong();
                            this.headerLen = 8;
                            break block20;
                        }
                        throw ex;
                    }
                }
                switch (this.dcm_type) {
                    case 0: 
                    case 8: 
                    case 10: 
                    case 24: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        is.skipBytes(2L);
                        this.dataLen = is.readUInt32AsLong();
                        this.headerLen = 12;
                        break;
                    }
                    default: {
                        this.dataLen = is.readUInt16();
                        this.headerLen = 8;
                    }
                }
                if (Jdt.isLookupDDict() && this.dcm_type == 0) {
                    this.dcm_type = DDict.getTypeCode(this.group, this.element);
                }
            }
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("VR.readVRHeader (ts: ");
            sb.append(UID.getUIDEntry(is.getTransferSyntax()).getValue());
            sb.append(") offset: ");
            sb.append(offset);
            sb.append(" length: ");
            sb.append(this.dataLen);
            if (tc != null) {
                sb.append(" VR: ");
                sb.append(tc);
            }
            this.printDebugMessage(sb.toString(), this.group, this.element);
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
        return true;
    }

    private void adjustTypes() {
        int dct;
        if (this.dcm_type == 22 && ((dct = DDict.lookupDDict(this.group, this.element)) == 2145386512 || dct == 1409290256 || dct == 2626049 || dct == 2626050 || dct == 2626051 || dct == 0x281221 || dct == 0x281222 || dct == 2626083)) {
            this.dcm_type = 24;
        }
    }

    DicomObject readOrphanedSequenceItem(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream multiVRin, int itemIndex) throws IOException, DicomException {
        ReadState readState = new ReadState();
        return this.readSequenceItem(dcm, dicomReader, multiVRin, readState, itemIndex);
    }

    private DicomObject readSequenceItem(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState, int itemIndex) throws IOException, DicomException {
        DicomObject v = new DicomObject(dcm);
        v.offset = is.getOffset() - 4L;
        long len = is.readUInt32AsLong();
        dicomReader.fireBeforeReadSequenceItem(this, v, is, itemIndex);
        if (len != 0xFFFFFFFFL) {
            v.setSeqItemLenState(3);
            v.length = 0L;
            long end = is.getOffset() + len;
            while (is.getOffset() != end) {
                VR vr2 = new VR(v);
                int rs = vr2.readVR(v, dicomReader, is);
                v.length += (long)vr2.headerLen;
                v.length += vr2.dataLen;
                if (rs == 1) {
                    v.push(vr2);
                    continue;
                }
                if (rs == 3) {
                    v.push(vr2);
                    readState.setStopped(true);
                    return v;
                }
                if (rs == 2 || rs != 4) continue;
                readState.setStopped(true);
                return v;
            }
        } else {
            v.setSeqItemLenState(2);
            boolean item_end = false;
            v.length = 0L;
            while (!item_end) {
                VR vr3 = new VR(v);
                int rs = vr3.readVR(v, dicomReader, is);
                if (vr3.group != 65534 || vr3.element != 57357) {
                    v.length += (long)vr3.headerLen;
                    v.length += vr3.dataLen;
                    if (rs == 1) {
                        v.push(vr3);
                        continue;
                    }
                    if (rs == 3) {
                        v.push(vr3);
                        readState.setStopped(true);
                        return v;
                    }
                    if (rs == 2 || rs != 4) continue;
                    readState.setStopped(true);
                    return v;
                }
                break;
            }
        }
        v.length += 16L;
        dicomReader.fireAfterReadSequenceItem(this, v, is, itemIndex);
        return v;
    }

    private List readSequence(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState) throws DicomException, IOException {
        ArrayList<DicomObject> seq = new ArrayList<DicomObject>();
        int itemIndex = 0;
        if (this.dataLen != 0xFFFFFFFFL) {
            this.seqLenState = 3;
            long end = is.getOffset() + this.dataLen;
            this.dataLen = 0L;
            while (is.getOffset() != end) {
                DicomObject seq_item;
                int tagg = is.readUInt16();
                int tage = is.readUInt16();
                if (tagg != 65534 || tage != 57344 || (seq_item = this.readSequenceItem(dcm, dicomReader, is, readState, itemIndex++)) == null) continue;
                this.dataLen += seq_item.length;
                seq.add(seq_item);
                if (!readState.isStopped()) continue;
                break;
            }
        } else {
            this.seqLenState = 2;
            boolean seq_end = false;
            this.dataLen = 0L;
            while (!seq_end) {
                int tagg = is.readUInt16();
                int tage = is.readUInt16();
                if (tagg == 65534 && tage == 57344) {
                    DicomObject seq_item;
                    if ((seq_item = this.readSequenceItem(dcm, dicomReader, is, readState, itemIndex++)) == null) continue;
                    this.dataLen += seq_item.length;
                    seq.add(seq_item);
                    if (!readState.isStopped()) continue;
                    break;
                }
                if (tagg == 65534 && tage == 57565) {
                    is.skipBytes(4L);
                    seq_end = true;
                    continue;
                }
                if (Jdt.isNoSeqDelim()) {
                    this.log.warn("unexpected tag read in private sequence of undefined length and seqdelim=true: unreading 4bytes and treating this as end of sequence");
                    is.unreadUInt16(tage);
                    is.unreadUInt16(tagg);
                    seq_end = true;
                    continue;
                }
                this.log.error("unexpected tag read in private sequence of undefined length and seqdelim=false: throwing exception");
                throw new DicomException("Unexpected tag read: (" + tagg + "," + tage + ") at offset " + is.getOffset());
            }
        }
        this.dataLen += 8L;
        return seq;
    }

    private List readUNVRUndefinedLength(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is) throws DicomException, IOException {
        ArrayList<DicomObject> seq = new ArrayList<DicomObject>();
        int orgts = is.getTransferSyntax();
        is.setTransferSyntax(8193);
        boolean firstTime = true;
        boolean seq_end = false;
        this.dataLen = 0L;
        int itemIndex = 0;
        while (!seq_end) {
            int tagg = is.readUInt16();
            int tage = is.readUInt16();
            if (tagg == 65534 && tage == 57344) {
                DicomObject seq_item;
                if (firstTime) {
                    this.dcm_type = 10;
                    firstTime = false;
                }
                if ((seq_item = this.readSequenceItem(dcm, dicomReader, is, new ReadState(), itemIndex++)) == null) continue;
                this.dataLen += seq_item.length;
                seq.add(seq_item);
                continue;
            }
            if (tagg == 65534 && tage == 57565) {
                is.skipBytes(4L);
                seq_end = true;
                continue;
            }
            if (Jdt.isNoSeqDelim()) {
                this.log.warn("unexpected tag read in private sequence of undefined length and seqdelim=true: unreading 4bytes and treating this as end of sequence");
                is.unreadUInt16(tage);
                is.unreadUInt16(tagg);
                seq_end = true;
                continue;
            }
            this.log.error("unexpected tag read in private sequence of undefined length and seqdelim=false: throwing exception");
            throw new DicomException("Unexpected tag read: (" + tagg + "," + tage + ") at offset " + is.getOffset());
        }
        this.dataLen += 8L;
        is.setTransferSyntax(orgts);
        return seq;
    }

    private List readCompressedPixelData(MultiVRInputStream is, boolean skip, long maxReadLength, ReadState readState) throws DicomException, IOException {
        List<ByteArray> fragments = is.readFragments(skip, maxReadLength, readState);
        long _dataLen = 0L;
        for (ByteArray byteArray : fragments) {
            _dataLen = _dataLen + byteArray.length() + 8L;
        }
        this.dataLen = (_dataLen += 8L) + readState.getBytesSkipped();
        return fragments;
    }

    private void checkCorruptDAs(MultiVRInputStream is) throws IOException {
        if (this.dcm_type != 11 || this.dataLen != 8L) {
            return;
        }
        this.printDebugMessage("Checking DA corruption for:", this.getGroup(), this.getElement());
        if (is.available() == 0) {
            this.log.debug("0 bytes available in stream: -> resetting tag length to 0");
            this.dataLen = 0L;
            return;
        }
        is.mark(8);
        boolean knownTag = false;
        int nextGroup = is.readUInt16();
        int nextElem = is.readUInt16();
        if (DDict.lookupDDict(nextGroup, nextElem) != -1) {
            this.printDebugMessage("\t8 next bytes can be interpreted as a known tag", nextGroup, nextElem);
            knownTag = true;
        } else {
            this.printDebugMessage("\t8 next bytes can NOT be interpreted as a known tag", nextGroup, nextElem);
        }
        is.reset();
        boolean illegalChar = false;
        byte[] buf = new byte[8];
        is.read(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] >= 48 && buf[i] <= 57) continue;
            this.printDebugMessage("\tfound non-numerical char for", this.getGroup(), this.getElement());
            illegalChar = true;
            break;
        }
        if (!illegalChar) {
            this.printDebugMessage("\tall chars numerical for", this.getGroup(), this.getElement());
        }
        is.reset();
        if (knownTag && illegalChar) {
            this.log.debug("\t-> RESETTING length to 0");
            this.dataLen = 0L;
        } else {
            this.log.debug("\t-> keeping tag as is");
        }
    }

    private void readVRData(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState, long maxReadLength) throws IOException, DicomException {
        if (Jdt.isFixDA()) {
            this.checkCorruptDAs(is);
        }
        if (this.dataLen == 0L) {
            this.printDebugMessage("VR.readVRData <empty>", this.group, this.element);
            this.val = new ArrayList();
            return;
        }
        if (this.dcm_type == 10) {
            this.printDebugMessage("VR.readVRData <sequence>", this.group, this.element);
            this.val = this.readSequence(dcm, dicomReader, is, readState);
            return;
        }
        if (this.dataLen == 0xFFFFFFFFL) {
            if (this.dcm_type == 0) {
                this.printDebugMessage("VR.readVRData <type unknown and undefined length>", this.group, this.element);
                this.val = this.readUNVRUndefinedLength(dcm, dicomReader, is);
                return;
            }
            if (this.dcm_type == 8 || this.dcm_type == 24 || this.dcm_type == 22) {
                this.printDebugMessage("VR.readVRData <type OB or OW and undefined length>", this.group, this.element);
                this.val = this.readCompressedPixelData(is, false, maxReadLength, readState);
                return;
            }
            throw new DicomException("illegal type with undefined length: " + DDict.getTypeCode(this.dcm_type));
        }
        this.printDebugMessage("VR.readVRData <normal>", this.group, this.element);
        int ts = is.getTransferSyntax();
        if (this.group == 32736 && this.element == 16 && ts == 8227) {
            this.printDebugMessage("GEPrivate syntax: setting pixeldata to OW and temporarely switching to ExplicitVRBigEndian to read big endian OW pixel data", this.group, this.element);
            this.dcm_type = 24;
            is.setTransferSyntax(8195);
        }
        try {
            this.val = is.readVRValues(this.dcm_type, this.dataLen, dcm.dicomCharsets(), maxReadLength, readState);
        }
        catch (EOFException ex) {
            String s = "Encountered EOFException while reading data part of data element ";
            s = s + DumpUtils.tagString(this.group, this.element) + " with specified length: " + this.dataLen;
            s = s + ". Data Element will be added or not depending on value of Jdt property 'readincompletetag'";
            this.log.error(s);
            throw ex;
        }
        if (this.group == 32736 && this.element == 16 && ts == 8227) {
            this.printDebugMessage("switching back to GEPrivate", this.group, this.element);
            is.setTransferSyntax(8227);
        }
    }

    private int selectOBOW(DicomObject dcm, int group, int element, boolean encapsulated) {
        int tag2 = DDict.lookupDDict(group, element);
        boolean topLevel = dcm.getParent() == null;
        switch (tag2) {
            case 2145386512: {
                if (topLevel && encapsulated) {
                    return 8;
                }
                return 24;
            }
        }
        return 24;
    }

    private void checkOBOW(DicomObject dcm, int group, int element, boolean encapsulated) {
        boolean topLevel;
        int tag2 = DDict.lookupDDict(group, element);
        boolean bl = topLevel = dcm.getParent() == null;
        if (tag2 == 2145386512 && topLevel && encapsulated && this.dcm_type == 24) {
            this.log.warn("Pixeldata in top-level Data Set must have VR OB when transfer syntax is encapsulated");
        }
    }

    private boolean resolveBulkDataReferences() throws IOException {
        boolean hasBulkDataReferences = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.val.get(i) instanceof BulkDataReference)) continue;
            BulkDataReference bulkDataReference = (BulkDataReference)this.val.get(i);
            LogUtil.debug(this.log, this.group, this.element, "resolving bulk data reference [index: ", i + "", ", description: ", bulkDataReference.getDescription(), "]");
            bulkDataReference.resolve();
            hasBulkDataReferences = true;
        }
        return hasBulkDataReferences;
    }

    private void releaseBulkDataReferences() throws IOException {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.val.get(i) instanceof BulkDataReference)) continue;
            BulkDataReference bulkDataReference = (BulkDataReference)this.val.get(i);
            LogUtil.debug(this.log, this.group, this.element, "releasing bulk data reference [index: ", i + "", ", description: ", bulkDataReference.getDescription(), "]");
            bulkDataReference.release();
        }
    }

    private void printDebugMessage(String msg, int g, int e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg + " " + DumpUtils.tagDescriptionString(g, e));
        }
    }

    private void printDebugMessage(String msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
    }

    class ReadState {
        boolean stopped = false;
        long bytesSkipped = 0L;

        ReadState() {
        }

        public void setStopped(boolean b) {
            this.stopped = b;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public long getBytesSkipped() {
            return this.bytesSkipped;
        }

        public void setBytesSkipped(long bytesSkipped) {
            this.bytesSkipped = bytesSkipped;
        }
    }
}

