/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.codec;

import com.archimed.codec.jpeg.Jpeg14Decoder;
import com.archimed.codec.jpeg.Jpeg14Encoder;
import com.archimed.codec.jpeg.JpegUtil;
import com.archimed.codec.rle.RLEDecoder;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.iioplugin.image.DicomImageObject;
import com.archimed.dicom.iioplugin.image.DicomImageObjectBuilder;
import com.archimed.log.JdtLogger;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Compression {
    DicomObject dcm;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Compression.class);
    private static final String MONOCHROME1 = "MONOCHROME1";
    private static final String MONOCHROME2 = "MONOCHROME2";
    private static final String RGB = "RGB";
    public static final int COLORBYPIXEL = 0;
    public static final int COLORBYPLANE = 1;

    public Compression() {
        this.dcm = null;
    }

    public Compression(DicomObject d) throws DicomException {
        this.setDicomObject(d);
    }

    public void decompress() throws DicomException, IOException {
        if (this.dcm == null) {
            throw new DicomException("Use setDicomObject first to specify a DicomObject");
        }
        DicomObject metainfo = this.dcm.getFileMetaInformation();
        if (metainfo == null) {
            throw new DicomException("no file meta information");
        }
        TransferSyntaxUID transferSyntaxUID = TransferSyntax.get(metainfo.getString(131088, 0));
        if (transferSyntaxUID == null) {
            throw new DicomException("Decompression not possible: no transfersyntax found or transfer syntax unknown");
        }
        DicomImageObject dicomImageObject = new DicomImageObjectBuilder().buildDicomImageObject(this.dcm);
        int width = dicomImageObject.getColumns();
        int height = dicomImageObject.getRows();
        int numberOfFrames = dicomImageObject.getNumberOfFrames();
        ByteArrayOutputStream frames = new ByteArrayOutputStream();
        Object pixelData = null;
        this.dcm.deleteItem(2145386512, 0);
        for (int i = 0; i < numberOfFrames; ++i) {
            byte[] inputFrame;
            if (!transferSyntaxUID.isFragmentedFrames()) {
                inputFrame = this.dcm.getBytes(2145386512, 0);
                this.dcm.deleteItem(2145386512, 0);
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while (true) {
                    byte[] fragment = this.dcm.getBytes(2145386512, 0);
                    bout.write(fragment);
                    if (JpegUtil.hasEOIMarker(fragment)) break;
                    this.dcm.deleteItem(2145386512, 0);
                }
                inputFrame = bout.toByteArray();
            }
            byte[] frame = Compression.decompressFrame(transferSyntaxUID.getConstant(), inputFrame, width, height);
            frames.write(frame);
        }
        this.dcm.set(2145386512, frames.toByteArray());
        try {
            this.dcm.getFileMetaInformation().set(131088, UID.getUIDEntry(8194).getValue());
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
    }

    public static byte[] decompressFrame(int encoding, byte[] frame, int w, int h) throws DicomException, IOException {
        if (encoding == 8197) {
            Jpeg14Decoder decoder = new Jpeg14Decoder();
            byte[] temp = decoder.decode(frame);
            return temp;
        }
        if (encoding == 8198) {
            ByteArrayInputStream bais = new ByteArrayInputStream(frame);
            RLEDecoder RLEDecoder2 = new RLEDecoder();
            RLEDecoder2.setDimension(w, h);
            return RLEDecoder2.read((InputStream)bais);
        }
        if (encoding == 8196) {
            Image im = Toolkit.getDefaultToolkit().createImage(frame);
            PixelGrabber pg = new PixelGrabber(im, 0, 0, w, h, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException ie) {
                Jdt.getJdtLoggerFactory().getJdtLogger(Compression.class).error("", ie);
            }
            try {
                return (byte[])pg.getPixels();
            }
            catch (ClassCastException e) {
                return Compression.intArrayToByteArray((int[])pg.getPixels());
            }
        }
        throw new DicomException("unsupported transfer syntax for decompression");
    }

    private static byte[] intArrayToByteArray(int[] p) {
        byte[] t = new byte[p.length * 3];
        for (int i = 0; i < p.length; ++i) {
            t[3 * i] = (byte)((p[i] & 0xFF0000) >> 16);
            t[3 * i + 1] = (byte)((p[i] & 0xFF00) >> 8);
            t[3 * i + 2] = (byte)(p[i] & 0xFF);
        }
        return t;
    }

    public void compress(int ts) throws IOException, DicomException {
        int encoding;
        if (this.dcm == null) {
            throw new DicomException("Use setDicomObject first to specify a DicomObject");
        }
        if (ts != 8197) {
            throw new DicomException("unsupported transfer syntax for compression");
        }
        try {
            DicomObject metainfo = this.dcm.getFileMetaInformation();
            encoding = metainfo == null ? 8193 : (metainfo.getSize(131088) > 0 ? UID.getUIDEntry(metainfo.getS(131088)).getConstant() : 8193);
        }
        catch (UnknownUIDException e) {
            throw new DicomException("Decompression not possible: " + e.getMessage());
        }
        if (encoding != 8195 && encoding != 8194 && encoding != 8193) {
            throw new DicomException("associated DicomObject already has a compressed transfer syntax");
        }
        int w = this.dcm.getI(2621457);
        int h = this.dcm.getI(2621456);
        int frames = 1;
        if (this.dcm.getSize(0x280008) > 0) {
            frames = this.dcm.getI(0x280008);
        }
        byte[] pixeldata = (byte[])this.dcm.get(2145386512);
        int bitsAllocated = this.dcm.getI(2621696);
        String photometricInterpretation = (String)this.dcm.get(2621444);
        if (photometricInterpretation == null) {
            throw new DicomException("photometric interpretation tag missing");
        }
        if (!((photometricInterpretation = photometricInterpretation.trim()).equals(MONOCHROME1) || photometricInterpretation.equals(MONOCHROME2) || photometricInterpretation.equals(RGB))) {
            throw new DicomException("unsupported photometric interpretation: " + photometricInterpretation);
        }
        int planarConfiguration = 0;
        if (photometricInterpretation.equals(RGB)) {
            Integer pC = (Integer)this.dcm.get(2621446);
            if (pC == null) {
                throw new DicomException("planar configuration tag missing for RGB image");
            }
            planarConfiguration = pC;
            if (planarConfiguration < 0 || planarConfiguration > 1) {
                throw new DicomException("illegal planar configuration tag: " + planarConfiguration);
            }
            this.dcm.set(2621446, new Integer(0));
        }
        this.dcm.deleteItem(2145386512, 0);
        this.dcm.set(2145386512, new byte[0], 0);
        if (frames == 1) {
            this.dcm.set(2145386512, Compression.compressJPEGLosslessFrame(photometricInterpretation, planarConfiguration, bitsAllocated, pixeldata, w, h), 1);
        } else {
            byte[] frame;
            if (bitsAllocated == 8) {
                frame = new byte[w * h];
            } else if (bitsAllocated == 16) {
                frame = new byte[w * h * 2];
            } else if (bitsAllocated == 24) {
                frame = new byte[w * h * 3];
            } else {
                throw new DicomException("unsupported value for Bits Allocated: " + bitsAllocated + " (should be 8,16 or 24)");
            }
            for (int i = 0; i < frames; ++i) {
                System.arraycopy(pixeldata, i * frame.length, frame, 0, frame.length);
                this.dcm.append(2145386512, Compression.compressJPEGLosslessFrame(photometricInterpretation, planarConfiguration, bitsAllocated, frame, w, h));
            }
        }
        DicomObject fmi = this.dcm.getFileMetaInformation();
        try {
            if (fmi != null) {
                fmi.set(131088, UID.getUIDEntry(ts).getValue());
            }
        }
        catch (IllegalValueException e) {
            this.log.debug("unexpected error: " + e);
        }
    }

    private static byte[] compressJPEGLosslessFrame(String photometricInterpretation, int planarConfiguration, int bitsAllocated, byte[] frame, int w, int h) throws IOException, DicomException {
        Jpeg14Encoder encoder = new Jpeg14Encoder();
        if (photometricInterpretation.equals(MONOCHROME1) || photometricInterpretation.equals(MONOCHROME2)) {
            if (bitsAllocated == 8) {
                if (frame.length < w * h) {
                    throw new DicomException("not enough pixeldata < " + w * h);
                }
                return encoder.encode8bitGrayscale(frame, w, h);
            }
            if (bitsAllocated == 16) {
                if (frame.length < w * h * 2) {
                    throw new DicomException("not enough pixeldata < " + w * h * 2);
                }
                return encoder.encode16bitGrayscale(frame, w, h);
            }
            throw new DicomException("unsupported bitsAllocated value: " + bitsAllocated);
        }
        if (photometricInterpretation.equals(RGB)) {
            if (frame.length < w * h * 3) {
                throw new DicomException("not enough pixeldata < " + w * h * 3);
            }
            byte[] red = new byte[w * h];
            byte[] green = new byte[w * h];
            byte[] blue = new byte[w * h];
            if (planarConfiguration == 0) {
                for (int i = 0; i < red.length; ++i) {
                    red[i] = frame[3 * i];
                    green[i] = frame[3 * i + 1];
                    blue[i] = frame[3 * i + 2];
                }
                return encoder.encode24bitColor(red, green, blue, w, h);
            }
            if (planarConfiguration == 1) {
                System.arraycopy(frame, 0, red, 0, red.length);
                System.arraycopy(frame, w * h, green, 0, green.length);
                System.arraycopy(frame, 2 * w * h, blue, 0, blue.length);
                return encoder.encode24bitColor(red, green, blue, w, h);
            }
            throw new DicomException("illegal planar configuration");
        }
        throw new DicomException("Unsupported photometric interpretation for encoding to lossless jpeg: " + photometricInterpretation);
    }

    public static byte[] compressFrame(int encoding, byte[] frame, int w, int h) throws IOException, DicomException {
        return Compression.compressFrame(encoding, frame, w, h, 0);
    }

    public static byte[] compressFrame(int encoding, byte[] frame, int w, int h, int planarConfiguration) throws IOException, DicomException {
        if (encoding == 8197) {
            if (frame.length == w * h) {
                return Compression.compressJPEGLosslessFrame(MONOCHROME2, 0, 8, frame, w, h);
            }
            if (frame.length == w * h * 2) {
                return Compression.compressJPEGLosslessFrame(MONOCHROME2, 0, 16, frame, w, h);
            }
            if (frame.length == w * h * 3) {
                return Compression.compressJPEGLosslessFrame(RGB, planarConfiguration, 24, frame, w, h);
            }
            throw new DicomException("length of frame to compress is not equal to width*height or width*height*2 or width*height*3");
        }
        throw new DicomException("unsupported transfer syntax for compression");
    }

    public void setDicomObject(DicomObject d) throws DicomException {
        this.dcm = d;
    }

    public DicomObject getDicomObject() {
        return this.dcm;
    }
}

