/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ApplicationContextItem {
    private byte itemtype = (byte)16;
    private String applicationcontext = "1.2.840.10008.3.1.1.1";

    ApplicationContextItem() {
    }

    int getLength() {
        return this.applicationcontext.length() + 4;
    }

    void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.applicationcontext.length());
        out.write(this.applicationcontext.getBytes());
    }

    protected int read(DataInputStream in) throws IOException, IllegalValueException {
        boolean r = false;
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received Application Context Item  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        buf = StringTool.trimZeros(buf);
        if (!this.applicationcontext.equals(new String(buf))) {
            throw new IllegalValueException("received Application Context Name  not " + this.applicationcontext);
        }
        return 4 + length;
    }
}

