/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociateAcknowledgePdu;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduBuffer;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class AssociateAcknowledgeParser
implements PduParser {
    protected AssociateAcknowledgeParser() {
    }

    @Override
    public void format(Pdu pdu, PduBuffer pduBuffer) throws PduException {
        if (pdu.getType() != 2 || !(pdu instanceof Acknowledge)) {
            throw new PduException("class " + this.getClass().getName() + " can only format Associate Acknowledge PDU");
        }
        try {
            AssociateAcknowledgePdu ackPdu = new AssociateAcknowledgePdu((Acknowledge)pdu);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(ackPdu.getLength());
            ackPdu.write(bout);
            pduBuffer.setBytes(bout.toByteArray());
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }

    @Override
    public Pdu parse(PduBuffer pduBuffer) throws PduException {
        AssociateAcknowledgePdu ackPdu = new AssociateAcknowledgePdu();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(pduBuffer.getBytes(), 0, pduBuffer.getLength());
            ackPdu.read(bin);
            bin.close();
            return ackPdu.getAcknowledge();
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (UnknownUIDException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }
}

