/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.Reject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

class AssociateRejectPdu {
    private int pdutype = 3;
    private int length;
    private int result;
    private int source;
    private int reason;

    public AssociateRejectPdu() {
    }

    public AssociateRejectPdu(int result, int source, int reason) {
        this.result = result;
        this.source = source;
        this.reason = reason;
    }

    public Reject getReject() {
        Reject reject = new Reject(this.result, this.source, this.reason);
        return reject;
    }

    public void read(InputStream in) throws IOException, IllegalValueException {
        PushbackInputStream pbin = new PushbackInputStream(in);
        DataInputStream din = new DataInputStream(pbin);
        int b = din.read();
        if (b != this.pdutype) {
            throw new IllegalValueException("PDU-type field of Associate Reject PDU not " + this.pdutype);
        }
        din.read();
        this.length = din.readInt();
        din.read();
        this.result = in.read();
        this.source = in.read();
        this.reason = in.read();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        out.write(this.pdutype);
        out.write(0);
        dout.writeInt(4);
        out.write(0);
        out.write(this.result);
        out.write(this.source);
        out.write(this.reason);
        out.flush();
    }
}

