/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.AbortException;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.PDataTF;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduReader;
import com.archimed.dicom.network.ULServiceMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

class DimseReader {
    private PduReader pduReader;
    private PDataTF.PDV curpdv;
    private Iterator it;
    private byte[] curbuf;
    private int curoffset;
    private int curavail;
    private int curpcid = -1;

    public DimseReader(PduReader pduReader) {
        this.pduReader = pduReader;
    }

    public ULServiceMessage read(PDataTF pDataTF) throws IOException, PduException, DicomException {
        this.curpcid = -1;
        if (pDataTF.getLength() == 6) {
            this.nextPDataTF();
        } else {
            this.initFromPDataTF(pDataTF);
        }
        if (!this.nextPDV(true)) {
            throw new PduException("PDV not of command type");
        }
        PDataTFInputStream pDataTFin = new PDataTFInputStream(true);
        Command cmd = new Command();
        cmd.read(pDataTFin, 8193, true);
        pDataTFin = cmd.hasData() ? new PDataTFInputStream(false) : null;
        return new Dimse(this.curpcid, cmd, pDataTFin);
    }

    private void initFromPDataTF(PDataTF pDataTF) {
        this.it = pDataTF.getPDVs().iterator();
        this.curbuf = this.pduReader.getPduBuffer().getBytes();
        this.curavail = 0;
        this.curoffset = 0;
        this.curpdv = null;
    }

    private void nextPDataTF() throws IOException, AbortException, PduException {
        Pdu pdu;
        while ((pdu = this.pduReader.read()).getType() == 4) {
            if (this.pduReader.getPduBuffer().getLength() == 6) continue;
            this.initFromPDataTF((PDataTF)pdu);
            return;
        }
        if (pdu.getType() == 7) {
            throw new AbortException("Association aborted: " + pdu, (Abort)pdu);
        }
        throw new PduException("Unexpected pdu received: " + pdu);
    }

    private boolean nextPDV(boolean cmd) throws IOException, PduException {
        if (this.curpdv != null && this.curpdv.command == cmd && this.curpdv.last) {
            return false;
        }
        if (this.it.hasNext()) {
            this.curpdv = (PDataTF.PDV)this.it.next();
            this.curoffset = this.curpdv.offset + 6;
            this.curavail = this.curpdv.length - 2;
            if (this.curpdv.command != cmd) {
                return false;
            }
            if (this.curpcid == -1) {
                this.curpcid = this.curpdv.pcid;
            } else if (this.curpcid != this.curpdv.pcid) {
                throw new PduException("presentation context id inconsistent: " + this.curpdv.pcid + " (read), " + this.curpcid + " (previous)");
            }
            return true;
        }
        this.nextPDataTF();
        return this.nextPDV(cmd);
    }

    private class PDataTFInputStream
    extends InputStream {
        private boolean cmd;
        private byte[] tempbuf = new byte[1];

        PDataTFInputStream(boolean cmd) {
            this.cmd = cmd;
        }

        @Override
        public int read() throws IOException {
            this.read(this.tempbuf, 0, 1);
            return this.tempbuf[0];
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException, PduException {
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0 || offset + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = Math.min(DimseReader.this.curavail, len);
            if (n > 0) {
                System.arraycopy(DimseReader.this.curbuf, DimseReader.this.curoffset, buf, offset, n);
                DimseReader.this.curoffset = DimseReader.this.curoffset + n;
                DimseReader.this.curavail = DimseReader.this.curavail - n;
                return n;
            }
            while (DimseReader.this.curavail == 0) {
                if (DimseReader.this.nextPDV(this.cmd)) continue;
                return -1;
            }
            n = Math.min(DimseReader.this.curavail, len);
            if (n > 0) {
                System.arraycopy(DimseReader.this.curbuf, DimseReader.this.curoffset, buf, offset, n);
                DimseReader.this.curoffset = DimseReader.this.curoffset + n;
                DimseReader.this.curavail = DimseReader.this.curavail - n;
                return n;
            }
            throw new IOException("Internal exception when reading from PDV");
        }
    }
}

