/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import java.util.HashMap;
import java.util.Map;

public class DimseUtil {
    public static final int N_EVENT_REPORT_REQUEST = 256;
    public static final int N_EVENT_REPORT_RESPONSE = 33024;
    public static final int N_GET_REQUEST = 272;
    public static final int N_GET_RESPONSE = 33040;
    public static final int N_SET_REQUEST = 288;
    public static final int N_SET_RESPONSE = 33056;
    public static final int N_ACTION_REQUEST = 304;
    public static final int N_ACTION_RESPONSE = 33072;
    public static final int N_CREATE_REQUEST = 320;
    public static final int N_CREATE_RESPONSE = 33088;
    public static final int N_DELETE_REQUEST = 336;
    public static final int N_DELETE_RESPONSE = 33104;
    public static final int C_STORE_REQUEST = 1;
    public static final int C_STORE_RESPONSE = 32769;
    public static final int C_GET_REQUEST = 16;
    public static final int C_GET_RESPONSE = 32784;
    public static final int C_FIND_REQUEST = 32;
    public static final int C_FIND_RESPONSE = 32800;
    public static final int C_MOVE_REQUEST = 33;
    public static final int C_MOVE_RESPONSE = 32801;
    public static final int C_ECHO_REQUEST = 48;
    public static final int C_ECHO_RESPONSE = 32816;
    public static final int C_CANCEL_FIND_REQUEST = 4095;
    public static final int MEDIUM_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    public static final int LOW_PRIORITY = 2;
    private static final Integer DATA = new Integer(0);
    private static final Integer NO_DATA = new Integer(257);
    private static Map<Integer, String> commandNames = new HashMap<Integer, String>();

    private static final void putName(int commandType, String name) {
        commandNames.put(new Integer(commandType), name);
    }

    public static String getCommandName(int commandType) {
        return commandNames.get(new Integer(commandType));
    }

    public static int getCommandType(DicomObject dicomset) throws IllegalValueException {
        Integer type = (Integer)dicomset.get(256);
        if (type == null) {
            throw new IllegalValueException("dicomset is not a DIMSE command");
        }
        return type;
    }

    public static int getMessageID(DicomObject dicomset) throws IllegalValueException {
        Integer id = (Integer)dicomset.get(272);
        if (id == null) {
            throw new IllegalValueException("dicomset does not contain MessageID tag");
        }
        return id;
    }

    public static int getMessageIDBeingRespondedTo(DicomObject dicomset) throws IllegalValueException {
        Integer id = (Integer)dicomset.get(288);
        if (id == null) {
            throw new IllegalValueException("dicomset does not contain MessageIDBeingRespondedTo tag");
        }
        return id;
    }

    public static int getPriority(DicomObject dicomset) throws IllegalValueException {
        Integer p = (Integer)dicomset.get(272);
        if (p == null) {
            throw new IllegalValueException("dicomset does not contain Priority tag");
        }
        return p;
    }

    public static int getAffectedSOPClass(DicomObject dicomset) throws IllegalValueException, UnknownUIDException {
        String s = (String)dicomset.get(2);
        return UID.getUIDEntry(s).getConstant();
    }

    public static String getAffectedSOPInstance(DicomObject dicomset) throws IllegalValueException {
        String s = (String)dicomset.get(4096);
        return s;
    }

    public static int getRequestedSOPClass(DicomObject dicomset) throws IllegalValueException, UnknownUIDException {
        String s = (String)dicomset.get(3);
        return UID.getUIDEntry(s).getConstant();
    }

    public static String getRequestedSOPInstance(DicomObject dicomset) throws IllegalValueException, UnknownUIDException {
        String s = (String)dicomset.get(4097);
        return s;
    }

    public static boolean dataPresent(DicomObject dcm) throws IllegalValueException {
        Integer i = (Integer)dcm.get(2048);
        if (i == null) {
            throw new IllegalValueException("no DataSetType tag in dicomobject");
        }
        return i != 257;
    }

    public static DicomObject createEventReportRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer eventtypeid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(256, new Integer(256));
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(272, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        dicomset.set(4096, sopinstanceuid);
        dicomset.set(4098, eventtypeid);
        return dicomset;
    }

    public static DicomObject createEventReportResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer status, Integer eventtypeid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33024));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        if (eventtypeid != null) {
            dicomset.set(4098, eventtypeid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createNGetRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid, int[] attributelist) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(3, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(272));
        dicomset.set(272, messageid);
        dicomset.set(2048, NO_DATA);
        dicomset.set(4097, sopinstanceuid);
        return dicomset;
    }

    public static DicomObject createNGetResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33040));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createSetRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(3, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(288));
        dicomset.set(272, messageid);
        dicomset.set(2048, DATA);
        dicomset.set(4097, sopinstanceuid);
        return dicomset;
    }

    public static DicomObject createSetResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33056));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createActionRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer actiontypeid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(3, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(304));
        dicomset.set(272, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        dicomset.set(4097, sopinstanceuid);
        dicomset.set(4104, actiontypeid);
        return dicomset;
    }

    public static DicomObject createActionResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer status, Integer actiontypeid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33072));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        if (actiontypeid != null) {
            dicomset.set(4104, actiontypeid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createCreateRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(320));
        dicomset.set(272, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        return dicomset;
    }

    public static DicomObject createCreateResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, boolean datapresent, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33088));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createDeleteRequest(Integer messageid, Integer sopclassuid, String sopinstanceuid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(3, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(336));
        dicomset.set(272, messageid);
        dicomset.set(2048, NO_DATA);
        dicomset.set(4097, sopinstanceuid);
        return dicomset;
    }

    public static DicomObject createDeleteResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(33104));
        dicomset.set(288, messageid);
        dicomset.set(2048, NO_DATA);
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createEchoRequest(Integer messageid, Integer sopclassuid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(48));
        dicomset.set(272, messageid);
        dicomset.set(2048, NO_DATA);
        return dicomset;
    }

    public static DicomObject createEchoResponse(Integer messageid, Integer sopclassuid, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(32816));
        dicomset.set(288, messageid);
        dicomset.set(2048, NO_DATA);
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createMoveRequest(Integer messageid, Integer sopclassuid, Integer priority, String movedestination) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(33));
        dicomset.set(272, messageid);
        dicomset.set(1792, priority);
        dicomset.set(2048, DATA);
        dicomset.set(1536, movedestination);
        return dicomset;
    }

    public static DicomObject createMoveResponse(Integer messageid, Integer sopclassuid, boolean datapresent, Integer status, Integer remaining, Integer completed, Integer failed, Integer warning) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(32801));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        dicomset.set(2304, status);
        if (remaining != null) {
            dicomset.set(4128, remaining);
        }
        if (completed != null) {
            dicomset.set(4129, completed);
        }
        if (failed != null) {
            dicomset.set(4130, failed);
        }
        if (warning != null) {
            dicomset.set(4131, warning);
        }
        return dicomset;
    }

    public static DicomObject createCGetRequest(Integer messageid, Integer sopclassuid, Integer priority) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(16));
        dicomset.set(272, messageid);
        dicomset.set(1792, priority);
        dicomset.set(2048, DATA);
        return dicomset;
    }

    public static DicomObject createCGetResponse(Integer messageid, Integer sopclassuid, boolean datapresent, Integer status, Integer remaining, Integer completed, Integer failed, Integer warning) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(32784));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        dicomset.set(2304, status);
        if (remaining != null) {
            dicomset.set(4128, remaining);
        }
        if (completed != null) {
            dicomset.set(4129, remaining);
        }
        if (failed != null) {
            dicomset.set(4130, remaining);
        }
        if (warning != null) {
            dicomset.set(4131, remaining);
        }
        return dicomset;
    }

    public static DicomObject createStoreRequest(Integer messageid, Integer sopclassuid, Integer priority, String sopinstanceuid, String moveae, String moveid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(1));
        dicomset.set(272, messageid);
        dicomset.set(1792, priority);
        dicomset.set(2048, DATA);
        dicomset.set(4096, sopinstanceuid);
        if (moveae != null) {
            dicomset.set(4144, moveae);
        }
        if (moveid != null) {
            dicomset.set(4145, new Integer(moveid));
        }
        return dicomset;
    }

    public static DicomObject createStoreResponse(Integer messageid, Integer sopclassuid, String sopinstanceuid, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(32769));
        dicomset.set(288, messageid);
        dicomset.set(2048, NO_DATA);
        dicomset.set(2304, status);
        if (sopinstanceuid != null) {
            dicomset.set(4096, sopinstanceuid);
        }
        return dicomset;
    }

    public static DicomObject createFindRequest(Integer messageid, Integer sopclassuid, Integer priority) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        dicomset.set(256, new Integer(32));
        dicomset.set(272, messageid);
        dicomset.set(2048, DATA);
        dicomset.set(1792, priority);
        return dicomset;
    }

    public static DicomObject createFindResponse(Integer messageid, Integer sopclassuid, boolean datapresent, Integer status) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        if (sopclassuid != null) {
            dicomset.set(2, UID.getUIDEntry(sopclassuid).getValue());
        }
        dicomset.set(256, new Integer(32800));
        dicomset.set(288, messageid);
        if (datapresent) {
            dicomset.set(2048, DATA);
        } else {
            dicomset.set(2048, NO_DATA);
        }
        dicomset.set(2304, status);
        return dicomset;
    }

    public static DicomObject createCancelRequest(Integer messageid) throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(256, new Integer(4095));
        dicomset.set(288, messageid);
        dicomset.set(2048, NO_DATA);
        return dicomset;
    }

    static {
        DimseUtil.putName(256, "N-EVENT-REPORT-REQUEST");
        DimseUtil.putName(33024, "N-EVENT-REPORT-RESPONSE");
        DimseUtil.putName(272, "N-GET-REQUEST");
        DimseUtil.putName(33040, "N-GET-RESPONSE");
        DimseUtil.putName(288, "N-SET-REQUEST");
        DimseUtil.putName(33056, "N-SET-RESPONSE");
        DimseUtil.putName(304, "N-ACTION-REQUEST");
        DimseUtil.putName(33072, "N-ACTION-RESPONSE");
        DimseUtil.putName(320, "N-CREATE-REQUEST");
        DimseUtil.putName(33088, "N-CREATE-RESPONSE");
        DimseUtil.putName(336, "N-DELETE-REQUEST");
        DimseUtil.putName(33104, "N-DELETE-RESPONSE");
        DimseUtil.putName(1, "C-STORE-REQUEST");
        DimseUtil.putName(32769, "C-STORE-RESPONSE");
        DimseUtil.putName(16, "C-GET-REQUEST");
        DimseUtil.putName(32784, "C-GET-RESPONSE");
        DimseUtil.putName(32, "C-FIND-REQUEST");
        DimseUtil.putName(32800, "C-FIND-RESPONSE");
        DimseUtil.putName(33, "C-MOVE-REQUEST");
        DimseUtil.putName(32801, "C-MOVE-RESPONSE");
        DimseUtil.putName(48, "C-ECHO-REQUEST");
        DimseUtil.putName(32816, "C-ECHO-RESPONSE");
        DimseUtil.putName(4095, "C-CANCEL-FIND-REQUEST");
    }
}

