/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ULServiceMessage;

public class Reject
extends Response
implements ULServiceMessage {
    public static final int REJECTED_PERMANENT = 1;
    public static final int REJECTED_TRANSIENT = 2;
    public static final int DICOM_UL_SERVICE_USER = 1;
    public static final int DICOM_UL_SERVICE_PROVIDER_ACSE = 2;
    public static final int DICOM_UL_SERVICE_PROVIDER_PRESENTATION = 3;
    public static final int USER_NO_REASON_GIVEN = 1;
    public static final int USER_APPLICATIONCONTEXTNAME_NOT_SUPPORTED = 2;
    public static final int USER_CALLING_AETITLE_NOT_RECOGNIZED = 3;
    public static final int USER_CALLED_AETITLE_NOT_RECOGNIZED = 7;
    public static final int ACSE_NO_REASON_GIVEN = 1;
    public static final int ACSE_PROTOCOL_NOT_SUPPORTED = 2;
    public static final int PRESENTATION_TEMPORARY_CONGESTION = 1;
    public static final int PRESENTATION_LOCAL_LIMIT_EXCEEDED = 2;
    private int result;
    private int source;
    private int reason;

    public Reject(int result, int source, int reason) {
        this.result = result;
        this.source = source;
        this.reason = reason;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public int getMessageType() {
        return 1003;
    }

    @Override
    public String getMessageTypeName() {
        return "A-ASSOCIATE-RJ";
    }

    public int getResult() {
        return this.result;
    }

    public String getResultDescription() {
        switch (this.result) {
            case 2: {
                return "REJECTED_TRANSIENT";
            }
            case 1: {
                return "REJECTED_PERMANENT";
            }
        }
        return String.format("Illegal result value (%s) for Reject", this.result);
    }

    public int getSource() {
        return this.source;
    }

    public String getSourceDescription() {
        switch (this.source) {
            case 1: {
                return "DICOM_UL_SERVICE_USER";
            }
            case 2: {
                return "DICOM_UL_SERVICE_PROVIDER_ACSE";
            }
            case 3: {
                return "DICOM_UL_SERVICE_PROVIDER_PRESENTATION";
            }
        }
        return String.format("Illegal source value (%s) for Reject", this.source);
    }

    public int getReason() {
        return this.reason;
    }

    public String getReasonDescription() {
        if (this.source == 1) {
            switch (this.reason) {
                case 1: {
                    return "USER_NO_REASON_GIVEN";
                }
                case 7: {
                    return "USER_CALLED_AETITLE_NOT_RECOGNIZED";
                }
                case 3: {
                    return "USER_CALLING_AETITLE_NOT_RECOGNIZED";
                }
                case 2: {
                    return "USER_APPLICATIONCONTEXTNAME_NOT_SUPPORTED";
                }
            }
            return String.format("Illegal reason value (%s) for source value (%s) for Reject", this.reason, this.source);
        }
        if (this.source == 2) {
            switch (this.reason) {
                case 1: {
                    return "ACSE_NO_REASON_GIVEN";
                }
                case 2: {
                    return "ACSE_PROTOCOL_NOT_SUPPORTED";
                }
            }
            return String.format("Illegal reason value (%s) for source value (%s) for Reject", this.reason, this.source);
        }
        if (this.source == 3) {
            switch (this.reason) {
                case 2: {
                    return "PRESENTATION_LOCAL_LIMIT_EXCEEDED";
                }
                case 1: {
                    return "PRESENTATION_TEMPORARY_CONGESTION";
                }
            }
            return String.format("Illegal reason value (%s) for source value (%s) for Reject", this.reason, this.source);
        }
        return String.format("Illegal source value (%s) for Reject", this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[reject - result: ");
        sb.append(this.getResultDescription());
        sb.append(" source: ");
        sb.append(this.getSourceDescription());
        sb.append(" reason: ");
        sb.append(this.getReasonDescription());
        sb.append("]");
        return sb.toString();
    }
}

