/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.network.ExtendedNegotiation;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PresentationContext;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.network.UserIdentityNegotiationRequest;
import com.archimed.log.JdtLogger;
import com.archimed.tool.StringTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
implements Pdu,
ULServiceMessage {
    public static final int NO_SUPPORT_SCU_ROLE = 0;
    public static final int SUPPORT_SCU_ROLE = 1;
    public static final int NO_SUPPORT_SCP_ROLE = 0;
    public static final int SUPPORT_SCP_ROLE = 1;
    public static final int DEFAULT = -1;
    private String calledtitle;
    private String callingtitle;
    private List<PresentationContext> pcContexts;
    private Map<Integer, PresentationContext> pcContextsMap;
    private String implclassuid;
    private String implversionname;
    private List<byte[]> extnegdata;
    private int maxpdusize;
    private int maxopinvoked = 1;
    private int maxopperformed = 1;
    private List<UIDEntry> asroles;
    private List<Integer> scuroles;
    private List<Integer> scproles;
    private ExtendedNegotiation[] extendedNegotiations;
    private UserIdentityNegotiationRequest userIdentityNegotiationRequest;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Request.class);

    public Request() {
        this.pcContexts = new ArrayList<PresentationContext>();
        this.pcContextsMap = new HashMap<Integer, PresentationContext>();
        this.extnegdata = new ArrayList<byte[]>();
        this.asroles = new ArrayList<UIDEntry>();
        this.scuroles = new ArrayList<Integer>();
        this.scproles = new ArrayList<Integer>();
        this.setImplementationClassUID(Jdt.getImplementationClassUID());
        this.setImplementationVersionName(Jdt.getImplementationVersionName());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getMessageType() {
        return 1001;
    }

    @Override
    public String getMessageTypeName() {
        return "A-ASSOCIATE-RQ";
    }

    public String getCallingTitle() {
        return this.callingtitle;
    }

    public String getCalledTitle() {
        return this.calledtitle;
    }

    public void setCalledTitle(String calledtitle) {
        this.calledtitle = calledtitle;
    }

    public void setCallingTitle(String callingtitle) {
        this.callingtitle = callingtitle;
    }

    public String getImplementationClassUID() {
        return this.implclassuid;
    }

    public String getImplementationVersionName() {
        return this.implversionname;
    }

    public void setImplementationClassUID(String s) {
        this.implclassuid = s;
    }

    public void setImplementationVersionName(String s) {
        this.implversionname = s;
    }

    public int getMaxPduSize() {
        return this.maxpdusize;
    }

    public void setMaxPduSize(int maxpdusize) {
        this.maxpdusize = maxpdusize;
    }

    public void setMaxOperationsInvoked(int n) {
        this.maxopinvoked = n;
    }

    public int getMaxOperationsInvoked() {
        return this.maxopinvoked;
    }

    public void setMaxOperationsPerformed(int n) {
        this.maxopperformed = n;
    }

    public int getMaxOperationsPerformed() {
        return this.maxopperformed;
    }

    public int getScuRole(int asid) throws IllegalValueException {
        int index = this.asroles.indexOf(UID.getUIDEntry(asid));
        if (index == -1) {
            return -1;
        }
        return this.scuroles.get(index);
    }

    UIDEntry getAbstractSyntaxForRole(int index) {
        return this.asroles.get(index);
    }

    int getRoles() {
        return this.asroles.size();
    }

    public int getScpRole(int asid) throws IllegalValueException {
        int index = this.asroles.indexOf(UID.getUIDEntry(asid));
        if (index == -1) {
            return -1;
        }
        return this.scproles.get(index);
    }

    public PresentationContext getPresentationContext(int index) {
        return this.pcContexts.get(index);
    }

    public PresentationContext findPresentationContext(int pcid) {
        return this.pcContextsMap.get(pcid);
    }

    public byte getPresentationContextID(int i) {
        return (byte)this.getPresentationContext(i).getID();
    }

    public int getID(int i) {
        return this.getPresentationContext(i).getID();
    }

    public int getPresentationContexts() {
        return this.pcContexts.size();
    }

    public UIDEntry getAbstractSyntax(int i) {
        return this.getPresentationContext(i).getAbstractSyntax();
    }

    public int getTransferSyntaxes(int i) {
        return this.getPresentationContext(i).getProposedTS().size();
    }

    public UIDEntry getTransferSyntax(int i, int j) {
        return (UIDEntry)this.getPresentationContext(i).getProposedTS().get(j);
    }

    public byte[] getExtendedNegotiationData(int i) {
        return this.extnegdata.get(i);
    }

    public ExtendedNegotiation[] getExtendedNegotiations() {
        return this.extendedNegotiations;
    }

    public void setExtendedNegotiations(ExtendedNegotiation[] extendedNegotiations) {
        if (extendedNegotiations != null) {
            this.extendedNegotiations = extendedNegotiations;
        }
    }

    public void addPresentationContext(int asid, int[] tsids) throws IllegalValueException {
        this.addPresentationContext(2 * this.pcContexts.size() + 1, asid, tsids);
    }

    public void addPresentationContext(int id, int asid, int[] tsids) throws IllegalValueException {
        UIDEntry asentry = UID.getUIDEntry(asid);
        UIDEntry[] tsentries = new UIDEntry[tsids.length];
        for (int i = 0; i < tsids.length; ++i) {
            tsentries[i] = UID.getUIDEntry(tsids[i]);
        }
        this.addPresentationContext(id, asentry, tsentries);
    }

    public void addPresentationContext(int id, UIDEntry asentry, UIDEntry[] tsentries) {
        PresentationContext pcContext = new PresentationContext(id, asentry, new ArrayList<UIDEntry>(Arrays.asList(tsentries)));
        this.pcContexts.add(pcContext);
        this.pcContextsMap.put(pcContext.getID(), pcContext);
        this.extnegdata.add(null);
    }

    public void setExtendedNegotiationData(int index, byte[] data) {
        this.extnegdata.set(index, data);
    }

    public void setScuScpRoleSelection(int asid, int scurole, int scprole) throws IllegalValueException {
        UIDEntry asentry = UID.getUIDEntry(asid);
        int index = this.asroles.indexOf(asentry);
        if (index != -1) {
            this.scuroles.set(index, scurole);
            this.scproles.set(index, scprole);
        } else {
            this.asroles.add(asentry);
            this.scuroles.add(scurole);
            this.scproles.add(scprole);
        }
    }

    public UserIdentityNegotiationRequest getUserIdentityNegotiationRequest() {
        return this.userIdentityNegotiationRequest;
    }

    public void setUserIdentityNegotiationRequest(UserIdentityNegotiationRequest userIdentityNegotiationRequest) {
        this.userIdentityNegotiationRequest = userIdentityNegotiationRequest;
    }

    public String toString() {
        String t;
        int w = 30;
        StringBuilder sb = new StringBuilder();
        sb.append("-------------------- " + this.getMessageTypeName() + " --------------------\n").append(StringTool.fstr("called title:", w) + this.calledtitle + "\n").append(StringTool.fstr("calling title:", w) + this.callingtitle + "\n").append(StringTool.fstr("implementation class UID:", w) + this.implclassuid + "\n").append(StringTool.fstr("implementation version name:", w) + this.implversionname + "\n");
        if (this.userIdentityNegotiationRequest != null) {
            sb.append("User Identity Negotiation\n").append(StringTool.fstr("  user identity type:", w) + this.userIdentityNegotiationRequest.getUserIdentityType() + " (" + this.userIdentityNegotiationRequest.getUserIdentityTypeString() + ")\n").append(StringTool.fstr("  pos. response requested:", w) + (this.userIdentityNegotiationRequest.isPositiveResponseRequested() ? "1" : "0") + "\n");
        }
        sb.append(StringTool.fstr("max PDU size:", w) + this.maxpdusize + "\n").append(StringTool.fstr("max operations invoked:", w) + this.maxopinvoked + "\n").append(StringTool.fstr("max operations performed:", w) + this.maxopperformed + "\n").append(StringTool.fstr("# presentation contexts:", w) + this.pcContexts.size() + "\n");
        sb.append("proposed abstract syntaxes:\n");
        for (int i = 0; i < this.getPresentationContexts(); ++i) {
            sb.append(this.getID(i) + "/" + this.getAbstractSyntax(i).getValue() + "/" + this.getAbstractSyntax(i).getName() + "\n");
            t = "";
            sb.append("          " + StringTool.fstr("proposed transfer syntax", 32) + "description\n");
            for (int j = 0; j < this.getTransferSyntaxes(i); ++j) {
                sb.append("          " + StringTool.fstr(this.getTransferSyntax(i, j).getValue(), 32) + this.getTransferSyntax(i, j).getName() + "\n");
            }
        }
        sb.append("non-default roles set:\n");
        boolean b = false;
        try {
            for (int i = 0; i < this.getRoles(); ++i) {
                UIDEntry as = this.getAbstractSyntaxForRole(i);
                if (this.getScpRole(as.getConstant()) == -1 && this.getScuRole(as.getConstant()) == -1) continue;
                b = true;
                sb.append(StringTool.fstr(as.getName() + "", 65) + " ");
                t = "";
                if (this.getScuRole(as.getConstant()) == 1) {
                    t = "SCU";
                } else if (this.getScuRole(as.getConstant()) == 0) {
                    t = "NO-SCU";
                } else if (this.getScuRole(as.getConstant()) == -1) {
                    t = "DEFAULT";
                }
                t = t + "/";
                if (this.getScpRole(as.getConstant()) == 1) {
                    t = t + "SCP";
                } else if (this.getScpRole(as.getConstant()) == 0) {
                    t = t + "NO-SCP";
                } else if (this.getScpRole(as.getConstant()) == -1) {
                    t = t + "DEFAULT";
                }
                sb.append(StringTool.fstr(t, 30) + "\n");
            }
            if (!b) {
                sb.append("none\n");
            }
        }
        catch (IllegalValueException ex) {
            this.log.error("", ex);
        }
        sb.append("--------------------------------------------------------");
        return sb.toString();
    }
}

