/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class TransferSyntaxItem {
    private byte itemtype = (byte)64;
    private UIDEntry transfersyntax;

    public TransferSyntaxItem() {
    }

    public TransferSyntaxItem(UIDEntry entry) {
        this.transfersyntax = entry;
    }

    public UIDEntry getTransferSyntax() {
        return this.transfersyntax;
    }

    public int getLength() {
        return this.transfersyntax.getValue().length() + 4;
    }

    void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.transfersyntax.getValue().length());
        out.write(this.transfersyntax.getValue().getBytes());
    }

    int read(DataInputStream in) throws IOException, IllegalValueException {
        int b = in.read();
        if (b != 64) {
            throw new IllegalValueException("itemtype field of received Transfer Syntax Item not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        buf = StringTool.trimZeros(buf);
        String uid = new String(buf);
        try {
            this.transfersyntax = UID.getUIDEntry(uid);
        }
        catch (UnknownUIDException e) {
            this.transfersyntax = new UIDEntry(0, uid, "unknown uid", "??", 3);
        }
        return 4 + length;
    }
}

