/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.SubItem;
import com.archimed.dicom.network.UserIdentityNegotiationRequest;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class UserIdentityNegotiationRequestSubItem
extends SubItem {
    int itemtype = 88;
    private UserIdentityNegotiationRequest userIdentityNegotiationRequest;

    public UserIdentityNegotiationRequestSubItem() {
    }

    public UserIdentityNegotiationRequestSubItem(UserIdentityNegotiationRequest userIdentityNegotiationRequest) {
        this.userIdentityNegotiationRequest = userIdentityNegotiationRequest;
    }

    @Override
    public int getLength() {
        return 8 + this.userIdentityNegotiationRequest.getUserIdentity().length + (this.userIdentityNegotiationRequest.getUserIdentityType() == 2 ? 2 + this.userIdentityNegotiationRequest.getPassCode().length : 0);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.getLength() - 4);
        out.write(this.userIdentityNegotiationRequest.getUserIdentityType());
        out.write(this.userIdentityNegotiationRequest.isPositiveResponseRequested() ? 1 : 0);
        out.writeChar(this.userIdentityNegotiationRequest.getUserIdentity().length);
        out.write(this.userIdentityNegotiationRequest.getUserIdentity());
        if (this.userIdentityNegotiationRequest.getUserIdentityType() == 2) {
            out.writeChar(this.userIdentityNegotiationRequest.getPassCode().length);
            out.write(this.userIdentityNegotiationRequest.getPassCode());
        }
    }

    @Override
    public int read(DataInputStream in) throws IOException, IllegalValueException, UnknownUIDException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received UserIdentityNegotiationRequestSubItem  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        DataInputStream rest = new DataInputStream(new ByteArrayInputStream(buf));
        int userIdentityType = rest.read();
        boolean positiveResponseRequested = rest.read() == 1;
        char primaryFieldLen = rest.readChar();
        byte[] userIdentity = new byte[primaryFieldLen];
        rest.readFully(userIdentity);
        byte[] passCode = null;
        if (rest.available() > 0) {
            char secondaryFieldLen = rest.readChar();
            passCode = new byte[secondaryFieldLen];
            rest.readFully(passCode);
        }
        this.userIdentityNegotiationRequest = new UserIdentityNegotiationRequest(userIdentityType, positiveResponseRequested, userIdentity, passCode);
        return length + 4;
    }

    public UserIdentityNegotiationRequest getUserIdentityNegotiationRequest() {
        return this.userIdentityNegotiationRequest;
    }
}

