/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.AsynchronousOperationsWindowSubItem;
import com.archimed.dicom.network.ExtendedNegotiationSubItem;
import com.archimed.dicom.network.ImplementationClassUIDSubItem;
import com.archimed.dicom.network.ImplementationVersionNameSubItem;
import com.archimed.dicom.network.MaximumLengthSubItem;
import com.archimed.dicom.network.ScuScpRoleSubItem;
import com.archimed.dicom.network.SubItem;
import com.archimed.dicom.network.UserIdentityNegotiationRequestSubItem;
import com.archimed.dicom.network.UserIdentityNegotiationResponseSubItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;

class UserInfoItem {
    private int itemtype = 80;
    private List<SubItem> subitems = new ArrayList<SubItem>();
    private int unknownsubslength = 0;
    private boolean request;

    public UserInfoItem(boolean request) {
        this.request = request;
    }

    void addSubItem(SubItem subitem) {
        this.subitems.add(subitem);
    }

    List<SubItem> getSubItems() {
        return this.subitems;
    }

    public int getLength() {
        int length = 4;
        for (int i = 0; i < this.subitems.size(); ++i) {
            length += this.subitems.get(i).getLength();
        }
        return length += this.unknownsubslength;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.getLength() - 4);
        for (int i = 0; i < this.subitems.size(); ++i) {
            this.subitems.get(i).write(out);
        }
    }

    public int read(PushbackInputStream pbin) throws IOException, IllegalValueException, UnknownUIDException {
        int length;
        DataInputStream din = new DataInputStream(pbin);
        int b = din.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received User Info Item  not " + this.itemtype);
        }
        din.read();
        int length2 = length = din.readChar();
        while (length > 0) {
            int r;
            b = din.read();
            pbin.unread(b);
            if (b == 81) {
                MaximumLengthSubItem mlitem = new MaximumLengthSubItem();
                r = mlitem.read(din);
                this.addSubItem(mlitem);
                length -= r;
                continue;
            }
            if (b == 82) {
                ImplementationClassUIDSubItem icitem = new ImplementationClassUIDSubItem();
                r = icitem.read(din);
                this.addSubItem(icitem);
                length -= r;
                continue;
            }
            if (b == 83) {
                AsynchronousOperationsWindowSubItem aoitem = new AsynchronousOperationsWindowSubItem();
                r = aoitem.read(din);
                this.addSubItem(aoitem);
                length -= r;
                continue;
            }
            if (b == 84) {
                ScuScpRoleSubItem ssitem = new ScuScpRoleSubItem();
                r = ssitem.read(din);
                this.addSubItem(ssitem);
                length -= r;
                continue;
            }
            if (b == 85) {
                ImplementationVersionNameSubItem ivitem = new ImplementationVersionNameSubItem();
                r = ivitem.read(din);
                this.addSubItem(ivitem);
                length -= r;
                continue;
            }
            if (b == 86) {
                ExtendedNegotiationSubItem extnegitem = new ExtendedNegotiationSubItem();
                r = extnegitem.read(din);
                this.addSubItem(extnegitem);
                length -= r;
                continue;
            }
            if (b == 88) {
                SubItem subItem = this.request ? new UserIdentityNegotiationRequestSubItem() : new UserIdentityNegotiationResponseSubItem();
                r = subItem.read(din);
                this.addSubItem(subItem);
                length -= r;
                continue;
            }
            din.read();
            din.read();
            char l = din.readChar();
            din.read();
            length = length - l - 4;
            this.unknownsubslength += l + 4;
        }
        return 4 + length2;
    }
}

