/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.log.JdtLogger;
import java.io.IOException;

public class CStoreSCU {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CStoreSCU.class);
    private AssociationIO associationIO;
    private SOPClassUID sopClassUID;
    private int presentationContextID;
    private boolean canceled = false;

    public CStoreSCU(AssociationIO associationIO, int presentationContextID, SOPClassUID sopClassUID) {
        this.associationIO = associationIO;
        this.presentationContextID = presentationContextID;
        this.sopClassUID = sopClassUID;
    }

    public AssociationIO getAssociationIO() {
        return this.associationIO;
    }

    public Command cstore(DicomObject dataset, int priority) throws SCUException, DicomException, IOException {
        int messageID = SCUFactory.getMessageID();
        String sopInstanceUID = dataset.getString(524312, 0);
        Command storereq = Command.createCStoreReq(messageID, this.sopClassUID.getConstant(), priority, sopInstanceUID);
        if (this.log.isDebugEnabled()) {
            DumpUtils dmpUtils = new DumpUtils(true, false);
            StringBuffer sb = new StringBuffer();
            dmpUtils.dump((DicomObject)storereq, sb);
            this.log.debug("");
            this.log.debug("DUMP C-STORE REQUEST:");
            this.log.debug("\r\n" + sb.toString());
        }
        Dimse dimse = new Dimse(this.presentationContextID, storereq, dataset);
        this.associationIO.write(dimse);
        ULServiceMessage ulServiceMessage = this.associationIO.read();
        switch (ulServiceMessage.getMessageType()) {
            case 1004: {
                Dimse resDimse = (Dimse)ulServiceMessage;
                if (this.log.isDebugEnabled()) {
                    DumpUtils dmpUtils = new DumpUtils(true, false);
                    StringBuffer sb = new StringBuffer();
                    dmpUtils.dump((DicomObject)resDimse.getCommand(), sb);
                    this.log.debug("");
                    this.log.debug("DUMP C-STORE RESPONSE:");
                    this.log.debug("\r\n" + sb.toString());
                }
                return resDimse.getCommand();
            }
            case 1007: {
                this.log.error("abort received when expecting dimse: " + ulServiceMessage);
                throw new SCUException("abort received when expecting dimse: " + ulServiceMessage);
            }
        }
        this.log.error("unexpected pdu received when expecting dimse: " + ulServiceMessage);
        throw new SCUException("unexpected pdu received when expecting dimse: " + ulServiceMessage);
    }
}

