/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Offsets;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.scu.AbstractCStoreItemRequest;
import com.archimed.dicom.scu.CStoreItemRequest;
import java.io.IOException;

public class DatasetCStoreItemRequest
extends AbstractCStoreItemRequest {
    private DicomObject dicomObject;
    private long size_ = -2L;
    private boolean initialized = false;

    public DatasetCStoreItemRequest(DicomObject dicomObject) {
        super(null, null, null, null);
        this.dicomObject = dicomObject;
    }

    public DicomObject getDataset() {
        return this.dicomObject;
    }

    @Override
    public long getSize() {
        if (this.size_ == -2L) {
            try {
                this.size_ = new Offsets(this.dicomObject).calculateSize(true, TransferSyntax.getUIDEntry(this.getTranferSyntax()).getConstant(), true);
            }
            catch (Exception ex) {
                this.size_ = -1L;
            }
        }
        return this.size_;
    }

    @Override
    public DicomObject readDicomObject() throws DicomException, IOException {
        return this.dicomObject;
    }

    private void checkInitialized() {
        if (this.initialized) {
            return;
        }
        try {
            DicomObject fileMetaInfo = this.dicomObject.getFileMetaInformation();
            if (fileMetaInfo == null) {
                throw new DicomException("not a dicom part 10 file");
            }
            if (fileMetaInfo.getSize(131088) <= 0) {
                throw new DicomException("Transfer Syntax missing in file meta information");
            }
            this.transferSyntax = fileMetaInfo.getString(131088, 0);
            if (fileMetaInfo.getSize(131088) <= 0) {
                throw new DicomException("SOP Class UID missing in file meta information");
            }
            this.sopClass = fileMetaInfo.getString(131074, 0);
            if (fileMetaInfo.getSize(131075) <= 0) {
                throw new DicomException("SOP Instance UID missing in file meta information");
            }
            this.sopInstanceUID = fileMetaInfo.getString(131075, 0);
            this.name = this.sopInstanceUID;
        }
        catch (DicomException e) {
            this.setStatus(EXCEPTION);
            this.setThrowable(e);
        }
        finally {
            this.initialized = true;
        }
    }

    @Override
    public String getName() {
        this.checkInitialized();
        return super.getName();
    }

    @Override
    public String getSopClass() {
        this.checkInitialized();
        return super.getSopClass();
    }

    @Override
    public String getSopInstanceUID() {
        this.checkInitialized();
        return super.getSopInstanceUID();
    }

    @Override
    public CStoreItemRequest.Status getStatus() {
        this.checkInitialized();
        return super.getStatus();
    }

    @Override
    public Throwable getThrowable() {
        this.checkInitialized();
        return super.getThrowable();
    }

    public String getTranferSyntax() {
        this.checkInitialized();
        return super.getTransferSyntax();
    }
}

