/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.scu.AbstractCStoreItemRequest;
import com.archimed.dicom.scu.CStoreItemRequest;
import com.archimed.dicom.scu.DeferredCStoreItemRequest;
import java.io.IOException;
import java.io.InputStream;

public class StreamedFileCStoreItemRequest
extends AbstractCStoreItemRequest
implements DeferredCStoreItemRequest {
    private InputStream inputStream;
    private long size = -1L;
    private volatile boolean _initialized = false;

    public StreamedFileCStoreItemRequest(InputStream inputStream) {
        super(null, null, null, inputStream + "");
        this.inputStream = inputStream;
    }

    @Override
    public DicomObject readDicomObject() throws DicomException, IOException {
        throw new UnsupportedOperationException("Implementations of DeferredCStoreItemRequest do not support readDicomObject");
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public CStoreItemRequest.Status getStatus() {
        this.checkInitialized();
        return super.getStatus();
    }

    @Override
    public String getSopClass() {
        this.checkInitialized();
        return super.getSopClass();
    }

    @Override
    public String getSopInstanceUID() {
        this.checkInitialized();
        return super.getSopInstanceUID();
    }

    @Override
    public String getTransferSyntax() {
        this.checkInitialized();
        return super.getTransferSyntax();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    private void checkInitialized() {
        block11: {
            if (this._initialized) {
                return;
            }
            try {
                byte[] preamble = DicomReader.readPreamble(this.inputStream);
                DicomObject filemetainfo = DicomReader.readFileMetaInformation(this.inputStream);
                if (filemetainfo.getSize(131088) <= 0) {
                    throw new DicomException("Transfer Syntax missing in file meta information");
                }
                this.transferSyntax = filemetainfo.getString(131088, 0);
                if (filemetainfo.getSize(131088) <= 0) {
                    throw new DicomException("SOP Class UID missing in file meta information");
                }
                this.sopClass = filemetainfo.getString(131074, 0);
                if (filemetainfo.getSize(131075) > 0) {
                    this.sopInstanceUID = filemetainfo.getString(131075, 0);
                    break block11;
                }
                throw new DicomException("SOP Instance UID missing in file meta information");
            }
            catch (DicomException ex) {
                this.setThrowable(ex);
                this.setStatus(NODICOM);
            }
            catch (IOException ex) {
                this.setThrowable(ex);
                this.setStatus(EXCEPTION);
            }
            finally {
                this._initialized = true;
            }
        }
    }
}

