/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.xml;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.dicom.xml.Dicom2XmlException;
import com.archimed.log.JdtLogger;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Dicom2FlatXmlConverter {
    private static transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DumpUtils.class);

    public void write(DicomObject dicomObject, OutputStream out) throws Dicom2XmlException, DicomException {
        DicomObject meta = dicomObject.getFileMetaInformation();
        if (meta == null) {
            throw new Dicom2XmlException("No file meta information");
        }
        this.write(dicomObject, out, true);
    }

    public void write(DicomObject dicomObject, OutputStream out, boolean writeFileMeta) throws Dicom2XmlException, DicomException {
        this.write(dicomObject, out, writeFileMeta, false);
    }

    public void write(DicomObject dicomObject, OutputStream out, boolean writeFileMeta, boolean grouplengths) throws Dicom2XmlException, DicomException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new Dicom2XmlException("ParserConfigurationException: " + ex, ex);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document doc = impl.createDocument("http://www.trispark.com/jdt/dicom2flatxml", "dicomfile", null);
        doc.getDocumentElement().setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.getDocumentElement().setAttribute("xsi:schemaLocation", "http://www.trispark.com/jdt/dicom2flatxml dicom2flatxml.xsd");
        DicomObject meta = dicomObject.getFileMetaInformation();
        if (meta != null && writeFileMeta) {
            Element filemeta = doc.createElement("filemeta");
            doc.getDocumentElement().appendChild(filemeta);
            this.processDicomObject(meta, doc, filemeta, "", "", true);
        }
        Element dataset = doc.createElement("dataset");
        doc.getDocumentElement().appendChild(dataset);
        this.processDicomObject(dicomObject, doc, dataset, "", "", grouplengths);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer idTransform = null;
        try {
            idTransform = xformFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new Dicom2XmlException("TransformerConfigurationException: " + ex, ex);
        }
        DOMSource input = new DOMSource(doc);
        StreamResult output = new StreamResult(out);
        try {
            idTransform.transform(input, output);
        }
        catch (TransformerException ex) {
            throw new Dicom2XmlException("TransformerException: " + ex, ex);
        }
    }

    private void processDicomObject(DicomObject dicomObject, Document doc, Element el, String groupPrefix, String card, boolean grouplengths) throws DicomException {
        Enumeration e = dicomObject.enumerateVRs(grouplengths);
        String group = "";
        String prevGroup = null;
        Element groupElement = null;
        while (e.hasMoreElements()) {
            DataElement dcmDataElement = (DataElement)e.nextElement();
            group = !groupPrefix.equals("") ? groupPrefix + "." + DumpUtils.toHexString(dcmDataElement.getGroup(), 4) : DumpUtils.toHexString(dcmDataElement.getGroup(), 4);
            if (prevGroup == null || !prevGroup.equals(group)) {
                groupElement = doc.createElement("dicom-group");
                groupElement.setAttribute("group", group);
                if (!card.equals("")) {
                    groupElement.setAttribute("card", card);
                }
                el.appendChild(groupElement);
            }
            this.processDicomDataElement(dcmDataElement, doc, groupElement, groupPrefix, card, grouplengths);
            prevGroup = group;
        }
    }

    private void processDicomDataElement(DataElement dcmDataElement, Document doc, Element el, String groupPrefix, String card_, boolean grouplengths) throws DicomException {
        String elementAttribute = DumpUtils.toHexString(dcmDataElement.getElement(), 4);
        Element el2 = doc.createElement("dicom-element");
        el2.setAttribute("element", elementAttribute);
        el2.setAttribute("vr", DDict.getTypeName(dcmDataElement.getVR()));
        el2.setAttribute("name", DDict.getDescription(dcmDataElement.getTag()));
        el2.setAttribute("vm", dcmDataElement.size() + "");
        el.appendChild(el2);
        if (dcmDataElement.getVR() != 10) {
            this.processDicomDataElementValues(dcmDataElement, doc, el2);
        } else {
            StringBuffer gBuffer = new StringBuffer();
            if (!groupPrefix.equals("")) {
                gBuffer.append(groupPrefix);
                gBuffer.append(".");
            }
            gBuffer.append(DumpUtils.toHexString(dcmDataElement.getGroup(), 4));
            gBuffer.append(".");
            gBuffer.append(DumpUtils.toHexString(dcmDataElement.getElement(), 4));
            String newGroupPrefix = gBuffer.toString();
            for (int i = 0; i < dcmDataElement.size(); ++i) {
                int card = i + 1;
                DicomObject item = dcmDataElement.getSequenceItem(i);
                this.processDicomObject(item, doc, (Element)el.getParentNode(), newGroupPrefix, card + "", grouplengths);
            }
        }
    }

    private void processDicomDataElementValues(DataElement dcmDataElement, Document doc, Element el) throws DicomException {
        for (int i = 0; i < dcmDataElement.size(); ++i) {
            Text text;
            int card = i + 1;
            Element el2 = doc.createElement("dicom-element-value");
            el2.setAttribute("card", "" + card);
            try {
                text = doc.createTextNode(dcmDataElement.getString(i));
            }
            catch (DicomCharsetException ex) {
                log.warn(String.format("Unable to get String representation for data element %s", DumpUtils.tagString(dcmDataElement.getGroup(), dcmDataElement.getElement())), ex);
                text = doc.createTextNode("<ERROR! DicomCharsetException (warning logged)>");
            }
            el2.appendChild(text);
            el.appendChild(el2);
        }
    }
}

