/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.xml;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SequenceItemReadEvent;
import com.archimed.dicom.SequenceItemReadListener;
import com.archimed.dicom.TagRead2Listener;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import shadow.org.apache.commons.text.StringEscapeUtils;

class Dicom2XmlStreamWriter {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";
    private static final String DOCUMENT_ROOT_START = "<dicomfile xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.trispark.com/jdt/dicom2xml dicom2xml.xsd\" xmlns=\"http://www.trispark.com/jdt/dicom2xml\">";
    private static final String DOCUMENT_ROOT_END = "</dicomfile>";
    private static final transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Dicom2XmlStreamWriter.class);
    private final boolean writeFileMeta;
    private final boolean grouplengths;
    private final int indentsize;
    private final int maxvalue;
    private PrintWriter printWriter;
    private int activeGroup = 0;
    private int level = 0;

    static void write(InputStream in, OutputStream out, boolean writeFileMeta, boolean grouplengths, int indentsize, int maxvalue) throws IOException, DicomException {
        Dicom2XmlStreamWriter dicom2XmlStreamWriter = new Dicom2XmlStreamWriter(writeFileMeta, grouplengths, indentsize, maxvalue);
        dicom2XmlStreamWriter.write(in, out);
    }

    private Dicom2XmlStreamWriter(boolean writeFileMeta, boolean grouplengths, int indentsize, int maxvalue) {
        this.writeFileMeta = writeFileMeta;
        this.grouplengths = grouplengths;
        this.indentsize = indentsize;
        this.maxvalue = maxvalue;
    }

    private void write(InputStream in, OutputStream out) throws IOException, DicomException {
        DumpTagListener dumpTagListener = new DumpTagListener(out, this.writeFileMeta, this.grouplengths);
        DicomReader dicomReader = new DicomReader();
        dicomReader.addTagReadListener(dumpTagListener);
        dicomReader.addSequenceItemReadListener(dumpTagListener);
        this.printWriter = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.writeDocumentRootStart();
        dicomReader.read(in, true);
        this.writeGroupEnd();
        this.writeDatasetEnd();
        this.writeDocumentRootEnd();
        this.printWriter.close();
    }

    private void print(StringBuilder sb) {
        this.print(sb.toString());
    }

    private void print(String s) {
        if (this.indentsize > 0) {
            for (int i = 0; i < this.indentsize * this.level; ++i) {
                this.printWriter.print(" ");
            }
            this.printWriter.println(s);
        } else {
            this.printWriter.print(s);
        }
    }

    private void writeDocumentRootStart() {
        this.print(XML_DECLARATION);
        this.print(DOCUMENT_ROOT_START);
        ++this.level;
    }

    private void writeDocumentRootEnd() {
        --this.level;
        this.print(DOCUMENT_ROOT_END);
    }

    private void writeFileMetaStart() {
        this.print("<filemeta>");
        ++this.level;
    }

    private void writeFileMetaEnd() {
        --this.level;
        this.print("</filemeta>");
    }

    private void writeDatasetStart() {
        this.print("<dataset>");
        ++this.level;
    }

    private void writeDatasetEnd() {
        --this.level;
        this.print("</dataset>");
    }

    private void writeGroupStart(int group) {
        StringBuilder sb = new StringBuilder("<dicom-group group=\"");
        sb.append(DumpUtils.toShortHexString(group));
        sb.append("\">");
        this.print(sb);
        ++this.level;
    }

    private void writeGroupEnd() {
        if (this.activeGroup > 0) {
            --this.level;
            this.print("</dicom-group>");
        }
        this.activeGroup = 0;
    }

    private void writeSequenceItemStart(int itemIndex) {
        StringBuilder sb = new StringBuilder("<dicom-sequence-item card=\"");
        sb.append(itemIndex);
        sb.append("\">");
        this.print(sb);
        ++this.level;
        this.activeGroup = 0;
    }

    private void writeSequenceItemEnd() {
        --this.level;
        this.print("</dicom-sequence-item>");
    }

    private void writeDataElementValues(TagReadEvent e) {
        DataElement dcmDataElement = e.getDataElement();
        for (int i = 0; i < dcmDataElement.size(); ++i) {
            String text;
            int card = i + 1;
            StringBuilder sb = new StringBuilder("<dicom-element-value card=\"");
            sb.append(card);
            sb.append("\">");
            try {
                text = dcmDataElement.getString(i);
            }
            catch (Exception ex) {
                text = ex instanceof DicomCharsetException ? DumpUtils.failoverValueDecoder(dcmDataElement, i, ex) : "<ERROR! " + ex + ">";
            }
            if (this.maxvalue > 0) {
                boolean partialData;
                boolean bl = partialData = e.getBytesSkipped() > 0L || text.length() > this.maxvalue;
                if (partialData && dcmDataElement.size() == i + 1) {
                    if (text.length() >= 4) {
                        sb.append(StringEscapeUtils.escapeXml10((String)text.substring(0, text.length() - 3)));
                    }
                    sb.append("...");
                } else {
                    sb.append(StringEscapeUtils.escapeXml10((String)text));
                }
            } else {
                sb.append(StringEscapeUtils.escapeXml10((String)text));
            }
            sb.append("</dicom-element-value>");
            this.print(sb);
        }
    }

    private void writeNonSequenceItemStart(TagReadEvent e) {
        String desc;
        DataElement dataElement = e.getDataElement();
        DDictEntry entry = DDict.getEntry(DDict.lookupDDict(dataElement.getGroup(), dataElement.getElement()));
        if (DDictBase.isPrivateCreatorTag(dataElement.getGroup(), dataElement.getElement())) {
            desc = "Private Creator";
        } else if (entry == null) {
            desc = "Undefined";
        } else if (dataElement.getGroup() % 2 == 1) {
            String cr;
            try {
                cr = Dicom2XmlStreamWriter.getPrivateCreatorId(e.getDicomObject(), e.getGroup(), e.getElement());
                entry = DDict.getEntry(DDict.lookupDDict(dataElement.getGroup(), dataElement.getElement(), cr));
            }
            catch (Throwable ex) {
                cr = null;
            }
            desc = entry != null && entry.getPrivateCreatorID() != null && cr != null && cr.equals(entry.getPrivateCreatorID()) ? entry.getDescription() : "Private Tag";
        } else {
            desc = entry.getDescription();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(e.getVRType() == 10 ? "<dicom-sequence " : "<dicom-element ");
        sb.append("element=\"");
        sb.append(DumpUtils.toShortHexString(e.getElement()));
        sb.append("\" name=\"");
        sb.append(desc);
        if (e.getVRType() != 10) {
            sb.append("\" vm=\"");
            sb.append(e.getDataElement().size());
            if (e.getBytesSkipped() > 0L) {
                sb.append("+");
            }
        }
        sb.append("\" vr=\"");
        sb.append(DDict.getTypeName(e.getDataElement().getVR()));
        sb.append("\">");
        this.print(sb);
        ++this.level;
    }

    private void writeNonSequenceItemEnd(TagReadEvent e) {
        --this.level;
        StringBuilder sb = new StringBuilder();
        sb.append(e.getVRType() == 10 ? "</dicom-sequence>" : "</dicom-element>");
        this.print(sb);
        if (e.getVRType() == 10) {
            this.activeGroup = e.getGroup();
        }
    }

    private static String getPrivateCreatorId(DicomObject dcm, int group, int element) {
        try {
            return dcm.getString_ge(group, element >> 8, 0);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    class DumpTagListener
    implements TagRead2Listener,
    SequenceItemReadListener {
        private final OutputStream outputStream;
        private final boolean metainfo;
        private final boolean grouplengths;
        private boolean suppressed = false;

        DumpTagListener(OutputStream outputStream, boolean metainfo, boolean grouplengths) {
            this.outputStream = outputStream;
            this.metainfo = metainfo;
            this.grouplengths = grouplengths;
        }

        @Override
        public void afterData(TagReadEvent e) {
            if (this.suppressed) {
                return;
            }
            if (e.getElement() == 0 && !this.grouplengths) {
                return;
            }
            if (e.getGroup() == 2 && !this.metainfo && e.getDicomObject().getParent() == null) {
                return;
            }
            if (e.getDataElement().getVR() == 10) {
                Dicom2XmlStreamWriter.this.writeNonSequenceItemEnd(e);
            } else {
                Dicom2XmlStreamWriter.this.writeNonSequenceItemStart(e);
                Dicom2XmlStreamWriter.this.writeDataElementValues(e);
                Dicom2XmlStreamWriter.this.writeNonSequenceItemEnd(e);
            }
            if (DDictBase.isPrivateCreatorTag(e.getGroup(), e.getElement()) || e.getGroup() == 8 && e.getElement() == 5 || DDict.lookupDDict(e.getGroup(), e.getElement()) == 131088) {
                e.setDataReadStatus(0);
            } else {
                e.setDataReadStatus(2);
            }
        }

        @Override
        public void afterHeader(TagReadEvent e) {
            int group;
            if (Dicom2XmlStreamWriter.this.maxvalue > 0) {
                if (e.getTag() == 131088 || e.getTag() == 524293 || DDictBase.isPrivateCreatorTag(e.getGroup(), e.getElement())) {
                    e.setMaxReadLength(0L);
                } else {
                    e.setMaxReadLength(Dicom2XmlStreamWriter.this.maxvalue);
                }
            }
            if ((group = e.getGroup()) == 2 && !this.metainfo && e.getDicomObject().getParent() == null) {
                return;
            }
            if (group == 2 && Dicom2XmlStreamWriter.this.activeGroup == 0 && this.metainfo && Dicom2XmlStreamWriter.this.level == 1) {
                Dicom2XmlStreamWriter.this.writeFileMetaStart();
                Dicom2XmlStreamWriter.this.writeGroupStart(group);
                Dicom2XmlStreamWriter.this.activeGroup = group;
            } else if (group != 2 && Dicom2XmlStreamWriter.this.activeGroup == 2 && this.metainfo && Dicom2XmlStreamWriter.this.level == 3) {
                Dicom2XmlStreamWriter.this.writeGroupEnd();
                Dicom2XmlStreamWriter.this.writeFileMetaEnd();
                Dicom2XmlStreamWriter.this.writeDatasetStart();
                Dicom2XmlStreamWriter.this.writeGroupStart(group);
                Dicom2XmlStreamWriter.this.activeGroup = group;
            } else if (Dicom2XmlStreamWriter.this.level == 1 && Dicom2XmlStreamWriter.this.activeGroup == 0) {
                Dicom2XmlStreamWriter.this.writeDatasetStart();
                Dicom2XmlStreamWriter.this.writeGroupStart(group);
                Dicom2XmlStreamWriter.this.activeGroup = group;
            } else if (e.getGroup() != Dicom2XmlStreamWriter.this.activeGroup) {
                if (Dicom2XmlStreamWriter.this.activeGroup > 0) {
                    Dicom2XmlStreamWriter.this.writeGroupEnd();
                }
                Dicom2XmlStreamWriter.this.writeGroupStart(e.getGroup());
                Dicom2XmlStreamWriter.this.activeGroup = e.getGroup();
            }
            if (e.getDataElement().getVR() == 10) {
                Dicom2XmlStreamWriter.this.writeNonSequenceItemStart(e);
            }
        }

        @Override
        public void beforeSequenceItem(SequenceItemReadEvent e) {
            Dicom2XmlStreamWriter.this.writeSequenceItemStart(e.getItemIndex() + 1);
        }

        @Override
        public void afterSequenceItem(SequenceItemReadEvent e) {
            Dicom2XmlStreamWriter.this.writeGroupEnd();
            Dicom2XmlStreamWriter.this.writeSequenceItemEnd();
        }

        private void writeString(StringBuilder sb) {
            try {
                this.outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                this.suppressed = true;
                throw new RuntimeException("IOException when writing to specified outputstream, suppressing further output");
            }
        }
    }
}

