/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.tool;

import com.archimed.dicom.DicomUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    public static long transferTo(InputStream in, long offset, long length, OutputStream out, SWAP_MODE swapMode) throws IOException {
        long transferred;
        int read;
        long skipped = in.skip(offset);
        if (skipped < offset) {
            throw new IOException(String.format("Unable to skip %s bytes (skipped: %s)", offset, skipped));
        }
        byte[] buffer = new byte[8192];
        for (transferred = 0L; (read = in.read(buffer, 0, (int)Math.min(8192L, length - transferred))) >= 0 && transferred < length; transferred += (long)read) {
            switch (swapMode) {
                case WORD: {
                    DicomUtils.swapWords(buffer);
                    break;
                }
                case LONGWORD: {
                    DicomUtils.swapLongWords(buffer);
                    break;
                }
                case VERYLONGWORD: {
                    DicomUtils.swapVeryLongWords(buffer);
                }
            }
            out.write(buffer, 0, read);
        }
        if (transferred < length) {
            throw new IOException(String.format("End of stream reached before specified offset %s and length %s", offset, length));
        }
        return transferred;
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static void readFully(InputStream input, byte[] buffer) throws IOException {
        IOUtil.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int actual = IOUtil.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static byte[] readFully(InputStream input, int length) throws IOException {
        byte[] buffer = new byte[length];
        IOUtil.readFully(input, buffer, 0, buffer.length);
        return buffer;
    }

    public static enum SWAP_MODE {
        NONE,
        WORD,
        LONGWORD,
        VERYLONGWORD;

    }
}

