/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.apps.cdviewer.MVAppConstants;
import com.ge.med.cse.apps.cdviewer.MVUtils;
import com.ge.med.cse.apps.cdviewer.RedirectedStream;
import com.ge.med.cse.apps.cdviewer.sync.SyncSession;
import com.ge.med.cse.apps.cdviewer.treetable.MvTreeCellRenderer;
import com.ge.med.cse.apps.cdviewer.treetable.PhaseTableRowObject;
import com.ge.med.cse.cvf.base.PleaseWaitDialog;
import com.ge.med.cse.cvf.sr.SR2HTMLReportGenerator;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.ui.TitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DataSelector
extends JPanel {
    private Object dmSessionInitLock = new Object();
    private volatile boolean isDMSessionInitialized = false;
    private DMSession archiveSess = null;
    protected Set changeListen;
    protected DataSelectorUI view;
    public static final String SERIES_TABLE = "Series";
    public static final String EXAM_TABLE = "Exam";
    ResourceBundle bundle = CvUtils.getResourceBundle();
    private boolean isDsTreeBuild = false;
    static PleaseWaitDialog waitDlg = null;
    private Capable cap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMSession getArchiveSess() {
        if (!this.isDMSessionInitialized) {
            Object object = this.dmSessionInitLock;
            synchronized (object) {
                try {
                    this.dmSessionInitLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    System.err.println(e.getStackTrace());
                }
            }
        }
        return this.archiveSess;
    }

    public DataSelector() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.changeListen = new HashSet();
        DMSession.insertSession("sync", SyncSession.class.getName());
        String typeOfRep = System.getProperty("REPOSITORY_TYPE", "dicomdir");
        String repPAth = System.getProperty("REPOSITORY_PATH", System.getProperty("user.dir", "."));
        System.setProperty("REPOSITORY_PATH", repPAth);
        System.out.println("DataSelector.DataSelector() " + typeOfRep + "  " + repPAth);
        final String[] args = new String[]{"sync", typeOfRep, repPAth};
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Tap.setProperty("tap.dm.ImageMemory", "300");
                    DataSelector.this.archiveSess = new DMSession(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(e.getStackTrace());
                    final Object[] options = new Object[]{"OK"};
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = JOptionPane.showOptionDialog(DataSelector.this.getTopLevelAncestor(), DataSelector.this.bundle.getString("ERROR_FAILED_TO_LOAD"), DataSelector.this.bundle.getString("MEDIA_VIEWER_TITLE"), 0, 0, null, options, options[0]);
                        }
                    });
                }
                finally {
                    DataSelector.this.isDMSessionInitialized = true;
                    Object object = DataSelector.this.dmSessionInitLock;
                    synchronized (object) {
                        DataSelector.this.dmSessionInitLock.notifyAll();
                    }
                }
            }
        });
        thread.start();
        this.view = new DataSelectorUI();
        this.setPreferredSize(new Dimension(250, 250));
        this.add(this.view);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SR2HTMLReportGenerator.clearSRTempFiles(new File(RedirectedStream.SR_TMP_DIR));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.setName("MV_DATA_SELECTOR");
    }

    public void loadData() {
        this.view.loadData();
    }

    void setPrefferedWidthForColumn(JTable table) {
        int noofCols = table.getColumnCount();
        for (int i = noofCols - 1; i >= 0; --i) {
            TableColumn colForWidthSet = table.getColumnModel().getColumn(i);
            TableCellRenderer renderer = null;
            Component comp = null;
            int widthToSet = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                renderer = table.getCellRenderer(row, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, i), false, false, row, i);
                if (comp.getPreferredSize().width <= widthToSet) continue;
                widthToSet = comp.getPreferredSize().width;
            }
            colForWidthSet.setPreferredWidth(widthToSet + 20);
        }
    }

    public void addSelectionChangeListener(ChangeListener list) {
        this.changeListen.add(list);
    }

    public void removeSelectionChangeListener(ChangeListener list) {
        this.changeListen.add(list);
    }

    protected synchronized void fireChange(DMObject[] selected) {
        ChangeListener[] toFire = this.changeListen.toArray(new ChangeListener[this.changeListen.size()]);
        ChangeEvent event = new ChangeEvent(selected);
        for (int i = 0; i < toFire.length; ++i) {
            try {
                toFire[i].stateChanged(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSelection(String level, DMQuery qry) {
        this.view.selectNode((DefaultTreeModel)this.view.mvTree.getModel(), (MvTreeNode)this.view.mvTree.getModel().getRoot(), level, qry);
    }

    public void checkAutoLoad() {
        this.view.autoLoad();
    }

    public void setCapable(XPscreen screen) {
        this.cap = screen;
    }

    public class MvTreeNode
    extends DefaultMutableTreeNode {
        private String nodeType;
        private Object dmObj;
        private Comparator mvTreeNodeComprtr;

        public MvTreeNode(String type, String name, Object dmo) {
            super(name, true);
            this.nodeType = null;
            this.dmObj = null;
            this.mvTreeNodeComprtr = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            };
            this.nodeType = type;
            this.dmObj = dmo;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public DMObject getDmObject() {
            if (this.dmObj == null) {
                return null;
            }
            if (this.dmObj instanceof PhaseTableRowObject) {
                return ((PhaseTableRowObject)this.dmObj).getDMObject();
            }
            return (DMObject)this.dmObj;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            String value = CvPropertiesManager.getProperty("mv.dataSelector.sort");
            if (CvPropertiesManager.getProperty("mv.dataSelector.sort", "false").equalsIgnoreCase("true")) {
                Collections.sort(this.children, this.mvTreeNodeComprtr);
            }
        }
    }

    class DataSelectorUI
    extends TitlePanel {
        JTree mvTree = null;
        JButton load = null;

        public DataSelectorUI() {
            this.setTitle(MVAppConstants.I18N.DATA_SELECTOR_NAME);
        }

        void loadData() {
            this.setLayout(new BorderLayout());
            MvTreeNode rootPesiNode = new MvTreeNode("", "", null);
            MVTreeModel model = new MVTreeModel(rootPesiNode, true);
            this.mvTree = new JTree(model);
            this.mvTree.setName("MV_DATA_SELECTOR_TREE");
            this.mvTree.setCellRenderer(new MvTreeCellRenderer());
            this.mvTree.setRootVisible(false);
            model.addAllPatientProgressively();
            ToolTipManager.sharedInstance().registerComponent(this.mvTree);
            this.mvTree.getSelectionModel().setSelectionMode(4);
            this.mvTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        MvTreeNode node = (MvTreeNode)DataSelectorUI.this.mvTree.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        if (node.getNodeType().equals("series") && node.getDmObject() != null) {
                            DMObject[] ser = new DMObject[]{node.getDmObject()};
                            DataSelector.this.fireChange(ser);
                        }
                    }
                }
            });
            this.mvTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    boolean enable = false;
                    TreePath[] paths = ((TreeSelectionModel)e.getSource()).getSelectionPaths();
                    if (paths == null || paths.length == 0) {
                        return;
                    }
                    int selNodeCnt = paths.length;
                    for (int i = 0; i < selNodeCnt; ++i) {
                        MvTreeNode node = (MvTreeNode)paths[i].getLastPathComponent();
                        if (!node.getNodeType().equals("series") || node.getDmObject() == null) {
                            enable = false;
                            break;
                        }
                        enable = true;
                    }
                    DataSelectorUI.this.load.setEnabled(enable);
                }
            });
            JScrollPane scroll1 = new JScrollPane(this.mvTree);
            this.add((Component)scroll1, "Center");
            this.load = new JButton(new LoadButton());
            this.add((Component)this.load, "South");
            this.load.setPreferredSize(new Dimension(200, 30));
            this.load.setMinimumSize(new Dimension(200, 30));
            JPanel borderpanel = new JPanel();
            borderpanel.add(this.load);
            this.add((Component)borderpanel, "South");
            this.load.setName("LoadBtn");
            this.load.setEnabled(false);
            this.load.setName("MV_DATA_SELECTOR_LOAD_BUTTON");
        }

        public void autoLoad() {
            if (!DataSelector.this.isDsTreeBuild) {
                return;
            }
            if (this.mvTree != null && this.mvTree.getRowCount() == 1) {
                this.mvTree.expandRow(0);
                if (!(this.mvTree.getPathForRow(0).getLastPathComponent() instanceof MvTreeNode)) {
                    return;
                }
                MvTreeNode patNode = (MvTreeNode)this.mvTree.getPathForRow(0).getLastPathComponent();
                if (patNode.getChildCount() == 1) {
                    this.mvTree.expandRow(1);
                    MvTreeNode examNode = (MvTreeNode)this.mvTree.getPathForRow(1).getLastPathComponent();
                    int seriesNodeCnt = examNode.getChildCount();
                    if (seriesNodeCnt == 0) {
                        return;
                    }
                    boolean autoLoad = false;
                    if (seriesNodeCnt == 1) {
                        this.mvTree.setSelectionRow(2);
                        autoLoad = true;
                    } else if (seriesNodeCnt == 2) {
                        DMObject ser0 = ((MvTreeNode)examNode.getChildAt(0)).getDmObject();
                        DMObject ser1 = ((MvTreeNode)examNode.getChildAt(1)).getDmObject();
                        String modality1 = (String)ser0.getValue(new DMTag(8, 96));
                        String modality2 = (String)ser1.getValue(new DMTag(8, 96));
                        if (!MVUtils.isScoutImage(ser0) && !MVUtils.isScoutImage(ser1) && (modality1.equalsIgnoreCase("ct") && modality2.equalsIgnoreCase("pt") || modality1.equalsIgnoreCase("pt") && modality2.equalsIgnoreCase("ct"))) {
                            this.mvTree.setSelectionRows(new int[]{2, 3});
                            autoLoad = true;
                        }
                    } else if (seriesNodeCnt == 3) {
                        int curRow = 2;
                        int ctindeex = -1;
                        int ptindex = -1;
                        boolean isCt = false;
                        boolean isPt = false;
                        int[] rowsToSelect = new int[]{-1, -1};
                        for (int i = 0; i < seriesNodeCnt; ++i) {
                            DMObject ser = ((MvTreeNode)examNode.getChildAt(i)).getDmObject();
                            String mod = (String)ser.getValue(new DMTag(8, 96));
                            if (!MVUtils.isScoutImage(ser)) {
                                if ("CT".equalsIgnoreCase(mod)) {
                                    ctindeex = curRow;
                                    isCt = true;
                                } else if ("PT".equalsIgnoreCase(mod)) {
                                    ptindex = curRow;
                                    isPt = true;
                                }
                            }
                            ++curRow;
                        }
                        rowsToSelect[0] = ctindeex;
                        rowsToSelect[1] = ptindex;
                        if (isCt && isPt) {
                            this.mvTree.setSelectionRows(rowsToSelect);
                            autoLoad = true;
                            System.out.println("DataSelector.DataSelectorUI.autoLoad() autoload true" + rowsToSelect[0] + "   " + rowsToSelect[1]);
                        }
                    } else {
                        this.mvTree.setSelectionRow(1);
                    }
                    if (autoLoad) {
                        this.load.doClick();
                    }
                }
            }
        }

        private void selectNode(DefaultTreeModel mvTreeModel, MvTreeNode curNode, String level, DMQuery qry) {
            int chldCnt = mvTreeModel.getChildCount(curNode);
            for (int idx = 0; idx < chldCnt; ++idx) {
                MvTreeNode child = (MvTreeNode)mvTreeModel.getChild(curNode, idx);
                if (child.getNodeType().equalsIgnoreCase(level)) {
                    DMObject[] dmo = child.getDmObject().getRelated(level, qry);
                    if (dmo == null || dmo.length <= 0) continue;
                    Object[] nodes = mvTreeModel.getPathToRoot(child);
                    TreePath tpath = new TreePath(nodes);
                    this.mvTree.scrollPathToVisible(tpath);
                    this.mvTree.setSelectionPath(tpath);
                    this.mvTree.repaint();
                    break;
                }
                this.selectNode(mvTreeModel, child, level, qry);
            }
        }

        class LoadButton
        extends AbstractAction {
            LoadButton() {
                super(CvUtils.getResourceBundle().getString("DATASELECTOR_LOAD_BUTTON"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] paths = DataSelectorUI.this.mvTree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                int selNodeCnt = 1;
                if (paths.length >= 2) {
                    selNodeCnt = 2;
                }
                ArrayList<DMObject> vec = new ArrayList<DMObject>();
                for (int i = 0; i < selNodeCnt; ++i) {
                    MvTreeNode node = (MvTreeNode)paths[i].getLastPathComponent();
                    if (!node.getNodeType().equals("series") || node.getDmObject() == null) continue;
                    vec.add(node.getDmObject());
                }
                DMObject[] ser = new DMObject[vec.size()];
                vec.toArray(ser);
                if (vec.size() > 0) {
                    DataSelector.this.fireChange(ser);
                }
            }
        }
    }

    class MVTreeModel
    extends DefaultTreeModel {
        DefaultMutableTreeNode rootNode;

        public MVTreeModel(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
            this.rootNode = null;
            this.rootNode = (DefaultMutableTreeNode)root;
            this.rootNode.add(new DefaultMutableTreeNode());
            this.nodeStructureChanged(this.rootNode);
        }

        public void addAllPatientProgressively() {
            DataSelector.this.getTopLevelAncestor().addPropertyChangeListener("licenseagreed", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!DataSelector.this.isDsTreeBuild) {
                        waitDlg = new PleaseWaitDialog((JFrame)DataSelector.this.getTopLevelAncestor());
                        waitDlg.setVisible(true);
                    }
                }
            });
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DMSession archiveSess = DataSelector.this.getArchiveSess();
                    if (archiveSess == null) {
                        return;
                    }
                    DMObject[] patDMO = archiveSess.getRelated("patient");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MVTreeModel.this.rootNode.removeAllChildren();
                        }
                    });
                    int size = patDMO.length;
                    for (int i = 0; i < size; ++i) {
                        try {
                            final DefaultMutableTreeNode patNode = MVTreeModel.this.getNode("patient", patDMO[i]);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MVTreeModel.this.rootNode.add(patNode);
                                }
                            });
                            Object[] dmoAllExam = patDMO[i].getRelated("study");
                            CvUtils.sortExam(dmoAllExam);
                            int examsize = dmoAllExam.length;
                            for (int j = 0; j < examsize; ++j) {
                                final DefaultMutableTreeNode examNode = MVTreeModel.this.getNode("study", (DMObject)dmoAllExam[j]);
                                patNode.add(examNode);
                                DMObject[] allDmoSeries = ((DMObject)dmoAllExam[j]).getRelated("series");
                                CvUtils.sortSeries(allDmoSeries);
                                int seriessize = allDmoSeries.length;
                                for (int k = 0; k < seriessize; ++k) {
                                    final DefaultMutableTreeNode series = MVTreeModel.this.getNode("series", allDmoSeries[k]);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            examNode.add(series);
                                        }
                                    });
                                }
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MVTreeModel.this.nodeStructureChanged(MVTreeModel.this.rootNode);
                                }
                            });
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DataSelector.this.getTopLevelAncestor().firePropertyChange("treebuild", 0L, 1L);
                        }
                    });
                    DataSelector.this.isDsTreeBuild = true;
                    if (waitDlg != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                waitDlg.setVisible(false);
                                waitDlg.dispose();
                                DataSelector.this.view.autoLoad();
                            }
                        });
                    }
                }
            });
            thread.start();
        }

        private DefaultMutableTreeNode getNode(String level, DMObject dmo) {
            if (level.equals("patient")) {
                String desc = (String)dmo.getValue(16, 16);
                return new MvTreeNode("patient", (desc = desc.replaceAll("[*[\\^][\\,]*]", " ").trim()) == null || desc == "" ? "NO_PATIENT_DESCRIPTION" : desc, dmo);
            }
            if (level.equals("study")) {
                String id = (String)dmo.getValue(32, 16);
                String studyDate = (String)dmo.getValue(8, 32);
                if (studyDate != "" && studyDate.length() == 8) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(Integer.parseInt(studyDate.substring(0, 4)), Integer.parseInt(studyDate.substring(4, 6)) - 1, Integer.parseInt(studyDate.substring(6, studyDate.length())));
                    Date stDate = cal.getTime();
                    studyDate = DateFormat.getDateInstance(2).format(stDate);
                }
                String desc = (String)dmo.getValue(8, 4144);
                String nodeName = "";
                boolean brktOpen = false;
                if (id != null && id != "") {
                    nodeName = id;
                }
                if (studyDate != null && studyDate != "") {
                    nodeName = nodeName + " (" + studyDate;
                    brktOpen = true;
                }
                if (desc != null && desc != "") {
                    nodeName = nodeName + (brktOpen ? "" : " (") + (brktOpen ? ", " : "") + desc;
                }
                if (brktOpen || nodeName.contains(" (")) {
                    nodeName = nodeName + ") ";
                }
                return new MvTreeNode("study", nodeName, dmo);
            }
            if (level.equals("series")) {
                boolean isPTGatedSeries = CvImageFusionUtils.isPETSeries(dmo) && CvImageFusionUtils.isPETSeriesTypeGATED(dmo);
                boolean isGSPSSeries = MVUtils.isPRSeries(dmo);
                boolean isSRSeries = MVUtils.isSR(dmo);
                MvTreeNode serNode = null;
                try {
                    DMObject[] srObjs;
                    int i;
                    String desc = (String)dmo.getValue(8, 4158);
                    String serNumber = (String)dmo.getValue(32, 17);
                    serNumber = isGSPSSeries ? "Se: " + serNumber : serNumber;
                    String modality = (String)dmo.getValue(8, 96);
                    String serNodeName = "";
                    boolean brktOpen = false;
                    if (serNumber != null && serNumber != "") {
                        serNodeName = serNumber;
                    }
                    if (modality != null && modality != "") {
                        serNodeName = serNodeName + " (" + dmo.getRelated("image").length + ", " + modality;
                        brktOpen = true;
                    }
                    if (desc != null && desc != "") {
                        serNodeName = serNodeName + (brktOpen ? "" : " (") + (brktOpen ? ", " : "") + desc;
                    }
                    if (brktOpen || serNodeName.contains(" (")) {
                        serNodeName = serNodeName + ") ";
                    }
                    if (isPTGatedSeries) {
                        DMObject[][] imgs = CvImageFusionUtils.sortPETseries(dmo);
                        if (imgs.length > 1) {
                            serNode = new MvTreeNode("series", serNodeName, new PhaseTableRowObject(imgs[0], dmo));
                            for (i = 0; i < imgs.length; ++i) {
                                PhaseTableRowObject phaseObj = new PhaseTableRowObject(imgs[i], dmo);
                                try {
                                    MvTreeNode gSerNode = new MvTreeNode("series", phaseObj.getSeriesDescription(), phaseObj);
                                    serNode.add(gSerNode);
                                    gSerNode.setAllowsChildren(false);
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            serNode = new MvTreeNode("series", serNodeName, dmo);
                            serNode.setAllowsChildren(false);
                        }
                    } else {
                        serNode = new MvTreeNode("series", serNodeName, dmo);
                        serNode.setAllowsChildren(false);
                    }
                    if (isGSPSSeries) {
                        DMObject[] gspsObjs = dmo.getRelated("image");
                        for (i = 0; i < gspsObjs.length; ++i) {
                            try {
                                String gspsNodeName = i + 1 + "";
                                String gspsLabel = gspsObjs[i].getValue(112, 128).toString();
                                if (gspsLabel != null && gspsLabel != "") {
                                    gspsNodeName = gspsNodeName + " (" + gspsLabel + ") ";
                                }
                                MvTreeNode gspsNode = new MvTreeNode("series", gspsNodeName, gspsObjs[i]);
                                serNode.setAllowsChildren(true);
                                serNode.add(gspsNode);
                                gspsNode.setAllowsChildren(false);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (isSRSeries && (srObjs = dmo.getRelated("image")).length > 1) {
                        for (i = 0; i < srObjs.length; ++i) {
                            try {
                                String nodeName = i + 1 + "";
                                String srLabel = "SR DOCUMENT " + (i + 1);
                                nodeName = nodeName + " (" + srLabel + ") ";
                                MvTreeNode srNode = new MvTreeNode("series", nodeName, srObjs[i]);
                                serNode.setAllowsChildren(true);
                                serNode.add(srNode);
                                srNode.setAllowsChildren(false);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return serNode;
            }
            return null;
        }
    }
}

