/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.sync;

import java.beans.ExceptionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class BackgroundThread {
    private static final Logger logger = Logger.getLogger(BackgroundThread.class.getName());
    private transient Thread worker;
    private transient List jobs = new LinkedList();
    private static Map map = new HashMap();
    private Job currentJob = null;

    private BackgroundThread(String name) {
        this.worker = new Thread(){

            @Override
            public void run() {
                try {
                    BackgroundThread.this.workerRun();
                }
                catch (InterruptedException e) {
                    logger.fine("background thread interrupted");
                }
            }
        };
        this.worker.setName(name + " (" + this.getClass().getName() + ")");
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackgroundThread getBackgroundThread(String name) {
        Map map = BackgroundThread.map;
        synchronized (map) {
            Object obj = BackgroundThread.map.get(name);
            if (obj == null) {
                obj = new BackgroundThread(name);
                BackgroundThread.map.put(name, obj);
            }
            return (BackgroundThread)obj;
        }
    }

    public static BackgroundThread getDefaultBackgroundThread() {
        return BackgroundThread.getBackgroundThread("default");
    }

    private Job find(Runnable r) {
        for (int i = 0; i < this.jobs.size(); ++i) {
            Job j = (Job)this.jobs.get(i);
            if (j.runnable != r) continue;
            return j;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubmit(Runnable r) {
        List list = this.jobs;
        synchronized (list) {
            Job j = this.find(r);
            if (j != null) {
                boolean found = this.jobs.remove(j);
                this.jobs.notifyAll();
                return found;
            }
            return false;
        }
    }

    public void waitForJob(Runnable r) throws InterruptedException {
        if (r == null) {
            return;
        }
        List list = this.jobs;
        synchronized (list) {
            while (true) {
                Job j = null;
                j = this.currentJob != null && this.currentJob.runnable == r ? this.currentJob : this.find(r);
                if (j == null) {
                    return;
                }
                this.jobs.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberRemaining() {
        List list = this.jobs;
        synchronized (list) {
            return this.jobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable job) {
        Job j = new Job(job);
        List list = this.jobs;
        synchronized (list) {
            this.jobs.add(j);
            this.jobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable job, ExceptionListener listener) {
        Job j = new Job(job, listener);
        List list = this.jobs;
        synchronized (list) {
            this.jobs.add(j);
            this.jobs.notifyAll();
        }
    }

    public void setPriority(int p) {
        this.worker.setPriority(p);
    }

    public int getPriority() {
        return this.worker.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerRun() throws InterruptedException {
        while (true) {
            Job job = null;
            List list = this.jobs;
            synchronized (list) {
                while (this.jobs.size() < 1) {
                    this.jobs.wait();
                }
                this.currentJob = job = (Job)this.jobs.remove(0);
                this.jobs.notifyAll();
            }
            if (job == null) continue;
            try {
                job.runnable.run();
                continue;
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                if (!(e instanceof Exception) || job.listener == null) continue;
                job.listener.exceptionThrown((Exception)e);
                continue;
            }
            finally {
                list = this.jobs;
                synchronized (list) {
                    this.currentJob = null;
                    this.jobs.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private class Job {
        Runnable runnable;
        ExceptionListener listener = null;

        Job(Runnable r) {
            this.runnable = r;
        }

        Job(Runnable r, ExceptionListener l) {
            this(r);
            this.listener = l;
        }
    }
}

