/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.cse.apps.cdviewer.MVUtils;
import com.ge.med.cse.apps.cdviewer.treetable.SeriesTableRowObject;
import com.ge.med.cse.apps.cdviewer.treetable.TableRowObject;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class DMSeriesTableModel
extends AbstractTableModel
implements MouseListener {
    private ArrayList<TableRowObject> shownRowObjects = new ArrayList();
    public static final String CLOSED_NODE = "+";
    public static final String OPEN_NODE = "-";
    public static final String LEAF_NODE = "|";
    public static final String END_LEAF_NODE = "#";
    protected String[] serColNames = new String[]{"Series", "Description", "Modality"};
    HashMap<String, DMTag> columnTags = new HashMap();
    ResourceBundle bundle = ResourceBundle.getBundle("com.ge.med.cse.apps.cdviewer.MvResource");
    protected String[] serColNamesi18n = new String[]{this.bundle.getString("SERIES_COLUMN_TITLE"), this.bundle.getString("DESCRIPTION"), this.bundle.getString("MODALITY")};
    String modality = "CT";
    String prevMod = "";
    int count = 0;

    public DMSeriesTableModel(DMObject examObject) {
        this.createColumnTags(examObject);
        this.createTableModel(examObject);
    }

    private void createColumnTags(DMObject examObject) {
        this.prevMod = this.modality;
        this.modality = examObject.getValue(8, 96).toString();
        if (this.modality.equalsIgnoreCase("DX")) {
            this.serColNames = new String[]{"SERIES_COLUMN_TITLE", "DX_TYPE", "DX_PROCEDURE"};
            this.serColNamesi18n = new String[]{this.bundle.getString("SERIES_COLUMN_TITLE"), this.bundle.getString("DX_TYPE"), this.bundle.getString("DX_PROCEDURE")};
            this.columnTags.clear();
            this.columnTags.put("SERIES_COLUMN_TITLE", new DMTag(32, 17));
            this.columnTags.put("DX_TYPE", new DMTag(8, 104));
            this.columnTags.put("DX_PROCEDURE", new DMTag(8, 4158));
            if (!this.prevMod.equalsIgnoreCase(this.modality)) {
                this.fireTableStructureChanged();
            }
        } else {
            this.serColNames = new String[]{"SERIES_COLUMN_TITLE", "DESCRIPTION", "MODALITY"};
            this.serColNamesi18n = new String[]{this.bundle.getString("SERIES_COLUMN_TITLE"), this.bundle.getString("DESCRIPTION"), this.bundle.getString("MODALITY")};
            this.columnTags.clear();
            this.columnTags.put("SERIES_COLUMN_TITLE", new DMTag(32, 17));
            this.columnTags.put("DESCRIPTION", new DMTag(8, 4158));
            this.columnTags.put("MODALITY", new DMTag(8, 96));
            if (this.prevMod.equalsIgnoreCase("DX")) {
                this.fireTableStructureChanged();
            }
        }
    }

    public DMSeriesTableModel() {
    }

    public void setExamDMObject(DMObject examObject) {
        this.createColumnTags(examObject);
        if (this.count == 0) {
            ++this.count;
            return;
        }
        this.createTableModel(examObject);
    }

    private void createTableModel(DMObject examObject) {
        this.shownRowObjects.clear();
        DMObject[] se = examObject.getRelated("series");
        try {
            CvUtils.sortSeries(se);
        }
        catch (Exception e) {
            return;
        }
        for (int i = 0; i < se.length; ++i) {
            SeriesTableRowObject rowObject = new SeriesTableRowObject(se[i]);
            this.shownRowObjects.add(rowObject);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.shownRowObjects.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retval = "";
        TableRowObject rowObj = this.shownRowObjects.get(rowIndex);
        if (rowObj == null) {
            return retval;
        }
        switch (columnIndex) {
            case 0: {
                if (rowObj.hasChild()) {
                    if (rowObj.isExpanded()) {
                        retval = OPEN_NODE;
                        break;
                    }
                    retval = CLOSED_NODE;
                    break;
                }
                if (!rowObj.isChild()) break;
                retval = END_LEAF_NODE;
                if (rowIndex == this.shownRowObjects.size() - 1 || !this.shownRowObjects.get(rowIndex + 1).isChild()) break;
                retval = LEAF_NODE;
                break;
            }
            case 1: {
                retval = this.unmaskNull(rowObj.getID());
                break;
            }
            case 2: {
                if (MVUtils.isPRSeries(rowObj.getDMObject()) && rowObj.isChild()) {
                    retval = this.unmaskNull(rowObj.getDMObject().getValue(112, 128));
                    break;
                }
                retval = this.unmaskNull(rowObj.getValue(this.columnTags.get(this.serColNames[columnIndex - 1])));
                break;
            }
            case 3: {
                retval = this.unmaskNull(rowObj.getValue(this.columnTags.get(this.serColNames[columnIndex - 1])));
            }
        }
        return retval;
    }

    @Override
    public int getColumnCount() {
        return this.serColNames.length + 1;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? " " : this.serColNamesi18n[column - 1];
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    private Object unmaskNull(Object toUnmask) {
        return toUnmask == null ? "" : (String)toUnmask;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e != null && e.getSource() instanceof JTable && SwingUtilities.isLeftMouseButton(e)) {
                this.showTableTree(e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showTableTree(MouseEvent e) {
        if (e != null) {
            Vector<TableRowObject> children;
            Point p = new Point(e.getX(), e.getY());
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(p);
            int row = table.rowAtPoint(p);
            if (col < 0) {
                col = 0;
            }
            if (row < 0) {
                row = 0;
            } else if (row >= this.shownRowObjects.size()) {
                row = this.shownRowObjects.size() - 1;
            }
            TableRowObject rowObject = this.shownRowObjects.get(row);
            if (col == 0 && rowObject.hasChild() && (children = rowObject.getChildren()) != null) {
                if (rowObject.isExpanded()) {
                    this.removeFromTable(row, children);
                } else {
                    this.addToTable(row, children);
                }
                rowObject.toggleExpanded();
            }
        }
    }

    private void addToTable(int index, Vector<TableRowObject> children) {
        this.shownRowObjects.addAll(index + 1, children);
        this.fireTableRowsInserted(index + 1, index + children.size());
    }

    private void removeFromTable(int index, Vector<TableRowObject> children) {
        this.shownRowObjects.removeAll(children);
        this.fireTableRowsDeleted(index + 1, index + children.size());
    }

    public TableRowObject getTableRowObjectAt(int row) {
        return this.shownRowObjects.get(row);
    }
}

