/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.ui;

import com.ge.med.cse.apps.cdviewer.CineSlider;
import com.ge.med.cse.apps.cdviewer.DataSelector;
import com.ge.med.cse.apps.cdviewer.MVAppConstants;
import com.ge.med.cse.apps.cdviewer.MVColorMapCombo;
import com.ge.med.cse.apps.cdviewer.MediaViewerHelpPage;
import com.ge.med.cse.apps.cdviewer.ui.MVImageLoadProgress;
import com.ge.med.cse.apps.cdviewer.ui.MouseMenuToolBarController;
import com.ge.med.cse.cvf.action.XpCalibrationAction;
import com.ge.med.cse.cvf.action.XpCineOnOffAction;
import com.ge.med.cse.cvf.action.XpCinePlayPauseAction;
import com.ge.med.cse.cvf.action.XpEllipseROIAction;
import com.ge.med.cse.cvf.action.XpMaskOnOffAction;
import com.ge.med.cse.cvf.action.XpRectangularROIAction;
import com.ge.med.cse.cvf.action.XpSelectMaskAction;
import com.ge.med.cse.cvf.appframework.ApplicationContext;
import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.controls.CvMouseController;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.ui.RowColFormatButton;
import com.ge.med.cse.cvf.ui.XpComboButton;
import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ControlPanel
extends JComponent
implements ActionListener {
    public JMenuBar menuBar = null;
    public JToolBar toolbar = null;
    public MediaViewerHelpPage help = null;
    private DataSelector ds = new DataSelector();
    private MVImageLoadProgress progressBar = null;
    private Properties prop = null;
    public static final String LAYOUTCHANGE = "LayoutChange";
    private static JLabel notForClinicaluse = null;
    private static final String apps = "apps";
    private static final String dot = ".";
    private static final String menu = "menu";
    private static final String count = "count";
    private static final String name = "name";
    private static final String tooltip = "tooltip";
    private static final String toolbar0 = "toolbar.0";
    private static final String groups = "groups";
    private static final String mode = "mode";
    private static final String component = "component";
    private static final Dimension buttonDim = new Dimension(22, 22);
    private static final Dimension iconSize = new Dimension(18, 18);
    private static final int toolbarComponentGap = 2;
    private ResourceBundle resource = ResourceBundle.getBundle("com.ge.med.cse.apps.cdviewer.MvResource");
    private HashMap<String, JComponent> allComponentMap = new HashMap();
    private HashMap<String, Action> actionCache = new HashMap();
    private HashMap<Integer, JToolBar> toolbarGroups = new HashMap();
    private HashMap<Integer, JToolBar> toolbarGroups2d = new HashMap();
    private HashMap<Integer, JToolBar> toolbarGroups3d = new HashMap();
    private HashMap<String, ArrayList<JMenuItem>> menubarGroups2d = new HashMap();
    private HashMap<String, ArrayList<JMenuItem>> menubarGroups3d = new HashMap();
    private JToolBar mouseModes = null;
    public JComboBox layoubox = new JComboBox<String>(new String[]{MVAppConstants.I18N.DEFAULTFUSED, MVAppConstants.I18N.PET_LAYOUT, MVAppConstants.I18N.CT_LAYOUT, MVAppConstants.I18N.FUSED_LAYOUT_1, MVAppConstants.I18N.FUSED_LAYOUT_2, MVAppConstants.I18N.FUSED_LAYOUT_3, MVAppConstants.I18N.FUSED_LAYOUT_4, MVAppConstants.I18N.FUSED_LAYOUT_5});
    private JComponent lastSelectedComp = null;
    private Insets margin = new Insets(0, 0, 0, 0);
    private XPscreen cap = null;
    private FrameCapable frCap = null;
    private boolean firstTimeLoad = true;
    private PropertyChangeListener dataLoadListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpImage img;
            String modality;
            if (ControlPanel.this.firstTimeLoad) {
                ControlPanel.enableAllComp(ControlPanel.this.toolbar, true);
                ControlPanel.enableAllComp(ControlPanel.this.menuBar, true);
                ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(false);
                ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(false);
                ControlPanel.this.firstTimeLoad = false;
            }
            if ("PT".equalsIgnoreCase(modality = CvUtils.getCurrentModality(ControlPanel.this.cap))) {
                ((Action)ControlPanel.this.actionCache.get(XpEllipseROIAction.class.getName())).setEnabled(false);
                ((Action)ControlPanel.this.actionCache.get(XpRectangularROIAction.class.getName())).setEnabled(false);
            } else {
                ((Action)ControlPanel.this.actionCache.get(XpEllipseROIAction.class.getName())).setEnabled(true);
                ((Action)ControlPanel.this.actionCache.get(XpRectangularROIAction.class.getName())).setEnabled(true);
            }
            ControlPanel.this.frCap = (FrameCapable)((Object)ControlPanel.this.cap.getCapable(FrameCapable.class.getName()));
            if (ControlPanel.this.frCap != null && (img = ControlPanel.this.frCap.getFrame()) instanceof XpDicomObject) {
                XpDicomObject dicomObj = (XpDicomObject)((Object)img);
                boolean pixelSpacing = CvUtils.isPixelSpacingPresent(dicomObj);
                if (!pixelSpacing) {
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCalibrationAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCalibrationAction.class.getName())).setVisible(true);
                    ((Action)ControlPanel.this.actionCache.get(XpCalibrationAction.class.getName())).setEnabled(true);
                } else {
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCalibrationAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCalibrationAction.class.getName())).setVisible(false);
                    ((Action)ControlPanel.this.actionCache.get(XpCalibrationAction.class.getName())).setEnabled(false);
                }
            }
            ControlPanel.this.cap.removePropertyChangeListener("CONTENT_UPDATED", ControlPanel.this.dataLoadListener);
        }
    };
    private MouseAdapter mouseFocusListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent comp;
            super.mouseEntered(e);
            if (e.getSource() instanceof JComponent && (comp = (JComponent)e.getSource()).isEnabled()) {
                comp.setBorder(BorderFactory.createBevelBorder(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JComponent comp;
            super.mouseExited(e);
            if (e.getSource() instanceof JComponent && (comp = (JComponent)e.getSource()).isEnabled()) {
                comp.setBorder(null);
            }
        }
    };
    private HashMap<String, Object> allControls = new HashMap();

    public void enableAll() {
        ControlPanel.enableAllComp(this.toolbar, true);
        ControlPanel.enableAllComp(this.menuBar, true);
    }

    public void disableAll() {
        ControlPanel.enableAllComp(this.toolbar, false);
        ControlPanel.enableAllComp(this.menuBar, false);
    }

    public void setCapable(XPscreen screen) {
        this.cap = screen;
        this.ds.setCapable(screen);
        this.firstTimeLoad = true;
        this.cap.addPropertyChangeListener("CONTENT_CHANGED", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ControlPanel.this.cap.addPropertyChangeListener("CONTENT_UPDATED", ControlPanel.this.dataLoadListener);
            }
        });
        this.cap.addPropertyChangeListener("ComponentSelection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectionCapable scCap;
                if (ControlPanel.this.cap != null && (scCap = (SelectionCapable)ControlPanel.this.cap.getCapable(SelectionCapable.class.getName())) != null) {
                    JComponent comp = scCap.getViewportComponent(scCap.getComponentSelection());
                    if (comp != ControlPanel.this.lastSelectedComp) {
                        ControlPanel.this.update3DMouseController();
                        ControlPanel.this.lastSelectedComp = comp;
                    }
                    if (comp instanceof Capable) {
                        Capable capable = (Capable)((Object)comp);
                        String modality = CvUtils.getCurrentModality(capable);
                        if ("PT".equalsIgnoreCase(modality)) {
                            ((Action)ControlPanel.this.actionCache.get(XpEllipseROIAction.class.getName())).setEnabled(false);
                            ((Action)ControlPanel.this.actionCache.get(XpRectangularROIAction.class.getName())).setEnabled(false);
                        } else {
                            ((Action)ControlPanel.this.actionCache.get(XpEllipseROIAction.class.getName())).setEnabled(true);
                            ((Action)ControlPanel.this.actionCache.get(XpRectangularROIAction.class.getName())).setEnabled(true);
                        }
                    }
                }
            }
        });
        this.cap.addPropertyChangeListener("viewType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ControlPanel.this.update3DMouseController();
            }
        });
        this.cap.addPropertyChangeListener("Cine", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(true)) {
                    ControlPanel.this.disableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCineOnOffAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(true);
                } else {
                    ControlPanel.this.enableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(false);
                }
            }
        });
        this.cap.addPropertyChangeListener("CinePause", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(true)) {
                    ControlPanel.this.disableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCineOnOffAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(true);
                } else {
                    ControlPanel.this.enableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(false);
                }
                if (evt.getNewValue().equals(true)) {
                    JComponent port;
                    ControlPanel.this.enableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(RowColFormatButton.class.getName())).setEnabled(false);
                    SelectionCapable scal = (SelectionCapable)ControlPanel.this.cap.getCapable(SelectionCapable.class.getName());
                    if (scal != null && (port = scal.getViewportComponent(scal.getComponentSelection())) instanceof FrameOwner) {
                        XpImage img = ((FrameOwner)((Object)port)).getFrame();
                        if (img instanceof XpMedicalDmImage && CvDSAImageUtils.isDSASupported(((XpMedicalDmImage)img).getDMImage().getComposite())) {
                            ControlPanel.this.enableAll();
                            ((Action)ControlPanel.this.actionCache.get(XpMaskOnOffAction.class.getName())).setEnabled(true);
                            ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(true);
                            Object val = port.getClientProperty("mask_applied_property");
                            if (val != null && val instanceof Boolean && ((Boolean)val).booleanValue()) {
                                ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                            } else {
                                ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(true);
                            }
                        } else {
                            ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                            ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(true);
                            ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                            ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(true);
                        }
                    }
                } else {
                    ControlPanel.this.disableAll();
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCineOnOffAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(CineSlider.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setEnabled(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpCinePlayPauseAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpMaskOnOffAction.class.getName())).setVisible(true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setVisible(true);
                }
            }
        });
        this.cap.addPropertyChangeListener("MaskRemoved", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(true)) {
                    XpImage img;
                    JComponent port;
                    SelectionCapable scal = (SelectionCapable)ControlPanel.this.cap.getCapable(SelectionCapable.class.getName());
                    if (scal != null && (port = scal.getViewportComponent(scal.getComponentSelection())) instanceof FrameOwner && (img = ((FrameOwner)((Object)port)).getFrame()) instanceof XpMedicalDmImage && CvDSAImageUtils.isDSASupported(((XpMedicalDmImage)img).getDMImage().getComposite())) {
                        ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(true);
                    }
                } else {
                    ((JComponent)ControlPanel.this.allComponentMap.get(XpSelectMaskAction.class.getName())).setEnabled(false);
                }
            }
        });
        ApplicationContext ac = ContextProvider.getApplicationContext("MediaViewer");
        ac.getApplication().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((XpCineCapable)((Object)ControlPanel.this.cap)).isPaused()) {
                    ((AbstractButton)ControlPanel.this.allComponentMap.get(XpCineOnOffAction.class.getName())).doClick();
                }
                if ("MODE3D".equals(evt.getPropertyName())) {
                    System.err.println(">>>>>>>>>>>>>>>>>>>>>> MODE3D");
                    ControlPanel.this.set3DControlPanel();
                } else if ("MODE2D".equals(evt.getPropertyName())) {
                    System.err.println(">>>>>>>>>>>>>>>>>>>>>> MODE2D");
                    ControlPanel.this.set2DControlPanel();
                } else if ("data_loading_begin".equals(evt.getPropertyName())) {
                    System.err.println(">>>>>>>>>>>>>>>>>>>>>> DATA LOADING BEGIN :" + evt.getNewValue());
                    ControlPanel.this.addMouseControlsToToolBar();
                    ControlPanel.this.disableLayout();
                } else if ("data_loading_complete".equals(evt.getPropertyName())) {
                    System.err.println(">>>>>>>>>>>>>>>>>>>>>> DATA LOADING COMPLETE :" + evt.getNewValue());
                    ControlPanel.enableAllComp(ControlPanel.this.menuBar, true);
                    ControlPanel.enableAllComp(ControlPanel.this.toolbar, true);
                    ((JComponent)ControlPanel.this.allComponentMap.get(MVColorMapCombo.class.getName())).setEnabled(true);
                    if ("DATA_LOADING_TASK_VOLUME_FUSION".equals(evt.getNewValue())) {
                        ControlPanel.this.enableLayout();
                    }
                    ControlPanel.this.updateAPSIRL();
                    ControlPanel.this.toolbar.revalidate();
                    ControlPanel.this.toolbar.repaint();
                } else if ("ScreenDisplayed".equals(evt.getPropertyName())) {
                    if ("DefaultFused".equals(evt.getNewValue())) {
                        ControlPanel.this.enableLayout();
                    }
                    if ("Image2DSingle".equals(evt.getNewValue()) || "Image2DCompare".equals(evt.getNewValue())) {
                        ((JComponent)ControlPanel.this.allComponentMap.get(RowColFormatButton.class.getName())).setEnabled(true);
                        ((JComponent)ControlPanel.this.allComponentMap.get(RowColFormatButton.class.getName())).setVisible(true);
                    } else {
                        ((JComponent)ControlPanel.this.allComponentMap.get(RowColFormatButton.class.getName())).setEnabled(false);
                        ((JComponent)ControlPanel.this.allComponentMap.get(RowColFormatButton.class.getName())).setVisible(false);
                    }
                    ControlPanel.this.addMouseControlsToToolBar();
                }
            }
        });
    }

    private void enableLayout() {
        this.layoubox.setName("ScreenLayout");
        this.layoubox.setVisible(true);
        this.layoubox.removeActionListener(this);
        this.layoubox.setSelectedIndex(0);
        this.layoubox.addActionListener(this);
        ControlPanel.enableAllComp(this.layoubox, true);
    }

    private void disableLayout() {
        this.layoubox.setVisible(false);
        this.layoubox.removeActionListener(this);
        ControlPanel.enableAllComp(this.layoubox, false);
    }

    public TaskMonitor getTaskMonitor() {
        return this.progressBar;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public DataSelector getDataSelector() {
        return this.ds;
    }

    public JComponent getHelpPanel() {
        return this.help;
    }

    public void setProperties(Properties properties) {
        this.prop = properties;
        this.toolbar = this.addToolBar();
        this.menuBar = this.addMenuBar();
        ControlPanel.enableAllComp(this.menuBar, false);
        ControlPanel.enableAllComp(this.toolbar, false);
    }

    private static void enableAllComp(JComponent comp, boolean status) {
        Component[] allComp = comp.getComponents();
        for (int i = 0; i < allComp.length; ++i) {
            if (allComp[i] instanceof JToolBar) {
                Component[] allSubComp;
                for (Component c : allSubComp = ((JToolBar)allComp[i]).getComponents()) {
                    if (status && c instanceof AbstractButton && !(c instanceof XpComboButton) && ((AbstractButton)c).getAction() != null) {
                        c.setEnabled(status & ((AbstractButton)c).getAction().isEnabled());
                        continue;
                    }
                    c.setEnabled(status);
                }
                continue;
            }
            if (status && allComp[i] instanceof AbstractButton && !(allComp[i] instanceof XpComboButton) && ((AbstractButton)allComp[i]).getAction() != null) {
                allComp[i].setEnabled(status & ((AbstractButton)allComp[i]).getAction().isEnabled());
                continue;
            }
            allComp[i].setEnabled(status);
        }
        if (notForClinicaluse != null) {
            notForClinicaluse.setEnabled(true);
        }
    }

    private static Icon getScaledIcon(ImageIcon icon) {
        Image img = icon.getImage();
        int ich = icon.getIconHeight() > ControlPanel.iconSize.height ? ControlPanel.iconSize.height : icon.getIconHeight();
        int icw = icon.getIconWidth() > ControlPanel.iconSize.width ? ControlPanel.iconSize.width : icon.getIconWidth();
        ImageIcon ic = new ImageIcon(img.getScaledInstance(icw, ich, 4));
        return ic;
    }

    private void addSeperator(JToolBar tbar) {
        Dimension dim = new Dimension(5, ControlPanel.buttonDim.height);
        JSeparator separator = new JSeparator(1);
        separator.setMaximumSize(dim);
        separator.setMinimumSize(dim);
        this.toolbar.add(Box.createHorizontalStrut(5));
        this.toolbar.add(separator);
        this.toolbar.add(Box.createHorizontalStrut(5));
    }

    private JToolBar newToolBar() {
        JToolBar tbar = new JToolBar();
        tbar.setRollover(false);
        tbar.setFloatable(false);
        return tbar;
    }

    private void add(JToolBar tbar, Action a) {
        JButton b = new JButton();
        b.setAction(a);
        b.setName(a.getClass().getName());
        this.actionCache.put(a.getClass().getName(), a);
        if (a instanceof PlasmaControl) {
            ((PlasmaControl)((Object)a)).setCapable(this.cap);
        }
        this.allControls.put(a.getClass().getName(), b);
        this.allComponentMap.put(a.getClass().getName(), b);
        tbar.add(Box.createHorizontalStrut(2));
        tbar.add(b);
        tbar.add(Box.createHorizontalStrut(2));
        this.configureButton(b);
    }

    private void configureButton(AbstractButton b) {
        Action a = b.getAction();
        b.setBackground(UIManager.getColor("P8"));
        b.setBorder(null);
        b.setPreferredSize(buttonDim);
        b.setMinimumSize(buttonDim);
        b.setMaximumSize(buttonDim);
        Object dsIcon = a.getValue("SmallIcon");
        if (dsIcon instanceof ImageIcon) {
            Icon icon = ControlPanel.getScaledIcon((ImageIcon)dsIcon);
            a.putValue("SmallIcon", icon);
        }
        if (dsIcon != null) {
            b.setText("");
        }
        b.addMouseListener(this.mouseFocusListener);
    }

    private JToolBar addToolBar() {
        this.toolbar = this.newToolBar();
        this.toolbar.setName("roottoolbar");
        this.toolbar.add(Box.createHorizontalStrut(2));
        String appName = this.prop.getProperty(apps);
        String toolbarDim = this.prop.getProperty(appName + dot + toolbar0 + dot + groups);
        int toolbarGroupCount = 0;
        if (toolbarDim != null) {
            toolbarGroupCount = Integer.parseInt(toolbarDim.trim());
        }
        JToolBar dstoolbar = this.newToolBar();
        this.add(dstoolbar, new DataSelectorOnOff());
        dstoolbar.revalidate();
        dstoolbar.repaint();
        this.toolbar.add(dstoolbar);
        this.toolbarGroups.put(-1, dstoolbar);
        for (int g = 0; g < toolbarGroupCount; ++g) {
            String[] modes = new String[]{""};
            String modeStr = this.prop.getProperty(appName + dot + toolbar0 + dot + g + dot + mode);
            if (modeStr != null) {
                modes = modeStr.split(",");
            }
            for (int m = 0; m < modes.length; ++m) {
                String modeSuffix = modes[m] != null && modes[m].length() > 0 ? dot + modes[m] : "";
                JToolBar tbar = this.newToolBar();
                String nactions = this.prop.getProperty(appName + dot + toolbar0 + dot + g + dot + count + modeSuffix);
                int numactions = 0;
                if (nactions != null) {
                    numactions = Integer.parseInt(nactions.trim());
                }
                for (int i = 0; i < numactions; ++i) {
                    String action = this.prop.getProperty(appName + dot + toolbar0 + dot + g + dot + i + modeSuffix);
                    try {
                        JComponent obj;
                        if (action == null || action.equals("")) continue;
                        if ("MouseControllerModes".equalsIgnoreCase(action)) {
                            this.mouseModes = this.getMouseControlsToolBar();
                            tbar.add(this.mouseModes);
                            continue;
                        }
                        Object o = Class.forName(action).newInstance();
                        if (o instanceof XpComboButton) {
                            JButton button = (JButton)o;
                            tbar.add(Box.createHorizontalStrut(2));
                            tbar.add(button);
                            tbar.add(Box.createHorizontalStrut(2));
                            this.allComponentMap.put(o.getClass().getName(), (JButton)o);
                            button.setName(o.getClass().getName());
                        } else if (o instanceof Action) {
                            Action a = (Action)o;
                            AbstractButton button = null;
                            String comp = this.prop.getProperty(appName + dot + toolbar0 + dot + g + dot + i + modeSuffix + dot + component);
                            button = comp != null ? (AbstractButton)CvUtils.createInstance(comp) : new JButton();
                            button.setAction(a);
                            button.setName(a.getClass().getName());
                            tbar.add(Box.createHorizontalStrut(2));
                            tbar.add(button);
                            tbar.add(Box.createHorizontalStrut(2));
                            this.configureButton(button);
                            this.allComponentMap.put(a.getClass().getName(), button);
                            this.actionCache.put(a.getClass().getName(), a);
                        } else if (o instanceof AbstractButton) {
                            AbstractButton b = (AbstractButton)o;
                            b.setBackground(null);
                            b.setPreferredSize(buttonDim);
                            b.setMaximumSize(buttonDim);
                            b.setMinimumSize(buttonDim);
                            b.setIconTextGap(2);
                            b.setVisible(true);
                            b.setMargin(this.margin);
                            b.setName(b.getClass().getName());
                            Action act = b.getAction();
                            if (act != null) {
                                Object actionIcon = act.getValue("SmallIcon");
                                if (actionIcon instanceof ImageIcon) {
                                    Icon icon = ControlPanel.getScaledIcon((ImageIcon)actionIcon);
                                    act.putValue("SmallIcon", icon);
                                    this.actionCache.put(act.getClass().getName(), act);
                                } else {
                                    b.setText("");
                                }
                            }
                            b.setBorder(null);
                            tbar.add(Box.createHorizontalStrut(2));
                            tbar.add(b);
                            tbar.add(Box.createHorizontalStrut(2));
                            b.addMouseListener(this.mouseFocusListener);
                            this.allComponentMap.put(b.getClass().getName(), b);
                        } else if (o instanceof JComboBox) {
                            obj = (JComboBox)o;
                            this.allComponentMap.put(o.getClass().getName(), obj);
                            obj.setMinimumSize(new Dimension(45, ControlPanel.buttonDim.height));
                            obj.setMaximumSize(new Dimension(45, ControlPanel.buttonDim.height));
                            tbar.add(Box.createHorizontalStrut(2));
                            tbar.add(obj);
                            tbar.add(Box.createHorizontalStrut(2));
                            obj.setName(o.getClass().getName());
                        } else if (o instanceof JSlider) {
                            obj = (JSlider)o;
                            this.allComponentMap.put(o.getClass().getName(), obj);
                            obj.setVisible(false);
                            obj.setMinimumSize(new Dimension(100, ControlPanel.buttonDim.height));
                            obj.setMaximumSize(new Dimension(100, ControlPanel.buttonDim.height));
                            obj.setPreferredSize(new Dimension(100, ControlPanel.buttonDim.height));
                            tbar.add(Box.createHorizontalStrut(2));
                            tbar.add(obj);
                            tbar.add(Box.createHorizontalStrut(2));
                            obj.setName(o.getClass().getName());
                        }
                        if (o instanceof PlasmaControl) {
                            PlasmaControl plasma = (PlasmaControl)o;
                            plasma.setCapable(this.cap);
                        }
                        this.allControls.put(action, o);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                tbar.revalidate();
                tbar.repaint();
                if ("3D".equalsIgnoreCase(modes[m])) {
                    this.toolbarGroups3d.put(g, tbar);
                    continue;
                }
                if ("2D".equalsIgnoreCase(modes[m])) {
                    this.addSeperator(this.toolbar);
                    this.toolbar.add(tbar);
                    this.toolbarGroups2d.put(g, tbar);
                    continue;
                }
                this.addSeperator(this.toolbar);
                this.toolbar.add(tbar);
                this.toolbarGroups.put(g, tbar);
            }
        }
        this.toolbar.add(Box.createHorizontalStrut(5));
        this.layoubox.setPreferredSize(new Dimension(120, ControlPanel.buttonDim.height));
        this.layoubox.setMinimumSize(new Dimension(120, ControlPanel.buttonDim.height));
        this.layoubox.setMaximumSize(new Dimension(120, ControlPanel.buttonDim.height));
        this.layoubox.setVisible(false);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.layoubox);
        this.layoubox.addActionListener(this);
        this.allComponentMap.get(RowColFormatButton.class.getName()).setEnabled(false);
        this.allComponentMap.get(RowColFormatButton.class.getName()).setVisible(false);
        this.allComponentMap.get(XpCalibrationAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpCalibrationAction.class.getName()).setVisible(false);
        this.allComponentMap.get(XpMaskOnOffAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpMaskOnOffAction.class.getName()).setVisible(false);
        this.allComponentMap.get(XpSelectMaskAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpSelectMaskAction.class.getName()).setVisible(false);
        this.allComponentMap.get(XpCinePlayPauseAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpCinePlayPauseAction.class.getName()).setVisible(false);
        return this.toolbar;
    }

    private JToolBar getMouseControlsToolBar() {
        List<JButton> mouseMenuOptions;
        CvSeriesDisplayer disp;
        JToolBar toolBarForMouseMenu = new JToolBar("MouseControllerModes");
        toolBarForMouseMenu.setRollover(false);
        toolBarForMouseMenu.setFloatable(false);
        CvMouseController cvMouseController = null;
        if (this.cap.getPort(0) instanceof J3DViewport) {
            cvMouseController = (CvMouseController)((J3DViewport)this.cap.getPort(0)).getMouseController();
        } else if (this.cap.getPort(0) instanceof CvSeriesDisplayer && (disp = (CvSeriesDisplayer)this.cap.getPort(0)).getPort(0).getMouseController() instanceof CvMouseController) {
            cvMouseController = (CvMouseController)disp.getPort(0).getMouseController();
        }
        if (cvMouseController != null && (mouseMenuOptions = new MouseMenuToolBarController(cvMouseController).getMouseMenuOptions()).size() > 0) {
            for (int i = 0; i < mouseMenuOptions.size(); ++i) {
                toolBarForMouseMenu.add(Box.createHorizontalStrut(2));
                JButton button = mouseMenuOptions.get(i);
                toolBarForMouseMenu.add(button);
                toolBarForMouseMenu.add(Box.createHorizontalStrut(2));
                button.addMouseListener(this.mouseFocusListener);
                button.setBackground(UIManager.getColor("P8"));
                button.setPreferredSize(buttonDim);
                button.setMinimumSize(buttonDim);
                button.setMaximumSize(buttonDim);
                button.setBorder(null);
            }
        }
        toolBarForMouseMenu.repaint();
        toolBarForMouseMenu.revalidate();
        return toolBarForMouseMenu;
    }

    private JMenuBar addMenuBar() {
        this.progressBar = new MVImageLoadProgress();
        JMenuBar menuBar = new JMenuBar();
        Object dsIcon = null;
        String appString = this.prop.getProperty(apps);
        String masterMenuCount = this.prop.getProperty(appString + dot + menu + dot + count);
        if (masterMenuCount != null) {
            String menuprefix = appString + dot + menu + dot;
            int menus = Integer.parseInt(masterMenuCount);
            for (int i = 0; i < menus; ++i) {
                String menuString = this.prop.getProperty(menuprefix + i + dot + name);
                String title = "";
                try {
                    title = this.resource.getString(menuString);
                }
                catch (Exception e) {
                    title = menuString;
                }
                JMenu menu = new JMenu(title){

                    @Override
                    public JMenuItem add(JMenuItem menuItem) {
                        return super.add(menuItem);
                    }
                };
                InputMap iMap = menuBar.getInputMap(2);
                Object action = iMap.get(KeyStroke.getKeyStroke("F10"));
                ActionMap actionMap = menuBar.getActionMap();
                actionMap.getParent().remove(action);
                menuBar.add(menu);
                String menugroups = this.prop.getProperty(menuprefix + i + dot + groups);
                if (menugroups == null) continue;
                int menugroupcount = Integer.parseInt(menugroups);
                for (int g = 0; g < menugroupcount; ++g) {
                    if (g != 0) {
                        menu.addSeparator();
                    }
                    String[] modes = new String[]{""};
                    String modeStr = this.prop.getProperty(menuprefix + i + dot + g + dot + mode);
                    if (modeStr != null) {
                        modes = modeStr.split(",");
                    }
                    for (int m = 0; m < modes.length; ++m) {
                        String modeSuffix = modes[m] != null && modes[m].length() > 0 ? dot + modes[m] : "";
                        String submenu = this.prop.getProperty(menuprefix + i + dot + g + dot + count + modeSuffix);
                        if (submenu == null) continue;
                        int submenucount = Integer.parseInt(submenu);
                        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                        for (int j = 0; j < submenucount; ++j) {
                            Icon icon;
                            Action a;
                            String menuAction = this.prop.getProperty(menuprefix + i + dot + g + dot + j + modeSuffix);
                            Object obj = null;
                            if ("ToolBarOnOff".equalsIgnoreCase(menuAction)) {
                                obj = this.actionCache.get("com.ge.med.cse.apps.cdviewer.ui.ControlPanel$ToolBarOnOff");
                                if (obj == null) {
                                    obj = new ToolBarOnOff();
                                }
                            } else if ("DataSelectorOnOff".equalsIgnoreCase(menuAction)) {
                                obj = this.actionCache.get("com.ge.med.cse.apps.cdviewer.ui.ControlPanel$DataSelectorOnOff");
                                if (obj == null) {
                                    obj = new DataSelectorOnOff();
                                }
                            } else if ("ExitAction".equalsIgnoreCase(menuAction)) {
                                obj = this.actionCache.get("com.ge.med.cse.apps.cdviewer.ui.ControlPanel$ExitAction");
                                if (obj == null) {
                                    obj = new ExitAction();
                                }
                            } else {
                                obj = this.actionCache.get(menuAction) != null ? this.actionCache.get(menuAction) : CvUtils.createInstance(menuAction);
                            }
                            JMenuItem menuItem = null;
                            if (obj instanceof Action) {
                                a = obj;
                                menuItem = new JMenuItem(a);
                                dsIcon = a.getValue("SmallIcon");
                                if (dsIcon instanceof ImageIcon) {
                                    icon = ControlPanel.getScaledIcon((ImageIcon)dsIcon);
                                    a.putValue("SmallIcon", icon);
                                }
                            } else if (obj instanceof AbstractButton) {
                                menuItem = new JMenuItem();
                                a = ((AbstractButton)obj).getAction();
                                menuItem.setAction(a);
                                dsIcon = a.getValue("SmallIcon");
                                if (dsIcon instanceof ImageIcon) {
                                    icon = ControlPanel.getScaledIcon((ImageIcon)dsIcon);
                                    a.putValue("SmallIcon", icon);
                                }
                            } else if (obj instanceof MediaViewerHelpPage) {
                                this.help = (MediaViewerHelpPage)obj;
                                this.help.setLocation(300, 100);
                                this.help.setVisible(false);
                                menu.addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mousePressed(MouseEvent e) {
                                        ControlPanel.this.help.setVisible(!ControlPanel.this.help.isVisible());
                                    }
                                });
                            }
                            if (menuItem != null) {
                                if (!"3D".equalsIgnoreCase(modes[m])) {
                                    menu.add(menuItem);
                                }
                                if ("3D".equalsIgnoreCase(modes[m]) || "2D".equalsIgnoreCase(modes[m])) {
                                    items.add(menuItem);
                                }
                            }
                            if (!(obj instanceof PlasmaControl)) continue;
                            PlasmaControl plasmatrl = (PlasmaControl)obj;
                            plasmatrl.setCapable(this.cap);
                        }
                        if (items.size() <= 0) continue;
                        if ("3D".equalsIgnoreCase(modes[m])) {
                            this.menubarGroups3d.put("" + i + g, items);
                            continue;
                        }
                        this.menubarGroups2d.put("" + i + g, items);
                    }
                }
            }
        }
        String str = this.resource.getString("NOT_FOR_CLINICAL_USE");
        menuBar.add(Box.createHorizontalGlue());
        str = str.replaceAll("\\<.*?>", "");
        notForClinicaluse = new JLabel(str);
        notForClinicaluse.setFont(notForClinicaluse.getFont().deriveFont(16.0f));
        notForClinicaluse.setForeground(Color.red);
        notForClinicaluse.setName("notForClinicaluseLabel");
        menuBar.add(notForClinicaluse);
        menuBar.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(this.progressBar);
        panel.setMinimumSize(new Dimension(300, 25));
        panel.setMaximumSize(new Dimension(300, 25));
        this.progressBar.setVisible(false);
        menuBar.add(panel);
        return menuBar;
    }

    public void updateAPSIRL() {
        ViewTypeCapable vcap = (ViewTypeCapable)this.cap.getCapable(ViewTypeCapable.class.getName());
        if (vcap != null) {
            boolean enable = vcap.getViewType(vcap.getViewType()).isObliqueControllable();
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$A").setEnabled(enable);
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$P").setEnabled(enable);
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$S").setEnabled(enable);
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$I").setEnabled(enable);
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$R").setEnabled(enable);
            this.allComponentMap.get("com.ge.med.cse.cvf.j3d.action.J3DViewResetAction$L").setEnabled(enable);
            this.toolbar.revalidate();
            this.toolbar.repaint();
        }
    }

    public void set3DControlPanel() {
        for (int group : this.toolbarGroups2d.keySet()) {
            int index = this.toolbar.getComponentIndex(this.toolbarGroups2d.get(group));
            if (index < 0) continue;
            this.toolbar.remove(index);
            this.toolbar.add((Component)this.toolbarGroups3d.get(group), index);
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
        this.layoubox.setVisible(false);
        this.updateMenubar("3D");
        this.allComponentMap.get(RowColFormatButton.class.getName()).setEnabled(false);
        this.allComponentMap.get(RowColFormatButton.class.getName()).setVisible(false);
        this.allComponentMap.get(XpCalibrationAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpCalibrationAction.class.getName()).setVisible(false);
        this.allComponentMap.get(XpCinePlayPauseAction.class.getName()).setEnabled(false);
        this.allComponentMap.get(XpCinePlayPauseAction.class.getName()).setVisible(false);
    }

    public void set2DControlPanel() {
        for (int group : this.toolbarGroups3d.keySet()) {
            int index = this.toolbar.getComponentIndex(this.toolbarGroups3d.get(group));
            if (index < 0) continue;
            this.toolbar.remove(index);
            this.toolbar.add((Component)this.toolbarGroups2d.get(group), index);
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
        this.layoubox.setVisible(false);
        this.updateMenubar("2D");
        this.allComponentMap.get(RowColFormatButton.class.getName()).setEnabled(true);
        this.allComponentMap.get(RowColFormatButton.class.getName()).setVisible(true);
    }

    private void addMouseControlsToToolBar() {
        this.mouseModes = this.getMouseControlsToolBar();
        for (int group : this.toolbarGroups.keySet()) {
            Component[] allSubComp;
            JToolBar tbar = this.toolbarGroups.get(group);
            for (Component c : allSubComp = tbar.getComponents()) {
                if (!(c instanceof JToolBar) || !"MouseControllerModes".equalsIgnoreCase(c.getName())) continue;
                int index = tbar.getComponentIndex(c);
                tbar.remove(index);
                tbar.add((Component)this.mouseModes, index);
                tbar.revalidate();
                tbar.repaint();
            }
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    private void update3DMouseController() {
        JPopupMenu popmenu = null;
        if (this.cap.getSelectedPort() instanceof T3DViewport) {
            Component[] comps;
            boolean enable;
            CvMouseController cvMC = (CvMouseController)((T3DViewport)this.cap.getSelectedPort()).getMouseController();
            try {
                Field fd = CvMouseController.class.getSuperclass().getDeclaredField("popup_");
                fd.setAccessible(true);
                popmenu = (JPopupMenu)fd.get(cvMC);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean bl = enable = ((J3DViewport)this.cap.getSelectedPort()).getViewType().equalsIgnoreCase("OBLIQUE") || ((J3DViewport)this.cap.getSelectedPort()).getViewType().equalsIgnoreCase("3D");
            if (popmenu != null) {
                Component[] mc;
                for (Component mcomp : mc = popmenu.getComponents()) {
                    if (!(mcomp instanceof JRadioButtonMenuItem) || !this.resource.getString("MouseButtonController.ROTATE").equalsIgnoreCase(((JRadioButtonMenuItem)mcomp).getActionCommand())) continue;
                    mcomp.setEnabled(enable);
                }
                popmenu.revalidate();
                popmenu.repaint();
            }
            for (Component c : comps = this.mouseModes.getComponents()) {
                if (!(c instanceof JButton) || !this.resource.getString("MouseButtonController.ROTATE").equalsIgnoreCase(((JButton)c).getActionCommand())) continue;
                c.setEnabled(enable);
                break;
            }
            this.updateAPSIRL();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange(LAYOUTCHANGE, "", MVAppConstants.SCREEN_LAYOUTS[this.layoubox.getSelectedIndex()]);
    }

    public void updateMenubar(String viewMode) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            ArrayList<JMenuItem> items;
            JMenu menu = this.menuBar.getMenu(i);
            if (menu == null || menu.getItemCount() == 0) continue;
            ArrayList<JMenuItem> toAdd = new ArrayList<JMenuItem>();
            int group = 0;
            boolean remove = false;
            ArrayList<JMenuItem> arrayList = items = "3D".equalsIgnoreCase(viewMode) ? this.menubarGroups3d.get("" + i + group) : this.menubarGroups2d.get("" + i + group);
            if (items != null && items.size() > 0) {
                remove = true;
                for (JMenuItem jMenuItem : items) {
                    toAdd.add(jMenuItem);
                }
            }
            for (int m = 0; m < menu.getItemCount(); ++m) {
                if (menu.getItem(m) == null) {
                    toAdd.add(null);
                    remove = false;
                    ArrayList<JMenuItem> arrayList2 = items = "3D".equalsIgnoreCase(viewMode) ? this.menubarGroups3d.get("" + i + group) : this.menubarGroups2d.get("" + i + ++group);
                    if (items == null || items.size() <= 0) continue;
                    remove = true;
                    for (JMenuItem item2 : items) {
                        toAdd.add(item2);
                    }
                    continue;
                }
                if (remove) continue;
                toAdd.add(menu.getItem(m));
            }
            menu.removeAll();
            for (JMenuItem jMenuItem : toAdd) {
                if (jMenuItem == null) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(jMenuItem);
            }
        }
    }

    public static class ScreenAnnotationDropDown
    extends JComboBox
    implements PlasmaControl {
        private AnnotCapable cap = null;

        @Override
        public void setCapable(Capable s) {
            this.cap = (AnnotCapable)s.getCapable(AnnotCapable.class.getName());
            if (this.cap == null) {
                return;
            }
            this.addItem(MVAppConstants.I18N.PARTIAL);
            this.addItem(MVAppConstants.I18N.FULL);
            this.addItem(MVAppConstants.I18N.NONE);
            this.setToolTipText(MVAppConstants.I18N.ANNOTATION_LEVEL);
            this.setPreferredSize(new Dimension(75, 25));
            this.setMinimumSize(new Dimension(75, 25));
            this.setMaximumSize(new Dimension(75, 25));
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (this.getSelectedIndex() != -1) {
                        if (this.getSelectedIndex() == 0) {
                            cap.setAnnotationGroup("partial", true);
                        } else if (this.getSelectedIndex() == 1) {
                            cap.setAnnotationGroup("all", true);
                        } else {
                            cap.setAnnotationGroup("none", true);
                        }
                        cap.repaint();
                    }
                }
            });
            final ApplicationContext ac = ContextProvider.getApplicationContext("MediaViewer");
            ac.getApplication().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MODE2D".equals(evt.getPropertyName()) || "MODE3D".equals(evt.getPropertyName()) || "data_loading_complete".equals(evt.getPropertyName())) {
                        this.updateAnnotations();
                    } else if ("data_loading_begin".equals(evt.getPropertyName())) {
                        ac.getApplication().addPropertyChangeListener("progressive_data_loading_status", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                int units;
                                if (evt.getNewValue() instanceof Integer && (units = ((Integer)evt.getNewValue()).intValue()) == 1) {
                                    this.updateAnnotations();
                                    ac.getApplication().removePropertyChangeListener("progressive_data_loading_status", this);
                                }
                            }
                        });
                    }
                }
            });
        }

        private void updateAnnotations() {
            int selectedIndex = this.getSelectedIndex();
            this.setSelectedIndex(-1);
            this.cap.setAnnotationVisible(true);
            this.setSelectedIndex(selectedIndex);
        }
    }

    private class ExitAction
    extends BaseAction {
        private ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }

        @Override
        protected String getName() {
            return "XP_CLOSE_APP";
        }
    }

    public class DataSelectorOnOff
    extends BaseAction {
        boolean selection = true;

        @Override
        public void setCapable(Capable cap) {
            super.setCapable(cap);
            cap.addPropertyChangeListener("Cine", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Boolean obj = (Boolean)evt.getNewValue();
                    boolean cineStatus = obj;
                    if (cineStatus) {
                        DataSelectorOnOff.this.setVisible(false);
                    } else {
                        DataSelectorOnOff.this.setVisible(DataSelectorOnOff.this.selection);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selection = !this.selection;
            this.setVisible(this.selection);
        }

        private void setVisible(boolean state) {
            ControlPanel.this.ds.setVisible(state);
        }

        @Override
        protected String getName() {
            return "DATA_SELECTOR";
        }
    }

    private class ToolBarOnOff
    extends BaseAction {
        boolean state = true;

        private ToolBarOnOff() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.state = !this.state;
            ControlPanel.this.toolbar.setVisible(this.state);
            if (this.state) {
                this.putValue("Name", MVAppConstants.I18N.HIDE_TOOLBAR);
            } else {
                this.putValue("Name", MVAppConstants.I18N.SHOW_TOOLBAR);
            }
        }

        @Override
        protected String getName() {
            return "HIDE_TOOLBAR";
        }
    }
}

