/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvCalibrateVc;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.marker.XpMarker;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpCalibrationAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpCalibrationAction.class.getName());
    private XpMarker xm = new CvCalibrateVc();
    PropertyChangeListener calibChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            double propValue = Double.parseDouble("" + evt.getNewValue());
            FrameCapable fcap = XpCalibrationAction.this.getFrameCapable();
            if (propValue != -1.0 && fcap != null) {
                for (int i = 0; i < fcap.getNumFrames(); ++i) {
                    XpImage xpImg = fcap.getFrame(i);
                    XpSlice slice = xpImg.getSlice();
                    slice.pixelSizeX = ((CvCalibrateVc)((XpCalibrationAction)XpCalibrationAction.this).xm).calibratedFactor;
                    slice.pixelSizeY = ((CvCalibrateVc)((XpCalibrationAction)XpCalibrationAction.this).xm).calibratedFactor;
                }
            }
        }
    };

    @Override
    protected String getName() {
        return "XP_CALIBRATE";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpDicomObject dicomObj;
        boolean pixelSpacing;
        XpImage img;
        logger.log(Level.INFO, "XpCalibrationAction.actionPerformed()");
        XjVolumeCapable volCap = (XjVolumeCapable)this.getCapable().getCapable(XjVolumeCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (!(volCap != null || frameCapable != null && CvUtils.measurementsValid(frameCapable.getFrame()))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        if (frameCapable != null && (img = frameCapable.getFrame()) instanceof XpDicomObject && (pixelSpacing = CvUtils.isPixelSpacingPresent(dicomObj = (XpDicomObject)((Object)img)))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        JComponent comp = this.getSelectedMainViewport();
        if (comp instanceof XpFrameVisualizer) {
            ((XpFrameVisualizer)comp).getMedicalImageVc().getImageVc().add(this.xm);
            this.xm.removePropertyChangeListener("calibration_done_property", this.calibChangeListener);
            this.xm.addPropertyChangeListener("calibration_done_property", this.calibChangeListener);
            comp.revalidate();
        }
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
    }
}

