/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvRectangularRoi;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class XpEllipseROIAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpEllipseROIAction.class.getName());
    private static final boolean imageCalibration = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.imageCalibration", "false"));
    private boolean calibrated = true;

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
    }

    @Override
    protected String getName() {
        return "XP_ELLIPSE_ROI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpImage img;
        JComponent port;
        logger.log(Level.INFO, "XpEllipseROIAction.actionPerformed()");
        XjVolumeCapable volCap = (XjVolumeCapable)this.getCapable().getCapable(XjVolumeCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (!(volCap != null || frameCapable != null && CvUtils.measurementsValid(frameCapable.getFrame()))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        if (imageCalibration && (port = this.getSelectedViewport()) != null && !(port instanceof T3DCapable) && port instanceof FrameOwner && (img = ((FrameOwner)((Object)port)).getFrame()) instanceof XpDicomObject) {
            XpDicomObject dicomObj = (XpDicomObject)((Object)img);
            boolean bl = this.calibrated = !CvUtils.needCalibration(dicomObj);
        }
        if (imageCalibration && !this.calibrated) {
            String message = CvUtils.getResourceBundle().getString("ROI_NOT_SUPPORTED");
            JComponent comp = this.getSelectedMainViewport();
            JOptionPane.showMessageDialog(comp, message);
        } else {
            Shape roiShape = null;
            String[] params = this.getParams();
            try {
                if (params != null && params.length > 0) {
                    roiShape = this.parseParams(params);
                    this.setParams(null);
                } else {
                    roiShape = CvUtils.getROIUtils().getROIPosition(this.getROICapable(), ROIUtils.ROITYPE.ELLIPSE);
                }
                if (roiShape != null) {
                    this.getROICapable().add(new CvRectangularRoi.Ellipse((Ellipse2D)roiShape));
                } else {
                    this.getLogger().log(Level.WARNING, "Ellipse Shape returned NULL.");
                }
            }
            catch (Exception exp) {
                this.getLogger().log(Level.WARNING, "Exception during the ellipse roi add", exp);
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            }
        }
    }

    private Shape parseParams(String[] st) {
        Ellipse2D.Double s = null;
        Point2D[] pts = null;
        if (st.length != 8) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
        } else {
            try {
                Double[] dpts = new Double[8];
                for (int i = 0; i < st.length; ++i) {
                    dpts[i] = Double.parseDouble(st[i]);
                }
                pts = new Point2D[]{new Point2D.Double(dpts[0], dpts[1]), new Point2D.Double(dpts[2], dpts[3]), new Point2D.Double(dpts[4], dpts[5]), new Point2D.Double(dpts[6], dpts[7])};
                pts[0] = CvUtils.getValidImagePoint(pts[0], this.getROICapable());
                pts[1] = CvUtils.getValidImagePoint(pts[1], this.getROICapable());
                pts[2] = CvUtils.getValidImagePoint(pts[2], this.getROICapable());
                pts[3] = CvUtils.getValidImagePoint(pts[3], this.getROICapable());
                double minX = pts[0].getX();
                double maxX = pts[0].getX();
                double minY = pts[0].getY();
                double maxY = pts[0].getY();
                for (int i = 1; i < 4; ++i) {
                    if (minX > pts[i].getX()) {
                        minX = pts[i].getX();
                    }
                    if (maxX < pts[i].getX()) {
                        maxX = pts[i].getX();
                    }
                    if (minY > pts[i].getY()) {
                        minY = pts[i].getY();
                    }
                    if (!(maxY < pts[i].getY())) continue;
                    maxY = pts[i].getY();
                }
                int width = Math.abs((int)(maxX - minX));
                int height = Math.abs((int)(maxY - minY));
                s = new Ellipse2D.Double(minX, minY, width, height);
            }
            catch (Exception e) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.getLogger().log(Level.WARNING, "Invalid Ellipse Matte ROI arguments", e);
            }
        }
        return s;
    }
}

