/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpHorizontalTickAction
extends BaseAction {
    boolean isHorizontalTickShown = false;

    @Override
    protected String getName() {
        return "XP_HORIZONTAL_TICK";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpImage img;
        if (this.getCapable() != null && this.getCapable() instanceof FrameCapable && !CvUtils.measurementsValid(img = ((FrameCapable)((Object)this.getCapable())).getFrame())) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        XpTickMarkCapable tickCap = (XpTickMarkCapable)this.getCapable().getCapable(XpTickMarkCapable.class.getName());
        String[] params = this.getParams();
        if (e.getActionCommand().equals("tickmark_horizontal")) {
            this.isHorizontalTickShown = !this.isHorizontalTickShown;
        } else if (params != null && params.length > 0) {
            if (params[0].toLowerCase().equals("on")) {
                this.isHorizontalTickShown = true;
            } else if (params[0].toLowerCase().equals("off")) {
                this.isHorizontalTickShown = false;
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.getLogger().log(Level.WARNING, "Invalid command argument");
            }
            this.setParams(null);
        }
        try {
            if (this.isHorizontalTickShown) {
                tickCap.addTickMark(1);
            } else {
                tickCap.removeTickMark(1);
            }
            XPDisplayPrefsUtils.updateHorizontalTicksStatus(this.isHorizontalTickShown);
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during vertical tick mark addition , {0}", new Object[]{exp});
        }
    }
}

