/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpLoadESIAction
extends BaseAction {
    private static final String esiregexpr = "(((e?)(\\d+)\\s*[\\s*\\/])?\\s*((s?)(\\d+)\\s*[\\s*\\/]))?\\s*(i?)(\\d+)\\s*";
    private static final String eregexpr = "e(\\d+)\\s*";
    private static final String sregexpr = "s(\\d+)\\s*";
    private static final String esregexpr = "e(\\d+)\\s*[\\s*\\/]\\s*s(\\d+)\\s*";
    private static final String siregexpr = "(((s?)(\\d+)\\s*[\\s*\\/]))?\\s*(i?)(\\d+)\\s*";
    private String ex = "";
    int se = -1;
    int im = -1;
    private DMSession sess = null;
    private XpMedicalImage img = null;
    private static final XpDicomElement eid = new XpDicomElement(32, 16);
    private static final XpDicomElement euid = new XpDicomElement(32, 13);
    private Thread loaderThread = null;
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_XpLoadESIAction");
    private static final boolean isExamEnabled = CvPropertiesManager.getBoolean("cvf.examnavigation", true);

    @Override
    protected String getName() {
        return "XP_LOAD_ESI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.INFO, "{0} begin", tln);
        this.getLogger().log(Level.INFO, "{0} Exam selection not enabled", tln);
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            this.getLogger().log(Level.INFO, "{0} An ESI load action already processing", tln);
            return;
        }
        Capable cap = this.getCapable();
        if (cap == null) {
            return;
        }
        CineCapable cc = (CineCapable)cap.getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.getLogger().log(Level.INFO, "{0} Cine on, cannot process load esi request", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CINE_ON_IMGLOAD_FAILED"));
            return;
        }
        this.ex = "";
        this.se = -1;
        this.im = -1;
        String command2 = e.getActionCommand();
        if (this.validateCommand(command2)) {
            final String cmd = command2;
            JComponent port = null;
            if (this.getCapable() instanceof XPscreen) {
                port = ((XPscreen)this.getCapable()).getSelectedPort();
            } else {
                SelectionCapable selCap = (SelectionCapable)cap.getCapable(SelectionCapable.class.getName());
                port = selCap.getViewportComponent(selCap.getComponentSelection());
            }
            final JComponent c = port;
            if (c == null) {
                this.getLogger().log(Level.INFO, "{0} No selected port found", tln);
                return;
            }
            this.loaderThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XpLoadESIAction.this.loadESI(cmd, c);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        XpLoadESIAction.this.getLogger().log(Level.SEVERE, "{0} Exception in loadESI, " + ex.toString(), tln);
                        XpLoadESIAction.this.getLogger().log(UserMessageLevel.USER_MSG, "");
                    }
                }
            });
            this.loaderThread.setName("Load ESI action thread");
            this.loaderThread.start();
        } else {
            this.getLogger().log(Level.SEVERE, "{0} Invalid command : " + command2, tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_CMD"));
        }
    }

    public boolean validateCommand(String cmd) {
        boolean refvp;
        JComponent port = null;
        if (this.getCapable() instanceof XPscreen) {
            port = ((XPscreen)this.getCapable()).getSelectedPort();
        }
        boolean bl = refvp = port != null && "true".equalsIgnoreCase((String)port.getClientProperty("reference_viewport"));
        if (isExamEnabled && !refvp) {
            return cmd.matches(esiregexpr) || cmd.matches(eregexpr) || cmd.matches(sregexpr) || cmd.matches(esregexpr);
        }
        return cmd.matches(siregexpr) || cmd.matches(sregexpr);
    }

    private boolean parseCommand(String cmd) {
        boolean refvp;
        JComponent port = null;
        if (this.getCapable() instanceof XPscreen) {
            port = ((XPscreen)this.getCapable()).getSelectedPort();
        }
        boolean bl = refvp = port != null && "true".equalsIgnoreCase((String)port.getClientProperty("reference_viewport"));
        if (isExamEnabled && !refvp) {
            return this.parseESI(cmd) || this.parseES(cmd) || this.parseE(cmd) || this.parseS(cmd);
        }
        return this.parseSI(cmd) || this.parseS(cmd);
    }

    private boolean parseE(String cmd) {
        Pattern p = Pattern.compile(eregexpr, 2);
        Matcher m = p.matcher(cmd);
        if (m.matches()) {
            try {
                String exam;
                this.ex = exam = m.group(1);
                System.err.println("E" + this.ex);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseS(String cmd) {
        Pattern p = Pattern.compile(sregexpr, 2);
        Matcher m = p.matcher(cmd);
        if (m.matches()) {
            try {
                String series = m.group(1);
                this.se = Integer.parseInt(series);
                System.err.println("S" + this.se);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseES(String cmd) {
        Pattern p = Pattern.compile(esregexpr, 2);
        Matcher m = p.matcher(cmd);
        if (m.matches()) {
            try {
                String exam;
                this.ex = exam = m.group(1);
                String series = m.group(2);
                this.se = Integer.parseInt(series);
                System.err.println("E" + this.ex + "/S" + this.se);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseESI(String cmd) {
        Pattern p = Pattern.compile(esiregexpr, 2);
        Matcher m = p.matcher(cmd);
        if (m.matches()) {
            try {
                String series;
                String exam = m.group(4);
                if (exam != null) {
                    this.ex = exam;
                }
                if ((series = m.group(7)) != null) {
                    this.se = Integer.parseInt(series);
                }
                String image = m.group(9);
                this.im = Integer.parseInt(image);
                System.err.println("E" + this.ex + "/S" + this.se + "/I" + this.im);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseSI(String cmd) {
        Pattern p = Pattern.compile(siregexpr, 2);
        Matcher m = p.matcher(cmd);
        if (m.matches()) {
            try {
                String series = m.group(4);
                if (series != null) {
                    this.se = Integer.parseInt(series);
                }
                String image = m.group(7);
                this.im = Integer.parseInt(image);
                System.err.println("S" + this.se + "/I" + this.im);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private synchronized boolean loadESI(String cmd, JComponent selport) {
        if (!this.parseCommand(cmd)) {
            this.getLogger().log(Level.SEVERE, "{0} Invalid ESI command : " + cmd, tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_CMD"));
            return false;
        }
        XpLinkPortCapable lpcap = (XpLinkPortCapable)this.getCapable().getCapable(XpLinkPortCapable.class.getName());
        if (lpcap != null && lpcap.getPortsLinked()) {
            this.getLogger().log(Level.SEVERE, "{0} Unlink ports to load a different exam/series", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("UNLINK_PORT_TOLOAD_EXAM"));
            return false;
        }
        this.img = null;
        boolean status = true;
        if (selport instanceof XpViewport) {
            XpViewport port = (XpViewport)selport;
            if (!(port instanceof XpCompositePort) && !(port instanceof XpImageViewport)) {
                this.getLogger().log(Level.SEVERE, "{0} selected port is not valid, " + port, tln);
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
                return false;
            }
            if (port instanceof FrameCapable && ((FrameCapable)((Object)port)).getFrame() instanceof XpMedicalImage) {
                this.img = (XpMedicalImage)((FrameCapable)((Object)port)).getFrame();
            }
            if (this.img == null && this.ex.isEmpty()) {
                this.getLogger().log(Level.SEVERE, "{0} Selected port is empty and no exam number specified in the esi command, " + cmd, tln);
                return false;
            }
            this.sess = CvUtils.getDMSystem().getLocalDB();
            if (this.sess == null) {
                this.getLogger().log(Level.SEVERE, "{0} DMSession null", tln);
                return false;
            }
            if (!this.ex.isEmpty() && this.se == -1) {
                status = this.loadbyE(port);
            } else if (!this.ex.isEmpty() && this.se != -1) {
                status = this.loadbyES(port);
            } else if (this.ex.isEmpty() && this.se != -1) {
                status = this.loadbyS(port);
            }
        }
        if (selport instanceof FramePositioningCapable) {
            if (status) {
                status = this.loadImage((FramePositioningCapable)((Object)selport));
            }
            selport.repaint();
            return status;
        }
        this.getLogger().log(Level.SEVERE, "{0} selected port is not valid, " + selport, tln);
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
        return false;
    }

    private boolean loadbyE(XpViewport port) {
        String query = "";
        if (this.sess != null) {
            this.getLogger().log(Level.INFO, "{0} Start loading by Exam number, " + this.ex, tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_EX"), "MSGUITIMEOUT=0");
            query = query + "(0x0020, 0x0010) = " + this.ex;
            DMObject study = null;
            DMObject[] objs = this.sess.getRelated("study", new DMQuery(query));
            if (objs != null && objs.length != 0) {
                study = objs[0];
            }
            Object sel = null;
            if (study != null) {
                Object[] sers = study.getRelated("series");
                if (sers != null && sers.length > 0) {
                    CvUtils.sortSeriesByBase(sers);
                    for (int i = 0; i < sers.length; ++i) {
                        if (!CvImageLoader.getInstance().isValid(new DMObject[]{sers[0]})) continue;
                        sel = sers[0];
                        break;
                    }
                }
                CvUtils.getDMSystem().setSelection(new DMObject[]{sel});
                CvImageLoader.getInstance().loadData(true);
                this.getLogger().log(UserMessageLevel.USER_MSG, "");
                return true;
            }
            this.getLogger().log(Level.SEVERE, "{0} Exam " + this.ex + " not found", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, "E" + this.ex + CvUtils.getResourceBundle().getString("NO_ES_FOUND"));
            return false;
        }
        this.getLogger().log(Level.SEVERE, "{0} DMSession null", tln);
        return false;
    }

    private boolean loadbyES(XpViewport port) {
        String query = "";
        if (this.sess != null) {
            this.getLogger().log(Level.INFO, "{0} Start loading by Exam/Series number, " + this.ex + "/" + this.se, tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_ES"), "MSGUITIMEOUT=0");
            query = query + "(0x0020, 0x0010) = " + this.ex + " AND (0x0020, 0x0011) = " + this.se;
            DMObject series = null;
            DMObject[] objs = this.sess.getRelated("series", new DMQuery(query));
            if (objs != null && objs.length != 0) {
                series = objs[0];
            }
            if (series != null) {
                CvUtils.getDMSystem().setSelection(new DMObject[]{series});
                CvImageLoader.getInstance().loadData(true);
                this.getLogger().log(UserMessageLevel.USER_MSG, "");
                return true;
            }
            this.getLogger().log(Level.SEVERE, "{0} Exam/Series " + this.ex + "/" + this.se + " not found", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, "E" + this.ex + "/S" + this.se + CvUtils.getResourceBundle().getString("NO_ES_FOUND"));
            return false;
        }
        this.getLogger().log(Level.SEVERE, "{0} DMSession null", tln);
        return false;
    }

    private boolean loadbyS(XpViewport port) {
        String query = "";
        if (this.img != null && this.sess != null) {
            this.getLogger().log(Level.INFO, "{0} Start loading by Series number, " + this.se, tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("LOAD_SE"), "MSGUITIMEOUT=0");
            this.img.getValue(euid);
            this.img.getValue(eid);
            query = query + "(0x0020, 0x000D) = " + euid.getStringValue();
            if (eid != null && eid.getStringValue().trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + eid.getStringValue();
            }
            query = query + " AND (0x0020, 0x0011) = " + this.se;
            DMObject series = null;
            DMObject[] objs = this.sess.getRelated("series", new DMQuery(query));
            if (objs != null && objs.length != 0) {
                for (int i = 0; i < objs.length; ++i) {
                    if (!CvImageLoader.getInstance().isValid(new DMObject[]{objs[i]})) continue;
                    series = objs[i];
                    break;
                }
                if (series == null) {
                    this.getLogger().log(Level.SEVERE, "{0} Series " + this.se + " type is not supported", tln);
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED"));
                    return false;
                }
                CvUtils.getDMSystem().setSelection(new DMObject[]{series});
                CvImageLoader.getInstance().loadData(true);
                this.getLogger().log(UserMessageLevel.USER_MSG, "");
                return true;
            }
            this.getLogger().log(Level.SEVERE, "{0} Series " + this.se + " not found", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, "S" + this.se + CvUtils.getResourceBundle().getString("NO_ES_FOUND"));
            return false;
        }
        this.getLogger().log(Level.SEVERE, "{0} DMSession null or selected viewport is empty", tln);
        return false;
    }

    private boolean loadImage(final FramePositioningCapable port) {
        if (port != null && port instanceof FrameCapable) {
            int index = 0;
            if (this.im != -1) {
                int sel;
                int numImgs = port.getNumFrames();
                for (int i = 0; i < numImgs; ++i) {
                    int sn2 = DicomUtils.getImageNumber((XpMedicalImage)((FrameCapable)((Object)port)).getFrame(i));
                    if (this.im != sn2) continue;
                    index = i;
                    break;
                }
                if (port instanceof SelectionCapable && (sel = ((SelectionCapable)((Object)port)).getComponentSelection()) >= 0) {
                    index -= sel;
                }
            }
            final int idx = index;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    port.setFrameIndex(idx);
                }
            });
            return true;
        }
        return false;
    }
}

