/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvPointRoi;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.logging.Level;

public class XpPointROIAction
extends BaseAction {
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_exportImageAction");

    @Override
    protected String getName() {
        return "XP_POINT_ROI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.INFO, "{0} begin", tln);
        XjVolumeCapable volCap = (XjVolumeCapable)this.getCapable().getCapable(XjVolumeCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (!(volCap != null || frameCapable != null && CvUtils.measurementsValid(frameCapable.getFrame()))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            if (Integer.parseInt(params[0]) >= 0) {
                Point2D pt = this.parseParams(params);
                this.setParams(null);
                if (pt != null) {
                    CvPointRoi ptRoi = null;
                    if (this.getSelectedViewport() instanceof T3DViewport) {
                        ptRoi = new CvPointRoi(pt.getX(), pt.getY(), 1.0, 1.0);
                        System.out.println("Point ROI for 3D");
                    } else {
                        ptRoi = new CvPointRoi(pt);
                    }
                    ptRoi.setSelected(true);
                    this.getROICapable().add(ptRoi);
                } else {
                    this.getLogger().log(Level.WARNING, "Points returned NULL.");
                }
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        } else {
            Point2D pt = CvUtils.getCenterPointOfViewPort(this.getCapable());
            if (pt != null) {
                if (this.getSelectedViewport() instanceof T3DViewport) {
                    this.getROICapable().add(new CvPointRoi(pt.getX(), pt.getY(), 10.0, 10.0));
                    System.out.println("Point ROI for 3D");
                } else {
                    this.getROICapable().add(new CvPointRoi(pt));
                }
            } else {
                this.getLogger().log(Level.WARNING, "Points returned NULL.");
            }
        }
    }

    private Point2D parseParams(String[] st) {
        Point2D pt = null;
        if (st.length != 2) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
        } else {
            try {
                Double[] dpts = new Double[2];
                for (int i = 0; i < st.length; ++i) {
                    dpts[i] = Double.parseDouble(st[i]);
                }
                pt = new Point2D.Double(dpts[0], dpts[1]);
                pt = CvUtils.getValidImagePoint(pt, this.getROICapable());
            }
            catch (Exception e) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"), e);
            }
        }
        return pt;
    }
}

