/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvPolygonRoi;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class XpPolygonROIAction
extends BaseAction
implements ComponentCreationListener {
    private static final Logger logger = Logger.getLogger(XpPolygonROIAction.class.getName());
    private static final boolean imageCalibration = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.imageCalibration", "false"));
    private AbstractButton button = null;
    private boolean calibrated = true;

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
    }

    @Override
    protected String getName() {
        return "XP_POLYGON_ROI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpImage img;
        JComponent port;
        logger.log(Level.INFO, "XpPolygonROIAction.actionPerformed()");
        XjVolumeCapable volCap = (XjVolumeCapable)this.getCapable().getCapable(XjVolumeCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (!(volCap != null || frameCapable != null && CvUtils.measurementsValid(frameCapable.getFrame()))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        if (imageCalibration && (port = this.getSelectedViewport()) != null && !(port instanceof T3DCapable) && port instanceof FrameOwner && (img = ((FrameOwner)((Object)port)).getFrame()) instanceof XpDicomObject) {
            XpDicomObject dicomObj = (XpDicomObject)((Object)img);
            boolean bl = this.calibrated = !CvUtils.needCalibration(dicomObj);
        }
        if (imageCalibration && !this.calibrated) {
            String message = CvUtils.getResourceBundle().getString("ROI_NOT_SUPPORTED");
            JComponent comp = this.getSelectedMainViewport();
            JOptionPane.showMessageDialog(comp, message);
        } else {
            Point2D[] pts = null;
            String[] params = this.getParams();
            if (params != null && params.length > 0) {
                if (Integer.parseInt(params[0]) > 2) {
                    pts = this.parseParams(params);
                    this.setParams(null);
                    if (pts != null) {
                        CvPolygonRoi poly = new CvPolygonRoi(pts);
                        poly.setClosed(true);
                        this.getROICapable().add(poly);
                    } else {
                        this.getLogger().log(Level.WARNING, "Angle Points returned NULL.");
                    }
                } else {
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                }
            } else {
                if (e.getSource() instanceof AbstractButton) {
                    this.button = (AbstractButton)e.getSource();
                    this.button.setEnabled(false);
                }
                try {
                    ComponentCreator cc = CvPolygonRoi.getComponentCreator();
                    cc.addComponentCreationListener(this);
                    ComponentCapable compCap = this.getComponentCapable();
                    compCap.setAutoRepaint(true);
                    compCap.setComponentCreator(cc);
                }
                catch (Exception exp) {
                    this.getLogger().log(Level.WARNING, "Error during polygon roi action creation, ", exp);
                }
            }
        }
    }

    @Override
    public void componentAddedNotification(ComponentCapable cc) {
        if (this.button != null) {
            this.button.setEnabled(true);
        }
    }

    @Override
    public void componentCreationNotification(ComponentCapable cc) {
    }

    private Point2D[] parseParams(String[] st) {
        Point2D[] pts = null;
        if (st.length < 5) {
            this.getLogger().log(Level.WARNING, "Arguments should not be less than 4.");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
        } else {
            try {
                int totalpts = Integer.parseInt(st[0]);
                if (totalpts != 0 && st.length >= 2 * totalpts + 1) {
                    int i;
                    Double[] dpts = new Double[2 * totalpts];
                    for (i = 1; i <= totalpts * 2; ++i) {
                        dpts[i - 1] = Double.parseDouble(st[i]);
                    }
                    pts = new Point2D[totalpts];
                    for (i = 0; i < totalpts; ++i) {
                        pts[i] = new Point2D.Double(dpts[2 * i], dpts[2 * i + 1]);
                        pts[i] = CvUtils.getValidImagePoint(pts[i], this.getROICapable());
                    }
                } else {
                    this.getLogger().log(Level.WARNING, "Invalid Argument for Polygon ROI");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Invalid Argument for Polygon ROI", e);
            }
        }
        return pts;
    }
}

