/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.PropagationCapable;
import com.ge.med.idc.SelectionCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpPropagateROIAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_PROPAGATE_ROI";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String[] params = this.getParams();
        try {
            SelectionCapable scap = this.getSelectionCapable();
            PropagationCapable cap = (PropagationCapable)((Object)scap.getViewportComponent(scap.getComponentSelection()));
            if (params == null) {
                cap.setPropagationMode("PROPAGATION_MODE_FORWARD");
                cap.propagateROI();
                return;
            }
            if (params.length == 1) {
                if (params[0].equalsIgnoreCase("a")) {
                    cap.setPropagationMode("PROPAGATION_MODE_ALL");
                    cap.propagateROI();
                    return;
                }
                this.getLogger().log(Level.WARNING, "Invalid command option");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
                return;
            }
            if (params.length != 2) {
                this.getLogger().log(Level.WARNING, "Invalid command option");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
                return;
            }
            if (params[0].equalsIgnoreCase("i")) {
                String[] imgno = params[1].split("-");
                if (imgno.length != 2) return;
                int from = Integer.parseInt(imgno[0].trim());
                int to = Integer.parseInt(imgno[1].trim());
                cap.setPropagationMode("PROPAGATION_MODE_NONE");
                cap.propagateROI(from, to);
                return;
            }
            this.getLogger().log(Level.WARNING, "Invalid command option");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
            return;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Exception during propagate command", ex);
        }
    }
}

