/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ScreenSaveUtil;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpScreenSaveAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_screenSaveAction");
    private BufferedImage scrnSaveimage;
    private XpDicomElement examid = new XpDicomElement(32, 16);
    private XpDicomElement examuid = new XpDicomElement(32, 13);
    private XpDicomElement imageuid = new XpDicomElement(8, 24);

    @Override
    public String getName() {
        return "XP_SCREEN_SAVE";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.INFO, "{0} begin", tln);
        String status = this.doScreenSave();
        this.getLogger().log(Level.INFO, " {0} end", tln);
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString(status));
    }

    private String doScreenSave() {
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            this.getLogger().log(Level.WARNING, "Invalid argument.");
            this.setParams(null);
            return "INV_PARAM";
        }
        JComponent port = this.getSelectedMainViewport();
        DMObject dmObject = null;
        try {
            if (port != null) {
                XpImage frame = null;
                if (port instanceof FrameOwner && (frame = ((FrameOwner)((Object)port)).getFrame()) instanceof XpDicomObject) {
                    XpDicomObject img = (XpDicomObject)((Object)frame);
                    if (img == null) {
                        this.getLogger().log(Level.INFO, "{0} SEV5 No Image", tln);
                        return "SCNSAVE_FAIL";
                    }
                    img.getValue(this.examid);
                    img.getValue(this.examuid);
                    img.getValue(this.imageuid);
                    String query = "(0x0020, 0x000D) = " + this.examuid.value;
                    if (this.examid.value != null && this.examid.getStringValue().trim().length() > 0) {
                        query = query + " AND (0x0020, 0x0010) = " + this.examid.value;
                    }
                    query = query + " AND (0x0008, 0x0018) = " + this.imageuid.value;
                    DMObject[] dmo = CvUtils.getDMSystem().getLocalDB().getRelated("image", new DMQuery(query));
                    if (dmo != null && dmo.length > 0) {
                        dmObject = dmo[0];
                    }
                } else {
                    dmObject = CvUtils.getDMSystem().getRepresentativeDMObjet();
                }
                if (dmObject == null) {
                    this.getLogger().log(Level.WARNING, "Representative DMObject is NULL !!!");
                    return "SCNSAVE_FAIL";
                }
                InputStream is = ScreenSaveUtil.getScreenCapture(dmObject, port, 512, 512, null);
                if (is == null) {
                    this.getLogger().log(Level.WARNING, "Exception during install : Input stream is NULL while screen capture!!!");
                    return "SCNSAVE_FAIL";
                }
                CvUtils.getDMSystem().getLocalDB().install(is);
                return "SCNSAVE_DONE";
            }
            this.getLogger().log(Level.WARNING, "No Port is selected");
            return "SCNSAVE_FAIL";
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during Screen Save creation", new Object[]{exp});
            return "SCNSAVE_FAIL";
        }
    }
}

