/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpTickMarkAction
extends BaseAction {
    boolean isVerticalTickShown = false;
    boolean isHorizontalTickShown = false;

    @Override
    protected String getName() {
        return "XP_TICKMARK";
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        XpImage img;
        if (this.getCapable() != null && this.getCapable() instanceof FrameCapable && !CvUtils.measurementsValid(img = ((FrameCapable)((Object)this.getCapable())).getFrame())) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        XpTickMarkCapable tickCap = (XpTickMarkCapable)this.getCapable().getCapable(XpTickMarkCapable.class.getName());
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            if (params[0].toLowerCase().equals("on")) {
                this.isVerticalTickShown = true;
                this.isHorizontalTickShown = true;
            } else if (params[0].toLowerCase().equals("off")) {
                this.isVerticalTickShown = false;
                this.isHorizontalTickShown = false;
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            }
        } else {
            this.isHorizontalTickShown = !this.isHorizontalTickShown;
            this.isVerticalTickShown = !this.isVerticalTickShown;
        }
        try {
            if (this.isHorizontalTickShown) {
                tickCap.addTickMark(1);
            } else {
                tickCap.removeTickMark(1);
            }
            if (this.isVerticalTickShown) {
                tickCap.addTickMark(0);
            } else {
                tickCap.removeTickMark(0);
            }
            this.setParams(null);
            XPDisplayPrefsUtils.updateHorizontalTicksStatus(this.isHorizontalTickShown);
            XPDisplayPrefsUtils.updateVerticalTicksStatus(this.isVerticalTickShown);
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during tick mark addition , {0}", new Object[]{exp});
        }
    }
}

