/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import com.ge.med.terra.jami.annotation.XpSimpleAnnotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class XpApdAnnotationGenerator
implements XpAnnotationGenerator {
    private static final int MAX_ANNOTATION = Integer.parseInt(XpPropertiesManager.getProperty("jami.apd.maxannotation", "150"));
    private int language = 0;
    private Map map = new HashMap(200);
    private Properties props = new Properties();
    private XpDicomElement modElement = new XpDicomElement(8, 96);
    private XpDicomElement imgType = new XpDicomElement(8, 8);
    private XpDicomElement burntInAnnot = new XpDicomElement(40, 769);
    private XpDicomElement sopClassUID = new XpDicomElement(8, 22);
    private Map tagMap = new HashMap();

    public XpApdAnnotationGenerator() {
        this.props.setProperty("MR", "com.ge.med.StdAnno.MRApStyle");
        this.props.setProperty("CT_REGULAR", "com.ge.med.StdAnno.CTApStyle");
        this.props.setProperty("CT_SCOUT", "com.ge.med.StdAnno.SCApStyle");
        this.props.setProperty("PT", "com.ge.med.StdAnno.PETApStyle");
    }

    @Override
    public void setProperties(Properties p) {
        if (p != null) {
            this.props.putAll((Map<?, ?>)p);
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public final void setLanguage(String lang) {
        if (lang.startsWith("en")) {
            this.setLanguage(0);
        } else if (lang.startsWith("es")) {
            this.setLanguage(1);
        } else if (lang.startsWith("fr")) {
            this.setLanguage(2);
        } else if (lang.startsWith("de")) {
            this.setLanguage(4);
        } else if (lang.startsWith("it")) {
            this.setLanguage(3);
        } else if (lang.startsWith("pt")) {
            this.setLanguage(5);
        } else if (lang.startsWith("ja")) {
            this.setLanguage(9);
        } else if (lang.startsWith("kr")) {
            this.setLanguage(8);
        } else if (lang.startsWith("ru")) {
            this.setLanguage(10);
        } else if (lang.startsWith("zh")) {
            this.setLanguage(7);
        } else if (lang.startsWith("nb")) {
            this.setLanguage(6);
        }
    }

    public void setLanguage(int language) {
        if (language == this.language) {
            return;
        }
        this.language = language;
        Set c = this.map.entrySet();
        for (Map.Entry entry : c) {
            Object o = entry.getValue();
            if (o instanceof TimeStampValue) {
                TimeStampValue tsv = (TimeStampValue)o;
                o = tsv.getAnnotationModel();
            }
            if (!(o instanceof XpApdAnnotation)) continue;
            XpApdAnnotation aa = (XpApdAnnotation)o;
            aa.setLanguage(language);
            String lang = "en_US";
            switch (language) {
                case 2: {
                    lang = "fr_FR";
                    break;
                }
                case 0: {
                    lang = "en_US";
                    break;
                }
                case 1: {
                    lang = "es_MX";
                    break;
                }
                case 3: {
                    lang = "it_IT";
                    break;
                }
                case 4: {
                    lang = "de_DE";
                    break;
                }
                case 5: {
                    lang = "pt_BR";
                    break;
                }
                case 9: {
                    lang = "ja";
                    break;
                }
                case 8: {
                    lang = "kr";
                    break;
                }
                case 10: {
                    lang = "ru_RU";
                    break;
                }
                case 7: {
                    lang = "zh";
                    break;
                }
                case 6: {
                    lang = "nb_NO";
                }
            }
            aa.setProperty("lang", lang);
        }
    }

    public int getLanguage() {
        return this.language;
    }

    protected XpAnnotationModel get(Object key, XpDicomObject dobj) {
        TimeStampValue tsv = (TimeStampValue)this.map.get(key);
        if (tsv != null) {
            tsv.updateTimeStamp();
            return tsv.getAnnotationModel();
        }
        if (dobj != null) {
            ApStyle aps = null;
            String typeKey = this.getImageTypeKey(dobj);
            if (typeKey != null) {
                if (typeKey.equals("SSAVE")) {
                    return new XpSimpleAnnotation(dobj, 1);
                }
                String annotClass = this.props.getProperty(typeKey);
                if (annotClass != null) {
                    aps = XpApdAnnotation.createApStyle(annotClass);
                }
            }
            XpAnnotationModel newAnnotationModel = null;
            if (aps != null) {
                aps.reset();
                XpApdAnnotation apdAnnot = this.createApdAnnotation(dobj, aps);
                apdAnnot.setLanguage(this.language);
                newAnnotationModel = apdAnnot;
            } else {
                newAnnotationModel = new XpSimpleAnnotation(dobj);
            }
            TimeStampValue new_tsv = new TimeStampValue(newAnnotationModel);
            this.map.put(key, new_tsv);
            int len = this.map.size();
            if (len > MAX_ANNOTATION) {
                Object todelete = null;
                long min_time = new_tsv.getTimeStamp();
                for (Map.Entry me : this.map.entrySet()) {
                    TimeStampValue tv = (TimeStampValue)me.getValue();
                    if (tv.getTimeStamp() >= min_time) continue;
                    min_time = tv.getTimeStamp();
                    todelete = me.getKey();
                }
                if (todelete != null) {
                    this.map.remove(todelete);
                }
            }
            return newAnnotationModel;
        }
        return null;
    }

    public XpAnnotationModel getAnnotation(XpDicomObject dobj) {
        return this.get(dobj, dobj);
    }

    @Override
    public XpAnnotationModel getAnnotation(XpImage mi, XpDicomObject dobj) {
        return this.get(mi, dobj);
    }

    protected XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
        return new XpApdAnnotation(dobj, aps);
    }

    public String getImageTypeKey(XpDicomObject dobj) {
        dobj.getValue(this.modElement);
        if (this.modElement.value != null) {
            String modality = this.modElement.value.toString().toUpperCase();
            dobj.getValue(this.imgType);
            String imType = "" + this.imgType.value;
            dobj.getValue(this.sopClassUID);
            String sopUID = "" + this.sopClassUID.value;
            if ("OT".equalsIgnoreCase(modality) && "1.2.840.10008.5.1.4.1.1.12.1".equals(sopUID.trim())) {
                return "XA";
            }
            if (imType.indexOf("EN SAVE") >= 0) {
                dobj.getValue(this.burntInAnnot);
                String burntAnnot = "" + this.burntInAnnot.value;
                if ("no".equalsIgnoreCase(burntAnnot)) {
                    imType = "";
                }
            }
            return this.getImageTypeKey(modality, imType);
        }
        return null;
    }

    private String getImageTypeKey(String modality, String imgType) {
        if (imgType.indexOf("EN SAVE") >= 0 || imgType.indexOf("VXTL STATE") >= 0 || imgType.indexOf("3D") >= 0) {
            return "SSAVE";
        }
        if (modality.equals("CT")) {
            modality = imgType.indexOf("LOCALIZER") >= 0 ? modality + "_SCOUT" : modality + "_REGULAR";
        }
        return modality;
    }

    @Override
    public String[] getNeededTags(String modality, String imgType) {
        String[] modTags = (String[])this.tagMap.get(modality = this.getImageTypeKey(modality, imgType));
        if (modTags != null) {
            return modTags;
        }
        int nTags = 0;
        String[] annotTags = null;
        ApStyle as = null;
        String className = this.props.getProperty(modality);
        if (className != null) {
            as = XpApdAnnotation.createApStyle(className);
        }
        String[] defaultTags = XpAnnotationManager.getDefaultTags();
        if (as != null) {
            int i;
            as.reset();
            annotTags = as.getDicomTags();
            nTags = annotTags.length;
            int nDef = defaultTags.length;
            modTags = new String[nTags + nDef];
            for (i = 0; i < nTags; ++i) {
                modTags[i] = annotTags[i];
            }
            for (i = 0; i < nDef; ++i) {
                modTags[nTags + i] = defaultTags[i];
            }
        } else {
            modTags = defaultTags;
        }
        this.tagMap.put(modality, modTags);
        return modTags;
    }

    @Override
    public void reset() {
        for (Map.Entry me : this.map.entrySet()) {
            TimeStampValue tsv = (TimeStampValue)me.getValue();
            if (tsv == null || tsv.am == null) continue;
            tsv.am.dispose();
        }
        this.map.clear();
    }

    private static class TimeStampValue {
        private long timeStamp = 0L;
        private XpAnnotationModel am = null;

        public TimeStampValue(XpAnnotationModel am) {
            this.am = am;
            this.updateTimeStamp();
        }

        public void updateTimeStamp() {
            this.timeStamp = System.currentTimeMillis();
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public XpAnnotationModel getAnnotationModel() {
            return this.am;
        }
    }
}

