/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.appframework;

import com.ge.med.idc.TaskMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class Application {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    public static final String APP_IDENTIFIER_KEY = "APP_IDENTIFIER";
    private final List<ExitListener> exitListeners;
    private final PropertyChangeSupport pcs;
    private transient Map<Object, Object> userData = Collections.synchronizedMap(new HashMap());

    protected Application() {
        this.exitListeners = new ArrayList<ExitListener>();
        this.pcs = new PropertyChangeSupport(this);
    }

    public abstract void initialize(String[] var1);

    public abstract void startup();

    public abstract void ready();

    public abstract void shutdown();

    public final void exit() {
        this.exit(null);
    }

    public void exit(final EventObject event) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (ExitListener listener : Application.this.exitListeners) {
                    if (listener.canExit(event)) continue;
                    return;
                }
                try {
                    for (ExitListener listener : Application.this.exitListeners) {
                        try {
                            listener.willExit(event);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "ExitListener.willExit() failed", e);
                        }
                    }
                    Application.this.shutdown();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "unexpected error in Application.shutdown()", e);
                }
                finally {
                    Application.this.end();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void end() {
        Runtime.getRuntime().exit(0);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        this.pcs.firePropertyChange(e);
    }

    public final void putUserData(Object key, Object data) {
        this.userData.put(key, data);
    }

    public final Object getUserData(Object key) {
        return this.userData.get(key);
    }

    public void addExitListener(ExitListener listener) {
        this.exitListeners.add(listener);
    }

    public void removeExitListener(ExitListener listener) {
        this.exitListeners.remove(listener);
    }

    public ExitListener[] getExitListeners() {
        int size = this.exitListeners.size();
        return this.exitListeners.toArray(new ExitListener[size]);
    }

    public abstract TaskMonitor getDataLoadingMonitor();

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }
}

