/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.commands.CommandControl;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.idc.XpCPICapable;
import com.ge.med.cse.cvf.idc.XpPropagationCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class BaseAction
extends AbstractAction
implements CommandControl {
    private Capable cap_ = null;
    private String[] cmdparams_ = null;
    private static final Logger logger_ = Logger.getLogger(BaseAction.class.getName());
    protected static final String TOOLTIP_SUFFIX = "_TOOLTIP";
    protected static final String NAME_SUFFIX = "_NAME";
    protected static final String ICON_SUFFIX = "_ICON";
    protected static final String SHORT_COMMAND_SUFFIX = "_SHORT_COMMAND";
    protected static final String ACTION_COMMAND_SUFFIX = "_ACTION_COMMAND_KEY";
    protected static final String COMMAND_SYNTAX_SUFFIX = "_COMMAND_SYNTAX";
    protected static final String LONG_DESCRIPTION_SUFFIX = "_LONG_DESCRIPTION";
    private double prevIncr = 0.0;
    private XpImage xiPrev = null;
    public static final String SHORT_COMMAND = "SHORT_COMMAND";
    public static final String COMMAND_SYNTAX = "COMMAND_SYNTAX";
    public static final String SELECTED_KEY = "SwingSelectedKey";

    public BaseAction() {
        this.configure();
    }

    @Override
    public void setCapable(Capable cap) {
        this.cap_ = cap;
    }

    protected Capable getCapable() {
        return this.cap_;
    }

    @Override
    public void setParams(String[] params) {
        this.cmdparams_ = params;
    }

    @Override
    public String[] getParams() {
        return this.cmdparams_;
    }

    protected Logger getLogger() {
        return logger_;
    }

    protected ROICapable getROICapable() {
        return (ROICapable)this.cap_.getCapable(ROICapable.class.getName());
    }

    protected CineCapable getCineCapable() {
        return (CineCapable)this.cap_.getCapable(CineCapable.class.getName());
    }

    protected PanZoomCapable getPanZoomCapable() {
        return (PanZoomCapable)this.cap_.getCapable(PanZoomCapable.class.getName());
    }

    protected WindowLevelCapable getWindowLevelCapable() {
        return (WindowLevelCapable)this.cap_.getCapable(WindowLevelCapable.class.getName());
    }

    protected FrameCapable getFrameCapable() {
        return (FrameCapable)((Object)this.cap_.getCapable(FrameCapable.class.getName()));
    }

    protected CPICapable getCPICapable() {
        return (CPICapable)((Object)this.cap_.getCapable(CPICapable.class.getName()));
    }

    protected XpCPICapable getXpCPICapable() {
        return (XpCPICapable)((Object)this.cap_.getCapable(XpCPICapable.class.getName()));
    }

    protected AnnotCapable getAnnotCapable() {
        return (AnnotCapable)this.cap_.getCapable(AnnotCapable.class.getName());
    }

    protected RowColCapable getRowColCapable() {
        return (RowColCapable)this.cap_.getCapable(RowColCapable.class.getName());
    }

    protected SelectionCapable getSelectionCapable() {
        return (SelectionCapable)this.cap_.getCapable(SelectionCapable.class.getName());
    }

    protected UserAnnoCapable getUserAnnotationCapable() {
        return (UserAnnoCapable)this.cap_.getCapable(UserAnnoCapable.class.getName());
    }

    protected ComponentCapable getComponentCapable() {
        return (ComponentCapable)this.cap_.getCapable(ComponentCapable.class.getName());
    }

    protected ImageOpCapable getImageOpCapable() {
        return (ImageOpCapable)this.cap_.getCapable(ImageOpCapable.class.getName());
    }

    protected ColorMapCapable getColorMapCapable() {
        return (ColorMapCapable)this.cap_.getCapable(ColorMapCapable.class.getName());
    }

    protected XpPropagationCapable getPropagationCapable() {
        return (XpPropagationCapable)this.cap_.getCapable(XpPropagationCapable.class.getName());
    }

    protected JComponent getSelectedViewport() {
        if (this.cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)this.cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            return this.cap_ instanceof XpViewport ? (XpViewport)this.cap_ : null;
        }
        JComponent comp = null;
        do {
            SelectionCapable selectionCapable = selCap = (comp = selCap.getViewportComponent(selCap.getComponentSelection())) instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return comp;
    }

    protected double getImageDefaultWindowWidth() {
        XpImage xi;
        WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
        double windowLevel = 0.0;
        if (winLevelCapable != null && (xi = ((FrameOwner)((Object)winLevelCapable)).getFrame()) != null) {
            windowLevel = xi.getDefaultWindowWidth();
        }
        return windowLevel;
    }

    protected double getImageWWWLIncrement() {
        WindowLevelCapable windowLevelCapable = this.getWindowLevelCapable();
        double result = 0.0;
        if (windowLevelCapable != null) {
            XpImage xi = ((FrameOwner)((Object)windowLevelCapable)).getFrame();
            if (xi != null && xi != this.xiPrev) {
                double winWidth = xi.getDefaultWindowLevel();
                double fraction = Double.parseDouble(CvPropertiesManager.getProperty("cvf.WWWLKeyIncrement.Percentage", "10"));
                this.prevIncr = result = winWidth * fraction / 100.0;
                this.xiPrev = xi;
                return result;
            }
            return this.prevIncr;
        }
        return 0.0;
    }

    protected JComponent getSelectedMainViewport() {
        if (this.cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)this.cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            return this.cap_ instanceof XpViewport ? (XpViewport)this.cap_ : null;
        }
        JComponent comp = null;
        do {
            comp = selCap.getViewportComponent(selCap.getComponentSelection());
            if (selCap instanceof XpViewport && XpReferenceImageApp.isRefPortSelected((XpViewport)((Object)selCap))) {
                int index = XpReferenceImageApp.getSelectedRefPortIndex((XpViewport)((Object)selCap));
                comp = selCap.getViewportComponent(index);
            }
            SelectionCapable selectionCapable = selCap = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return comp;
    }

    protected XpViewport findSelectedViewportByClass(Class c) {
        if (this.cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)this.cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            return c.isInstance(this.cap_) && this.cap_ instanceof XpViewport ? (XpViewport)this.cap_ : null;
        }
        JComponent comp = null;
        do {
            if (c.isInstance(comp = selCap.getViewportComponent(selCap.getComponentSelection())) && comp instanceof XpViewport) {
                return (XpViewport)comp;
            }
            SelectionCapable selectionCapable = selCap = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return null;
    }

    protected XpViewport[] findViewportsByClass(Class c) {
        if (this.cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)this.cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            XpViewport[] xpViewportArray;
            if (c.isInstance(this.cap_) && this.cap_ instanceof XpViewport) {
                XpViewport[] xpViewportArray2 = new XpViewport[1];
                xpViewportArray = xpViewportArray2;
                xpViewportArray2[0] = (XpViewport)this.cap_;
            } else {
                xpViewportArray = null;
            }
            return xpViewportArray;
        }
        JComponent comp = null;
        XpViewport[] comps = new XpViewport[selCap.getNumComponents()];
        do {
            if (c.isInstance(comp = selCap.getViewportComponent(selCap.getComponentSelection())) && comp instanceof XpViewport) {
                for (int i = 0; i < comps.length; ++i) {
                    comp = selCap.getViewportComponent(i);
                    if (!c.isInstance(comp) || !(comp instanceof XpViewport)) continue;
                    comps[i] = (XpViewport)comp;
                }
                return comps;
            }
            SelectionCapable selectionCapable = selCap = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return null;
    }

    protected String getCurrentModality() {
        if (this.cap_ == null) {
            return null;
        }
        return CvUtils.getCurrentModality(this.cap_);
    }

    protected ResourceBundle getResourceBundle() {
        return CvUtils.getResourceBundle();
    }

    protected void configure() {
        String namePrefix = this.getName();
        String strName = this.getI18NString(namePrefix + NAME_SUFFIX);
        String strShortName = this.getI18NString(namePrefix + SHORT_COMMAND_SUFFIX);
        String strActCmd = this.getI18NString(namePrefix + ACTION_COMMAND_SUFFIX);
        String strLongDesc = this.getI18NString(namePrefix + LONG_DESCRIPTION_SUFFIX);
        String strCmdSntx = this.getI18NString(namePrefix + COMMAND_SYNTAX_SUFFIX);
        String strToolTip = this.getI18NString(namePrefix + TOOLTIP_SUFFIX);
        Icon icon = CvUtils.getIcon(this.getName() + ICON_SUFFIX);
        this.putValue("Name", strName);
        this.putValue(SHORT_COMMAND, strShortName);
        this.putValue("ActionCommandKey", strActCmd);
        this.putValue("LongDescription", strLongDesc);
        this.putValue(COMMAND_SYNTAX, strCmdSntx);
        this.putValue("ShortDescription", strToolTip);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
    }

    protected String getI18NString(String s) {
        String istr = null;
        try {
            istr = this.getResourceBundle().getString(s);
            if (istr.equals("")) {
                istr = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return istr;
    }

    protected XpMedicalImage getFrame() {
        FrameCapable fcap = (FrameCapable)((Object)this.getSelectionCapable().getViewportComponent(this.getSelectionCapable().getComponentSelection()));
        if (null != fcap && null != fcap.getFrame()) {
            return (XpMedicalImage)fcap.getFrame();
        }
        return null;
    }

    protected abstract String getName();

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setToolTip(String toolTip) {
        this.putValue("ShortDescription", toolTip);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setMenonicKey(int key) {
        this.putValue("MnemonicKey", new Integer(key));
    }

    protected void setActionCommand(String command2) {
        this.putValue("ActionCommandKey", command2);
    }

    protected void setSelected(boolean selected) {
        this.putValue(SELECTED_KEY, new Boolean(selected));
    }

    protected void setShortCommand(String shortCmd) {
        this.putValue(SHORT_COMMAND, shortCmd);
    }

    protected void setCommandSyntax(String cmdSyntax) {
        this.putValue(COMMAND_SYNTAX, cmdSyntax);
    }

    protected void setDescription(String desc) {
        this.putValue("LongDescription", desc);
    }
}

