/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpSelectableOwner;
import com.ge.med.terra.jami.XpSelectionManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class CVSelectionManager
implements XpSelectionManager {
    private List selected = new ArrayList();

    @Override
    public final List getSelected() {
        return this.selected;
    }

    @Override
    public final void addComponent(Component c) {
        if (c instanceof XpSelectableOwner) {
            XpSelectableOwner so = (XpSelectableOwner)((Object)c);
            Selectable[] s = so.getSelectable();
            if (s != null) {
                for (int i = 0; i < s.length; ++i) {
                    this.addSelectable(s[i]);
                }
            }
        } else if (c instanceof Selectable) {
            this.addSelectable((Selectable)((Object)c));
        }
        c.addMouseListener(this);
    }

    @Override
    public final void removeComponent(Component c) {
        if (c instanceof XpSelectableOwner) {
            XpSelectableOwner so = (XpSelectableOwner)((Object)c);
            Selectable[] s = so.getSelectable();
            if (s != null) {
                for (int i = 0; i < s.length; ++i) {
                    this.removeSelectable(s[i]);
                }
            }
        } else if (c instanceof Selectable) {
            this.removeSelectable((Selectable)((Object)c));
        }
        c.removeMouseListener(this);
    }

    @Override
    public final void addSelectable(Selectable s) {
        if (s != null) {
            this.clearSelection();
            this.select(s);
        }
    }

    @Override
    public final void removeSelectable(Selectable s) {
        if (s != null) {
            this.selected.remove(s);
            s.setSelected(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    private void select(Selectable s) {
        s.setSelected(true);
        if (s.isSelected()) {
            this.selected.add(s);
        }
    }

    private void doSelect(MouseEvent me) {
        boolean multi = 0 != (me.getModifiers() & 2);
        Object source = me.getSource();
        if (source instanceof XpSelectableOwner) {
            Selectable[] sel;
            if (!multi) {
                this.clearSelection();
            }
            XpSelectableOwner so = (XpSelectableOwner)source;
            List rois = null;
            List uas = null;
            if (source instanceof XpImageRoiVc) {
                XpImageRoiVc roivc = (XpImageRoiVc)source;
                ROICapable rc = (ROICapable)((Object)roivc.findParentByClass(roivc, ROICapable.class));
                if (rc != null) {
                    rois = rc.getRois();
                }
                if (rc instanceof UserAnnoCapable) {
                    uas = ((UserAnnoCapable)((Object)rc)).getUserAnnos();
                }
            } else if (source instanceof XpUserAnnotationVc) {
                XpUserAnnotationVc uavc = (XpUserAnnotationVc)source;
                UserAnnoCapable uac = (UserAnnoCapable)((Object)uavc.findParentByClass(uavc, UserAnnoCapable.class));
                if (uac != null) {
                    uas = uac.getUserAnnos();
                }
                if (uac instanceof ROICapable) {
                    rois = ((ROICapable)((Object)uac)).getRois();
                }
            }
            if (rois != null || uas != null) {
                int len = this.selected.size();
                for (int i = 0; i < len; ++i) {
                    Selectable s = (Selectable)this.selected.get(0);
                    if (s instanceof RoiActor && rois != null) {
                        if (rois.contains(s)) continue;
                        this.removeSelectable(s);
                        continue;
                    }
                    if (!(s instanceof XpUserAnnotationModel) || uas == null || uas.contains(s)) continue;
                    this.removeSelectable(s);
                }
            }
            if ((sel = so.getSelectable()) != null) {
                for (int i = 0; i < sel.length; ++i) {
                    this.select(sel[i]);
                }
            }
        } else {
            this.clearSelection();
        }
        Component c = (Component)source;
        c.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Object o = me.getSource();
        if (o instanceof Component) {
            ((Component)o).requestFocusInWindow();
        }
        this.doSelect(me);
    }

    @Override
    public final void clearSelection() {
        int len = this.selected.size();
        for (int i = 0; i < len; ++i) {
            Selectable s = (Selectable)this.selected.get(i);
            if (!s.isSelected()) continue;
            s.setSelected(false);
        }
        this.selected.clear();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    @Override
    public void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    @Override
    public void removePropertyChangeListener(String arg0, PropertyChangeListener arg1) {
    }
}

