/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class XpFrameLinkDirector
implements XpViewportDirector {
    private ArrayList<XpViewport> portList = new ArrayList();
    public static final String FRAME_OFFSET_PROPERTY = "frame_offset";
    PropertyChangeListener frameIndexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            XpFrameLinkDirector.this.notifyFrameChange(pce);
        }
    };

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport.getCapable(FramePositioningCapable.class.getName()) != null) {
            this.portList.add(viewport);
            FramePositioningCapable fpc = (FramePositioningCapable)viewport.getCapable(FramePositioningCapable.class.getName());
            if (fpc != null) {
                int offset = fpc.getFrameIndex();
                if (offset < 0) {
                    offset = 0;
                }
                viewport.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(offset));
                viewport.addPropertyChangeListener("FrameIndex", this.frameIndexListener);
            }
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            XpViewport port = this.portList.get(i);
            port.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(0));
            port.removePropertyChangeListener("FrameIndex", this.frameIndexListener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            viewport.removePropertyChangeListener("FrameIndex", this.frameIndexListener);
            viewport.putClientProperty(FRAME_OFFSET_PROPERTY, new Integer(0));
            this.portList.remove(viewport);
        }
    }

    protected void notifyFrameChange(PropertyChangeEvent pce) {
        XpViewport source = (XpViewport)pce.getSource();
        int frameIndex = (Integer)pce.getNewValue();
        int srcInitialOffset = (Integer)source.getClientProperty(FRAME_OFFSET_PROPERTY);
        int srcPortFrameIndexChange = frameIndex - srcInitialOffset;
        boolean adjustSrcIndex = false;
        for (int i = 0; i < this.portList.size(); ++i) {
            int totalFrames;
            FramePositioningCapable fpc;
            XpViewport port = this.portList.get(i);
            if (port == source || (fpc = (FramePositioningCapable)port.getCapable(FramePositioningCapable.class.getName())) == null || fpc == source || (totalFrames = fpc.getNumFrames()) <= 0) continue;
            int initialOffset = (Integer)port.getClientProperty(FRAME_OFFSET_PROPERTY);
            int frameIndex2Set = srcPortFrameIndexChange + initialOffset;
            int currentFrameIndex = fpc.getFrameIndex();
            if (frameIndex2Set < 0) {
                if (currentFrameIndex > 0) {
                    fpc.setFrameIndex(0);
                    adjustSrcIndex = true;
                }
            } else if (frameIndex2Set >= totalFrames) {
                if (currentFrameIndex != totalFrames - 1) {
                    fpc.setFrameIndex(totalFrames - 1);
                    adjustSrcIndex = true;
                }
            } else {
                fpc.setFrameIndex(frameIndex2Set);
            }
            fpc.repaint();
        }
        if (adjustSrcIndex) {
            final XpViewport src = source;
            final int idx = srcPortFrameIndexChange + srcInitialOffset;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((FramePositioningCapable)src).setFrameIndex(idx);
                    src.repaint();
                }
            });
            adjustSrcIndex = false;
        }
    }
}

