/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpZoomSlider
extends JSlider
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    StateChangeListener listener = null;
    private boolean vplistner = true;
    Logger logger = Logger.getLogger(this.getClass().getName());
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "zoom") {
                XpZoomSlider.this.updateZoomSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                XpZoomSlider.this.updateZoomSetting();
            }
        }
    };

    public XpZoomSlider() {
        this.setPreferredSize(new Dimension(300, 50));
        this.init();
    }

    public XpZoomSlider(boolean vpListenr) {
        this.vplistner = vpListenr;
        this.init();
    }

    private void init() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBackground(null);
    }

    public void setData(DMObject[] objs) {
    }

    public void removeChangeListener() {
        this.removeChangeListener(this.listener);
    }

    private void jbInit() throws Exception {
        this.setToolTipText(res.getString("Zoom_Slider_"));
        this.listener = new StateChangeListener();
        this.addChangeListener(this.listener);
    }

    public Double getZoom() {
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable(PanZoomCapable.class.getName());
        if (pz == null) {
            return null;
        }
        return new Double(pz.getZoom());
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        PanZoomCapable pz;
        if (this.vplistner && (pz = (PanZoomCapable)this.panelSeek.getCapable(PanZoomCapable.class.getName())) != null) {
            this.updateZoomSetting();
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        if (this.vplistner) {
            screen.addPropertyChangeListener(this.viewPortListener);
        }
    }

    public void removePropertyChangeListener() {
        if (this.screen != null) {
            this.screen.removePropertyChangeListener(this.viewPortListener);
        }
    }

    private void updateZoomSetting() {
        int zoomVal;
        PanZoomCapable pz = this.panelSeek.getPZPort();
        if (pz != null && (zoomVal = (int)(pz.getZoom() * 100.0)) != this.getValue()) {
            this.setValue(zoomVal);
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    class StateChangeListener
    implements ChangeListener {
        StateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            PanZoomCapable pz = (PanZoomCapable)XpZoomSlider.this.panelSeek.getCapable(PanZoomCapable.class.getName());
            if (pz != null) {
                XpZoomSlider.this.logger.log(Level.FINE, "{0} begin");
                int val = XpZoomSlider.this.getValue();
                double zoom = (double)val / 100.0;
                pz.setZoom(zoom);
                XpZoomSlider.this.logger.log(Level.FINE, "{0} end");
            } else {
                XpZoomSlider.this.logger.log(Level.INFO, "not PanZoomCapable");
            }
        }
    }
}

